package cn.yunrui.bizservices.ebikemgmt.dao;

import cn.yunrui.bizservices.ebikemgmt.entity.ChargeRequest;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeResponse;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 *
 */
public interface ChargeDao {

    /**
     * 检查是否充电中
     * @param chargeplugId
     *               充电插座标识
     * @return true : 正在充电中；false : 不在充电中
     */
    boolean checkIsCharging(Long chargeplugId);

    /**
     *
     * @param chargeTradeOrderId
     *              充电交易订单ID
     * @return ChargeRequest
     */
    ChargeRequest buildChargeRequestPaySuccessWithnoCharging(String chargeTradeOrderId);

    /**
     *
     * @param chargeTradeOrderId
     *              充电交易订单ID
     * @return true / false
     */
    boolean checkIsBeChargedByChargeTradeOrderId(String chargeTradeOrderId);

    /**
     * 插入充电请求日志
     * @param chargeRequest
     *              充电请求
     * @param chargeRecordId
     *              充电记录标识
     * @return 大于0表示插入成功
     */
    int insertChargeRequestLog(Date requestTime, ChargeRequest chargeRequest, String chargeRecordId);

    /**
     * 更新充电请求日志
     * @param chargeResponse
     *              充电回应
     * @param chargeRecordId
     *              充电记录标识
     * @return 大于0表示插入成功
     */
    int updateChargeRequestLog(Date responseTime, ChargeResponse chargeResponse, String chargeRecordId, Boolean gnrtChargeRecord, String gnrtFailReason);

    List<Map<String, Object>> getGnrtFailedChargeRequestList(Date startTime, Date endTime);

    int updateChargeRequestLogByReturn(String chargeRecordId, String returnFlag, BigDecimal returnMoney, Date returnTime, String returnDesc, String returnTradeOrderId);

    int updateChargeRequestLogByReturnResult(String chargeTradeOrderId, String returnTradeOrderId, String returnFlag, Date returnSuccessTime);

    int updateChargePrepayOrderLog(String chargeTradeOrderId, int payFlag, Date paySuccTime, String payFailReason);

    /**
     * 插入充电记录
     * @param chargeRecordMap
     *              充电记录
     * @return 大于0表示插入成功
     */
    int insertChargeRecord(Map<String, Object> chargeRecordMap);

    /**
     * 通过充电插座编号获取充电插座标识
     * @param orgNo
     *              单位编号
     * @param chargeplugNo
     *              充电插座编号
     * @return 充电插座标识
     */
    Long getChargeplugIdByChargeplugNo(String orgNo, String chargeplugNo);

    /**
     * 通过充电插座编号获取充电插座值集合
     * @param orgNo
     *              单位编号
     * @param chargeplugNo
     *              充电插座编号
     * @return 充电插座值集合
     */
    Map<String, Object> getChargePlugValueMap(String orgNo, String chargeplugNo);

    /**
     * 通过充电用户编号和充电用户类型获取充电用户标识
     * @param chargeUserNo
     *              充电用户编号
     * @param chargeUserType
     *              充电用户类型：10 – 微信用户； 20 – 卡用户；
     * @return 充电用户标识
     */
    String getChargeUserIdByChargeUserNo(String chargeUserNo, String chargeUserType);

}
