package cn.yunrui.bizservices.ebikemgmt.dao;

import cn.yunrui.bizservices.ebikemgmt.entity.CostSchemeInfo;

/**
 *
 */
public interface CostSchemeDao {

    /**
     * 通过电费成本方案标识获取电费成本方案信息
     * @param costSchemeId
     *              电费成本方案标识
     * @return 电费成本方案信息
     */
    CostSchemeInfo getCostSchemeInfoById(String costSchemeId);

    /**
     * 通过电费成本方案编号获取电费成本方案信息
     * @param orgNo
     *              单位编号
     * @param costSchemeNo
     *              电费成本方案编号
     * @return 电费成本方案信息
     */
    CostSchemeInfo getCostSchemeInfoByNo(String orgNo, String costSchemeNo);

    /**
     * 通过充电设备标识获取电费成本方案信息
     * @param chargedeviceId
     *              充电设备标识
     * @return 电费成本方案信息
     */
    CostSchemeInfo getCostSchemeInfoByChargedeviceId(Long chargedeviceId);

    /**
     * 通过充电设备编号获取电费成本方案信息
     * @param orgNo
     *              单位编号
     * @param chargedeviceNo
     *              充电设备编号
     * @return 电费成本方案信息
     */
    CostSchemeInfo getCostSchemeInfoByChargedeviceNo(String orgNo, String chargedeviceNo);

}
