package cn.yunrui.bizservices.ebikemgmt.dao;

import cn.yunrui.bizservices.ebikemgmt.entity.*;

/**
 *
 */
public interface FitConnectDao {

    /**
     * 从资产库中获取充电设备信息
     * @param orgNo
     *              单位编号
     * @param chargedeviceNo
     *              充电设备编号
     * @return 充电设备信息
     */
    ChargeDeviceInfo getChargeDeviceInfoFromAssetsRepo(String orgNo, String chargedeviceNo);

    /**
     * 插入设备装接日志表
     * @param fitConnectRequest
     *              装接服务请求
     * @param fitConnectResponse
     *              装接服务回应
     * @param fitconnectType
     *              装接类型：fitconnect – 装接；dismantle – 拆除；
     * @return 大于0表示插入成功
     */
    int insertFitconnRequestLog(FitConnectRequest fitConnectRequest, FitConnectResponse fitConnectResponse, String fitconnectType);

    /**
     * 初始化充电设备状态
     * @param chargedeviceId
     *              充电设备标识
     */
    void initChargeDeviceStatus(Long chargedeviceId);

    /**
     * 初始化充电插座状态
     * @param chargeplugIds
     *              充电插座标识数组
     */
    void initChargePlugStatus(Long[] chargeplugIds);

    /**
     * 更新充电设备资产信息（资产库）
     * @param orgNo
     *              单位编号
     * @param chargedeviceNo
     *              充电设备编号
     * @param status
     *              设备状态
     * @param chargedeviceId
     *              充电设备标识
     */
    void updateDeviceAssertInfo(String orgNo, String chargedeviceNo, String status, Long chargedeviceId);

}
