package cn.yunrui.bizservices.ebikemgmt.entity;

import lombok.Data;

import java.io.Serializable;

/**
 * 计费方案信息
 */
@Data
public class BillingSchemeInfo implements Serializable {

    private String schemeId;            // 计费方案标识
    private String buro;                // 管理单位
    private String subburo;             // 维护单位
    private String schemeNo;            // 计费方案编号
    private String schemeName;          // 计费方案名称
    private String schemeType;          // 计费方案类型：01 – 计时间； 02 – 计电量；03 – 计次（按时间）；
    private Double unitPrice1;          // 计费单价1
    private Double unitPrice2;          // 计费单价2
    private Double unitPrice3;          // 计费单价3
    private Double unitPrice4;          // 计费单价4
    private Double unitPrice5;          // 计费单价5
    private Integer stepCount;          // 功率阶梯数
    private Integer stepPower1;         // 阶梯功率1，单位为W
    private Integer stepPower2;         // 阶梯功率2，单位为W
    private Integer stepPower3;         // 阶梯功率3，单位为W
    private Integer stepPower4;         // 阶梯功率4，单位为W
    private Double minCharge;           // 最低消费金额
    private String isReturn;            // 是否退费：Y 是 N 否
    private Integer closingPeriod;      // 计费结算周期，单位为分钟
    private Integer maxChargeTime;      // 最大充电时长，单位为分钟（免费计费方案时有效）
    private String schemeDetails;         // 模板详细
    private Double chargeServiceFee;    // 充电服务费
    private Double elecLossFee;         // 转供电损耗费
    private Double elecCost;         // 电度单价
}
