package cn.yunrui.bizservices.ebikemgmt.entity;

import java.io.Serializable;

/**
 * 充电请求（微信及投币支付）
 *
 * @author Nick Zhang
 * @date 2019-07-09
 */
public class ChargeRequest implements Serializable {

    private String orgNo;                       // 单位编号
    private String chargeplugNo;                // 充电插座编号（充电设备编号 + 2位插座序号（如：01、02、…））
    private String chargeUserNo;                // 充电用户名：如为“微信用户“，则充电用户名为微信标识；如为“卡用户“，则充电用户名为卡号；
    private String chargeUserType;              // 充电用户类型：10 - 微信用户；20 - 支付宝用户；30 - 微信小程序用户；90 - 投币用户
    private String type;                        // start - 开始充电；stop - 结束充电
    private Double money;                       // 充电金额
    private String chargeTradeOrderId;          // 充电交易订单ID
    private String enterUserType;               // 入账账户类型：ebike_transit - 驿吧平台在途资金
    private String enterUserId;                 // 入账账户标识：10000000 - 驿吧平台

    public String getOrgNo() {
        return orgNo;
    }

    public void setOrgNo(String orgNo) {
        this.orgNo = orgNo;
    }

    public String getChargeplugNo() {
        return chargeplugNo;
    }

    public void setChargeplugNo(String chargeplugNo) {
        this.chargeplugNo = chargeplugNo;
    }

    public String getChargeUserNo() {
        return chargeUserNo;
    }

    public void setChargeUserNo(String chargeUserNo) {
        this.chargeUserNo = chargeUserNo;
    }

    public String getChargeUserType() {
        return chargeUserType;
    }

    public void setChargeUserType(String chargeUserType) {
        this.chargeUserType = chargeUserType;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Double getMoney() {
        return money;
    }

    public void setMoney(Double money) {
        this.money = money;
    }

    public String getChargeTradeOrderId() {
        return chargeTradeOrderId;
    }

    public void setChargeTradeOrderId(String chargeTradeOrderId) {
        this.chargeTradeOrderId = chargeTradeOrderId;
    }

    public String getEnterUserType() {
        return enterUserType;
    }

    public void setEnterUserType(String enterUserType) {
        this.enterUserType = enterUserType;
    }

    public String getEnterUserId() {
        return enterUserId;
    }

    public void setEnterUserId(String enterUserId) {
        this.enterUserId = enterUserId;
    }

    @Override
    public String toString() {
        return "ChargeRequest{" +
                "orgNo='" + orgNo + '\'' +
                ", chargeplugNo='" + chargeplugNo + '\'' +
                ", chargeUserNo='" + chargeUserNo + '\'' +
                ", chargeUserType='" + chargeUserType + '\'' +
                ", type='" + type + '\'' +
                ", money=" + money +
                ", chargeTradeOrderId='" + chargeTradeOrderId + '\'' +
                ", enterUserType='" + enterUserType + '\'' +
                ", enterUserId='" + enterUserId + '\'' +
                '}';
    }
}
