package cn.yunrui.bizservices.ebikemgmt.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * 充电回应
 *
 * @author Nick Zhang
 * @date 2019-07-09
 */
public class ChargeResponse implements Serializable {

    /**
     * 为0表示成功；为负表示失败
     */
    private int status;
    private String msg;
    private String chargeRecordId;

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getChargeRecordId() {
        return chargeRecordId;
    }

    public void setChargeRecordId(String chargeRecordId) {
        this.chargeRecordId = chargeRecordId;
    }

    @Override
    public String toString() {
        return "ChargeResponse{" +
                "status=" + status +
                ", msg='" + msg + '\'' +
                ", chargeRecordId='" + chargeRecordId + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if(this == o) return true;
        if(o == null || getClass() != o.getClass()) return false;
        ChargeResponse that = (ChargeResponse) o;
        return status == that.status &&
                Objects.equals(msg, that.msg) &&
                Objects.equals(chargeRecordId, that.chargeRecordId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(status, msg, chargeRecordId);
    }

}
