package cn.yunrui.bizservices.ebikemgmt.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * 装接调试请求
 */
public class DebugRequest implements Serializable {

    private String orgNo;                       // 单位编号
    private String operator;                    // 操作员
    private String chargeplugNo;                // 充电插座编号（充电设备编号 + 2位插座序号（如：01、02、…））
    private String debugType;                   // start - 开始充电；stop - 结束充电

    public String getOrgNo() {
        return orgNo;
    }

    public void setOrgNo(String orgNo) {
        this.orgNo = orgNo;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getChargeplugNo() {
        return chargeplugNo;
    }

    public void setChargeplugNo(String chargeplugNo) {
        this.chargeplugNo = chargeplugNo;
    }

    public String getDebugType() {
        return debugType;
    }

    public void setDebugType(String debugType) {
        this.debugType = debugType;
    }

    @Override
    public String toString() {
        return "DebugRequest{" +
                "orgNo='" + orgNo + '\'' +
                ", operator='" + operator + '\'' +
                ", chargeplugNo='" + chargeplugNo + '\'' +
                ", debugType='" + debugType + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if(this == o) return true;
        if(o == null || getClass() != o.getClass()) return false;
        DebugRequest that = (DebugRequest) o;
        return Objects.equals(orgNo, that.orgNo) &&
                Objects.equals(operator, that.operator) &&
                Objects.equals(chargeplugNo, that.chargeplugNo) &&
                Objects.equals(debugType, that.debugType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orgNo, operator, chargeplugNo, debugType);
    }

}
