package cn.yunrui.bizservices.ebikemgmt.service;

import cn.yunrui.bizservices.ebikemgmt.entity.ChargeRequest;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeResponse;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 充电自行车充电服务
 */
public interface ChargeService {

    /**
     * 充电服务
     * @param chargeRequest
     *              充电服务请求
     * @return 充电服务响应
     */
    ChargeResponse charge(ChargeRequest chargeRequest);

    void updateChargePrepayOrderLog(String chargeTradeOrderId, int payFlag, Date paySuccTime, String payFailReason);

    ChargeRequest buildChargeRequestPaySuccessWithnoCharging(String chargeTradeOrderId);

    List<Map<String, Object>> getGnrtFailedChargeRequestList(Date startTime, Date endTime);

    void updateChargeRequestLogByReturn(String chargeRecordId, String returnFlag, BigDecimal returnMoney, Date returnTime, String returnDesc, String returnTradeOrderId);

    void updateChargeRequestLogByReturnResult(String chargeTradeOrderId, String returnTradeOrderId, String returnFlag, Date returnSuccessTime);

}
