package cn.yunrui.bizservices.ebikemgmt.dao.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.CostSchemeDao;
import cn.yunrui.bizservices.ebikemgmt.entity.CostSchemeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import java.util.ArrayList;
import java.util.List;

/**
 *
 */
public class CostSchemeDaoImpl implements CostSchemeDao {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final RowMapper<CostSchemeInfo> csiRowMapper = (rs, rowNum) -> {
        CostSchemeInfo csi = new CostSchemeInfo();
        csi.setCostSchemeId(rs.getString(1));
        csi.setBuro(rs.getString(2));
        csi.setSubburo(rs.getString(3));
        csi.setCostSchemeNo(rs.getString(4));
        csi.setCostSchemeName(rs.getString(5));
        csi.setCostUnitPrice(rs.getDouble(6));
        return csi;
    };

    private StringBuilder builderCostSchemePreSQL() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT ecs.costSchemeId, ecs.buro, ecs.subburo, ecs.costSchemeNo, ecs.costSchemeName, ecs.costUnitPrice ");
        sqlBuilder.append("  FROM ebike.ebike_costscheme ecs ");
        return sqlBuilder;
    }

    private final JdbcTemplate ebikeJdbcTemplate;

    public CostSchemeDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public CostSchemeInfo getCostSchemeInfoById(String costSchemeId) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getCostSchemeInfoById >>>>>>> ");
            logger.debug(" costSchemeId : " + costSchemeId);
        }
        StringBuilder sqlBuilder = builderCostSchemePreSQL();
        List<Object> params = new ArrayList<>();
        sqlBuilder.append(" WHERE ecs.costSchemeId = ? ");
        params.add(costSchemeId);
        CostSchemeInfo csi;
        try {
            csi = ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), csiRowMapper);
        }
        catch(EmptyResultDataAccessException erdae) {
            csi = null;
        }
        return csi;
    }

    @Override
    public CostSchemeInfo getCostSchemeInfoByNo(String orgNo, String costSchemeNo) {
        StringBuilder sqlBuilder = builderCostSchemePreSQL();
        List<Object> params = new ArrayList<>();
        sqlBuilder.append(" WHERE ecs.buro = ? AND ecs.subburo = ? AND ecs.costSchemeNo = ? ");
        params.add(orgNo);
        params.add(orgNo);
        params.add(costSchemeNo);
        sqlBuilder.append(" LIMIT 1 ");
        CostSchemeInfo csi;
        try {
            csi = ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), csiRowMapper);
        }
        catch(EmptyResultDataAccessException erdae) {
            csi = null;
        }
        return csi;
    }

    @Override
    public CostSchemeInfo getCostSchemeInfoByChargedeviceId(Long chargedeviceId) {
        StringBuilder sqlBuilder = builderCostSchemePreSQL();
        List<Object> params = new ArrayList<>();
        sqlBuilder.append(" INNER JOIN ebike.ebike_cs_cs_rela ccr ON ccr.costSchemeId = ecs.costSchemeId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.chargestationId = ccr.chargestationId ");
        sqlBuilder.append(" WHERE ecd.`id` = ? ");
        params.add(chargedeviceId);
        sqlBuilder.append(" LIMIT 1 ");
        CostSchemeInfo csi;
        try {
            csi = ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), csiRowMapper);
        }
        catch(EmptyResultDataAccessException erdae) {
            csi = null;
        }
        return csi;
    }

    @Override
    public CostSchemeInfo getCostSchemeInfoByChargedeviceNo(String orgNo, String chargedeviceNo) {
        StringBuilder sqlBuilder = builderCostSchemePreSQL();
        List<Object> params = new ArrayList<>();
        sqlBuilder.append(" INNER JOIN ebike.ebike_cs_cs_rela ccr ON ccr.costSchemeId = ecs.costSchemeId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.chargestationId = ccr.chargestationId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_powersystemresource pss ON pss.`id` = ecd.`id` AND pss.className = 'EBikeChargeDevice' ");
        sqlBuilder.append(" WHERE pss.buro = ? AND pss.subburo = ? AND ecd.chargedeviceNo = ? ");
        params.add(orgNo);
        params.add(orgNo);
        params.add(chargedeviceNo);
        sqlBuilder.append(" LIMIT 1 ");
        CostSchemeInfo csi;
        try {
            csi = ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), csiRowMapper);
        }
        catch(EmptyResultDataAccessException erdae) {
            csi = null;
        }
        return csi;
    }

}
