package cn.yunrui.bizservices.ebikemgmt.dao.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.DebugDao;
import cn.yunrui.bizservices.ebikemgmt.entity.DebugRequest;
import cn.yunrui.bizservices.ebikemgmt.entity.DebugResponse;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DebugDaoImpl implements DebugDao {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final JdbcTemplate ebikeJdbcTemplate;

    public DebugDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public int insertFitconnDebuggingLog(DebugRequest debugRequest, DebugResponse debugResponse) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start insertFitconnDebuggingLog >>>>>> ");
            logger.debug(" debugRequest     : " + (debugRequest != null ? debugRequest.toString() : null));
            logger.debug(" debugResponse    : " + (debugResponse != null ? debugResponse.toString() : null));
        }
        String sql = "INSERT INTO ebike.ebike_log_fitconndebugging(debugTime, buro, subburo, chargeplugNo, debugType, operator, responseStatus, responseMsg) VALUES (?, ?, ?, ?, ?, ?, ?, ?) ";
        List<Object> params = new ArrayList<>();
        params.add(new Date());                                                                     // debugTime
        params.add(ObjectUtils.isNotNull(debugRequest) ? debugRequest.getOrgNo() : null);           // buro
        params.add(ObjectUtils.isNotNull(debugRequest) ? debugRequest.getOrgNo() : null);           // subburo
        params.add(ObjectUtils.isNotNull(debugRequest) ? debugRequest.getChargeplugNo() : null);    // chargeplugNo
        params.add(ObjectUtils.isNotNull(debugRequest) ? debugRequest.getDebugType() : null);       // debugType
        params.add(ObjectUtils.isNotNull(debugRequest) ? debugRequest.getOperator() : null);        // operator
        params.add(ObjectUtils.isNotNull(debugResponse) ? debugResponse.getStatus() : null);        // responseStatus
        params.add(ObjectUtils.isNotNull(debugResponse) ? debugResponse.getMsg() : null);           // responseMsg
        return ebikeJdbcTemplate.update(sql, params.toArray());
    }

}
