package cn.yunrui.bizservices.ebikemgmt.dao.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.FitConnectDao;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeDeviceInfo;
import cn.yunrui.bizservices.ebikemgmt.entity.FitConnectRequest;
import cn.yunrui.bizservices.ebikemgmt.entity.FitConnectResponse;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 *
 */
public class FitConnectDaoImpl implements FitConnectDao {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final JdbcTemplate ebikeJdbcTemplate;

    public FitConnectDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public ChargeDeviceInfo getChargeDeviceInfoFromAssetsRepo(String orgNo, String chargedeviceNo) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getChargeDeviceInfoFromAssetsRepo >>>>>> ");
            logger.debug(" orgNo            : " + orgNo);
            logger.debug(" chargedeviceNo   : " + chargedeviceNo);
        }
        if(StringUtils.isNotBlank(orgNo) && StringUtils.isNotBlank(chargedeviceNo)) {
            StringBuilder sqlBuilder = new StringBuilder();
            List<Object> params = new ArrayList<>();
            sqlBuilder.append("SELECT eac.buro, eac.subburo, eac.chargedeviceNo, eac.deviceId, eac.protocolType, eac.protocolVersion, eac.plugCount, eac.factory, eac.modelNo ");
            sqlBuilder.append("     , eac.`status`, eac.chargedeviceId, eac.importTime, eac.installTime, eac.runTime, eac.dismantleTime ");
            sqlBuilder.append("  FROM ebike.ebike_assets_chargedevice eac ");
            sqlBuilder.append(" WHERE (eac.buro = ? OR eac.buro = '0' OR eac.buro = '000000000') ");
            params.add(orgNo);
            sqlBuilder.append("   AND (eac.subburo = ? OR eac.subburo = '0' OR eac.subburo = '000000000') ");
            params.add(orgNo);
            sqlBuilder.append("   AND eac.chargedeviceNo = ? ");
            params.add(chargedeviceNo);
            ChargeDeviceInfo cdi;
            try {
                cdi = ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), (rs, rowNum) -> {
                    ChargeDeviceInfo cdiTemp = new ChargeDeviceInfo();
                    cdiTemp.setOrgNo(rs.getString(2));
                    cdiTemp.setChargedeviceNo(rs.getString(3));
                    cdiTemp.setDeviceId(rs.getString(4));
                    cdiTemp.setProtocolType(rs.getString(5));
                    cdiTemp.setProtocolVersion(rs.getString(6));
                    cdiTemp.setPlugCount(rs.getInt(7));
                    cdiTemp.setChargedeviceFactory(rs.getString(8));
                    cdiTemp.setChargedeviceModelNo(rs.getString(9));

                    if(StringUtils.isNotBlank(rs.getString(10))) {
                        cdiTemp.setStatus(rs.getString(10));
                    }
                    else {
                        cdiTemp.setStatus("00");                                    // 设备状态默认为00库存
                    }

                    if(rs.getObject(11) != null && rs.getLong(11) > 0) {
                        cdiTemp.setChargedeviceId(rs.getLong(11));
                    }
                    if(rs.getObject(12) != null) {
                        cdiTemp.setImportTime(new Date(rs.getTimestamp(12).getTime()));
                    }
                    if(rs.getObject(13) != null) {
                        cdiTemp.setInstallTime(new Date(rs.getTimestamp(13).getTime()));
                    }
                    if(rs.getObject(14) != null) {
                        cdiTemp.setRunTime(new Date(rs.getTimestamp(14).getTime()));
                    }
                    if(rs.getObject(15) != null) {
                        cdiTemp.setDismantleTime(new Date(rs.getTimestamp(15).getTime()));
                    }
                    return cdiTemp;
                });
            }
            catch(EmptyResultDataAccessException _erdae) {
                cdi = null;
            }
            return cdi;
        }
        return null;
    }

    @Override
    public int insertFitconnRequestLog(FitConnectRequest fitConnectRequest, FitConnectResponse fitConnectResponse, String fitconnectType) {
        // TODO: 2018-02-08 insertFitconnRequestLog
        return 0;
    }

    @Override
    public void initChargeDeviceStatus(Long chargedeviceId) {
        if(chargedeviceId != null && chargedeviceId > 0L) {
            String sql = "INSERT INTO ebike.ebike_chargedevice_ops(chargedeviceId, opStatus) SELECT `ID`, '0' FROM cisp_dev.dev_ebikechargedevice WHERE `ID` = ? ON DUPLICATE KEY UPDATE opStatus = VALUES(opStatus) ";
            ebikeJdbcTemplate.update(sql, chargedeviceId);
        }
    }

    @Override
    public void initChargePlugStatus(final Long[] chargeplugIds) {
        if(chargeplugIds != null && chargeplugIds.length > 0) {
            String sql = "INSERT INTO ebike.ebike_chargeplug_ops(chargeplugId, opStatus, opStatusTime) SELECT `ID`, '9', ? FROM cisp_dev.dev_ebikechargeplug WHERE `ID` = ? ON DUPLICATE KEY UPDATE opStatus = VALUES(opStatus), opStatusTime = VALUES(opStatusTime) ";
            ebikeJdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter() {

                @Override
                public int getBatchSize() {
                    return chargeplugIds.length;
                }

                @Override
                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    ps.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    ps.setLong(2, chargeplugIds[i]);
                }

            });
        }
    }

    @Override
    public void updateDeviceAssertInfo(String orgNo, String chargedeviceNo, String status, Long chargedeviceId) {
        if(StringUtils.isNotBlank(orgNo) && StringUtils.isNotBlank(chargedeviceNo) && StringUtils.isNotBlank(status)) {
            StringBuilder sqlBuilder = new StringBuilder();
            List<Object> params = new ArrayList<>();
            sqlBuilder.append("UPDATE ebike.ebike_assets_chargedevice eac ");
            sqlBuilder.append("   SET eac.buro = ? ");
            params.add(orgNo);
            sqlBuilder.append("     , eac.subburo = ? ");
            params.add(orgNo);
            sqlBuilder.append("     , eac.`status` = ? ");
            params.add(status);
            if(StringUtils.equals("00", status)) {
                // 00 - 库存状态
                sqlBuilder.append("     , eac.importTime = NULL ");
                sqlBuilder.append("     , eac.installTime = NULL ");
                sqlBuilder.append("     , eac.runTime = NULL ");
                sqlBuilder.append("     , eac.dismantleTime = NULL ");
            }
            else {
                if(chargedeviceId != null) {
                    sqlBuilder.append("     , eac.chargedeviceId = ? ");
                    params.add(chargedeviceId);
                }
                if(StringUtils.equals("02", status)) {
                    // 02 - 已装（待运行）
                    sqlBuilder.append("     , eac.installTime = ? ");
                    params.add(new Date());
                    sqlBuilder.append("     , eac.runTime = NULL ");
                    sqlBuilder.append("     , eac.dismantleTime = NULL ");
                }
                else if(StringUtils.equals("03", status)) {
                    // 03 - 运行
                    sqlBuilder.append("     , eac.runTime = ? ");
                    params.add(new Date());
                    sqlBuilder.append("     , eac.dismantleTime = NULL ");
                }
                else if(StringUtils.equals("07", status)) {
                    // 07 - 拆除
                    sqlBuilder.append("     , eac.dismantleTime = ? ");
                    params.add(new Date());
                }
            }
            sqlBuilder.append(" WHERE eac.chargedeviceNo = ? ");
            params.add(chargedeviceNo);
            ebikeJdbcTemplate.update(sqlBuilder.toString(), params.toArray());
        }
    }

}
