package cn.yunrui.bizservices.ebikemgmt.dao.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.ServiceRateDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class ServiceRateDaoImpl implements ServiceRateDao {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final JdbcTemplate ebikeJdbcTemplate;

    public ServiceRateDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public Double getServiceRateByChargestationId(Long chargestationId) {
        if(logger.isDebugEnabled()) {
            logger.debug("chargestationId : " + chargestationId);
        }
        String sql = "SELECT IFNULL(ecc.serviceRate, IFNULL(oo.serviceRate, 0.0)) AS serviceRate " +
                "  FROM cisp_dev.dev_ebikechargestation ecs " +
                " INNER JOIN cisp_dev.dev_powersystemresource pss ON pss.id = ecs.id AND pss.className = 'EBikeChargeStation' " +
                "  LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = pss.subburo " +
                "  LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = ecs.id " +
                " WHERE ecs.id = ? " +
                " LIMIT 1 ";
        Double serviceRate;
        try {
            serviceRate = ebikeJdbcTemplate.queryForObject(sql, new Object[] {chargestationId}, Double.class);
        }
        catch(EmptyResultDataAccessException _erdae) {
            serviceRate = 0.0D;
        }
        return serviceRate;
    }

}
