package cn.yunrui.bizservices.ebikemgmt.dao.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.StatisticsDao;
import cn.yunrui.bizservices.ebikemgmt.entity.AdcodeIndData;
import cn.yunrui.mqttclient.ebikesrv.common.utils.DateFormatUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.*;

/**
 *
 * @author Nick Zhang
 * @date 2018-04-28
 */
public class StatisticsDaoImpl implements StatisticsDao {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final RowMapper<List<AdcodeIndData>> indDataListRowMapper = (rs, rowNum) -> {
        List<AdcodeIndData> indDataList = Lists.newArrayList();
        ResultSetMetaData rsmd = rs.getMetaData();
        String buro = rs.getString(1);
        String subburo = rs.getString(2);
        String adcode = rs.getString(3);
        for(int i = 4; i <= rsmd.getColumnCount(); i++) {
            String val = rs.getString(i);
            if(val != null) {
                indDataList.add(new AdcodeIndData(buro, subburo, adcode, rsmd.getColumnName(i), val, coverToIndName(rsmd.getColumnName(i))));
            }
        }
        return indDataList;
    };

    private final JdbcTemplate ebikeJdbcTemplate;

    public StatisticsDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    private String coverToIndName(String indCode) {
        if(StringUtils.equalsAnyIgnoreCase(indCode, "TOTAL_CS_CNT", "EVCAR_TOTAL_CS_CNT", "MIX_TOTAL_CS_CNT")) {
            return "充电站总数";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "NPTS_CS_CNT", "EVCAR_NPTS_CS_CNT", "MIX_NPTS_CS_CNT")) {
            return "未投运充电站数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "PTS_CS_CNT", "EVCAR_PTS_CS_CNT", "MIX_PTS_CS_CNT")) {
            return "投运充电站数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "OFS_CS_CNT", "EVCAR_OFS_CS_CNT", "MIX_OFS_CS_CNT")) {
            return "退运充电站数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "OFFLINE_CS_CNT", "EVCAR_OFFLINE_CS_CNT", "MIX_OFFLINE_CS_CNT")) {
            return "离线充电站数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "ONLINE_CS_CNT", "EVCAR_ONLINE_CS_CNT", "MIX_ONLINE_CS_CNT")) {
            return "在线充电站数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "SP_INC_CS_CNT")) {
            return "工商业充电站数量（服务场所）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "SP_RES_CS_CNT")) {
            return "社区充电站数量（服务场所）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CFM_PUBLIC_CS_CNT")) {
            return "公益充电站数量（收费模式）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CFM_PROFIT_CS_CNT")) {
            return "盈利充电站数量（收费模式）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "TOTAL_CD_CNT", "EVCAR_TOTAL_CP_CNT", "MIX_TOTAL_CP_CNT")) {
            return "充电设备总数";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "NPTS_CD_CNT", "EVCAR_NPTS_CP_CNT", "MIX_NPTS_CP_CNT")) {
            return "未投运充电设备数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "PTS_CD_CNT", "EVCAR_PTS_CP_CNT", "MIX_PTS_CP_CNT")) {
            return "投运充电设备数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "OFS_CD_CNT", "EVCAR_OFS_CP_CNT", "MIX_OFS_CP_CNT")) {
            return "退运充电设备数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "OFFLINE_CD_CNT", "EVCAR_OFFLINE_CP_CNT", "MIX_OFFLINE_CP_CNT")) {
            return "离线充电设备数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "ONLINE_CD_CNT", "EVCAR_ONLINE_CP_CNT", "MIX_ONLINE_CP_CNT")) {
            return "在线充电设备数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INSMODE_WALL_CD_CNT")) {
            return "壁挂式充电设备数量（安装方式）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INSMODE_PILLAR_CD_CNT")) {
            return "立柱式充电设备数量（安装方式）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "TOTAL_CP_CNT", "EVCAR_TOTAL_CG_CNT", "MIX_TOTAL_CG_CNT")) {
            return "充电插座总数";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "NPTS_CP_CNT", "EVCAR_NPTS_CG_CNT", "MIX_NPTS_CG_CNT")) {
            return "未投运充电插座数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "PTS_CP_CNT", "EVCAR_PTS_CG_CNT", "MIX_PTS_CG_CNT")) {
            return "投运充电插座数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "OFS_CP_CNT", "EVCAR_OFS_CG_CNT", "MIX_OFS_CG_CNT")) {
            return "退运充电插座数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USABLE_CP_CNT", "EVCAR_USABLE_CG_CNT", "MIX_USABLE_CG_CNT")) {
            return "可用（空闲）充电插座数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "BEUSING_CP_CNT", "EVCAR_BEUSING_CG_CNT", "MIX_BEUSING_CG_CNT")) {
            return "正在使用充电插座数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "BEREPAIRING_CP_CNT", "EVCAR_BEREPAIRING_CG_CNT", "MIX_BEREPAIRING_CG_CNT")) {
            return "正在检修充电插座数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "UNUSABLE_CP_CNT", "EVCAR_UNUSABLE_CG_CNT", "MIX_UNUSABLE_CG_CNT")) {
            return "不可用（离线）充电插座数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "UNUSABLE_NNSRVDUE_CP_CNT", "EVCAR_UNUSABLE_NNSRVDUE_CG_CNT", "MIX_UNUSABLE_NNSRVDUE_CG_CNT")) {
            return "欠费离线充电插座数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "UNUSABLE_POWEROFF_CP_CNT", "EVCAR_UNUSABLE_POWEROFF_CG_CNT", "MIX_UNUSABLE_POWEROFF_CG_CNT")) {
            return "停电离线充电插座数量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "UNUSABLE_OTHER_CP_CNT", "EVCAR_UNUSABLE_OTHER_CG_CNT", "MIX_UNUSABLE_OTHER_CG_CNT")) {
            return "其他离线充电插座数量（除欠费、停机外）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_TOTAL_CNT", "EVCAR_CUMCRG_TOTAL_CNT", "MIX_CUMCRG_TOTAL_CNT")) {
            return "累计充电总次数";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRDAY_CNT", "EVCAR_CUMCRG_CURRDAY_CNT", "MIX_CUMCRG_CURRDAY_CNT")) {
            return "当日累计充电次数";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRMON_CNT", "EVCAR_CUMCRG_CURRMON_CNT", "MIX_CUMCRG_CURRMON_CNT")) {
            return "当月累计充电次数";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRYER_CNT", "EVCAR_CUMCRG_CURRYER_CNT", "MIX_CUMCRG_CURRYER_CNT")) {
            return "当年累计充电次数";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_TOTAL_WXPAY", "MIX_CUMCRG_TOTAL_WXPAY")) {
            return "累计充电总次数（微信支付）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRDAY_WXPAY", "MIX_CUMCRG_CURRDAY_WXPAY")) {
            return "当日累计充电总次数（微信支付）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRMON_WXPAY", "MIX_CUMCRG_CURRMON_WXPAY")) {
            return "当月累计充电总次数（微信支付）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRYER_WXPAY", "MIX_CUMCRG_CURRYER_WXPAY")) {
            return "当年累计充电总次数（微信支付）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_TOTAL_ALIPAY", "MIX_CUMCRG_TOTAL_ALIPAY")) {
            return "累计充电总次数（支付宝）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRDAY_ALIPAY", "MIX_CUMCRG_CURRDAY_ALIPAY")) {
            return "当日累计充电总次数（支付宝）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRMON_ALIPAY", "MIX_CUMCRG_CURRMON_ALIPAY")) {
            return "当月累计充电总次数（支付宝）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRYER_ALIPAY", "MIX_CUMCRG_CURRYER_ALIPAY")) {
            return "当年累计充电总次数（支付宝）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_TOTAL_INNERACCT", "MIX_CUMCRG_TOTAL_INNERACCT")) {
            return "累计充电总次数（账户余额）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRDAY_INNERACCT", "MIX_CUMCRG_CURRDAY_INNERACCT")) {
            return "当日累计充电总次数（账户余额）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRMON_INNERACCT", "MIX_CUMCRG_CURRMON_INNERACCT")) {
            return "当月累计充电总次数（账户余额）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRYER_INNERACCT", "MIX_CUMCRG_CURRYER_INNERACCT")) {
            return "当年累计充电总次数（账户余额）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_TOTAL_EBMKT_REDPKT", "MIX_CUMCRG_TOTAL_EBMKT_REDPKT")) {
            return "累计充电总次数（驿吧营销活动红包）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRDAY_EBMKT_REDPKT", "MIX_CUMCRG_CURRDAY_EBMKT_REDPKT")) {
            return "当日累计充电总次数（驿吧营销活动红包）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRMON_EBMKT_REDPKT", "MIX_CUMCRG_CURRMON_EBMKT_REDPKT")) {
            return "当月累计充电总次数（驿吧营销活动红包）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRYER_EBMKT_REDPKT", "MIX_CUMCRG_CURRYER_EBMKT_REDPKT")) {
            return "当年累计充电总次数（驿吧营销活动红包）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_TOTAL_EBCRGCARD", "MIX_CUMCRG_TOTAL_EBCRGCARD")) {
            return "累计充电总次数（驿吧充电卡）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRDAY_EBCRGCARD", "MIX_CUMCRG_CURRDAY_EBCRGCARD")) {
            return "当日累计充电总次数（驿吧充电卡）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRMON_EBCRGCARD", "MIX_CUMCRG_CURRMON_EBCRGCARD")) {
            return "当月累计充电总次数（驿吧充电卡）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRYER_EBCRGCARD", "MIX_CUMCRG_CURRYER_EBCRGCARD")) {
            return "当年累计充电总次数（驿吧充电卡）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_TOTAL_EBCRGCOIN", "MIX_CUMCRG_TOTAL_EBCRGCOIN")) {
            return "累计充电总次数（投币）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRDAY_EBCRGCOIN", "MIX_CUMCRG_CURRDAY_EBCRGCOIN")) {
            return "当日累计充电总次数（投币）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRMON_EBCRGCOIN", "MIX_CUMCRG_CURRMON_EBCRGCOIN")) {
            return "当月累计充电总次数（投币）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_CURRYER_EBCRGCOIN", "MIX_CUMCRG_CURRYER_EBCRGCOIN")) {
            return "当年累计充电总次数（投币）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_TOTAL", "MIX_INCOME_TOTAL")) {
            return "累计充电收入";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRDAY", "MIX_INCOME_CURRDAY")) {
            return "当日累计充电收入";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRMON", "MIX_INCOME_CURRMON")) {
            return "当月累计充电收入";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRYER", "MIX_INCOME_CURRYER")) {
            return "当年累计充电收入";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_TOTAL_WXPAY", "MIX_INCOME_TOTAL_WXPAY")) {
            return "累计充电收入（微信支付）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRDAY_WXPAY", "MIX_INCOME_CURRDAY_WXPAY")) {
            return "当日累计充电收入（微信支付）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRMON_WXPAY", "MIX_INCOME_CURRMON_WXPAY")) {
            return "当月累计充电收入（微信支付）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRYER_WXPAY", "MIX_INCOME_CURRYER_WXPAY")) {
            return "当年累计充电收入（微信支付）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_TOTAL_ALIPAY", "MIX_INCOME_TOTAL_ALIPAY")) {
            return "累计充电收入（支付宝）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRDAY_ALIPAY", "MIX_INCOME_CURRDAY_ALIPAY")) {
            return "当日累计充电收入（支付宝）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRMON_ALIPAY", "MIX_INCOME_CURRMON_ALIPAY")) {
            return "当月累计充电收入（支付宝）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRYER_ALIPAY", "MIX_INCOME_CURRYER_ALIPAY")) {
            return "当年累计充电收入（支付宝）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_TOTAL_INNERACCT", "MIX_INCOME_TOTAL_INNERACCT")) {
            return "累计充电收入（账户余额）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRDAY_INNERACCT", "MIX_INCOME_CURRDAY_INNERACCT")) {
            return "当日累计充电收入（账户余额）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRMON_INNERACCT", "MIX_INCOME_CURRMON_INNERACCT")) {
            return "当月累计充电收入（账户余额）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRYER_INNERACCT", "MIX_INCOME_CURRYER_INNERACCT")) {
            return "当年累计充电收入（账户余额）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_TOTAL_EBMKT_REDPKT", "MIX_INCOME_TOTAL_EBMKT_REDPKT")) {
            return "累计充电收入（驿吧营销活动红包）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRDAY_EBMKT_REDPKT", "MIX_INCOME_CURRDAY_EBMKT_REDPKT")) {
            return "当日累计充电收入（驿吧营销活动红包）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRMON_EBMKT_REDPKT", "MIX_INCOME_CURRMON_EBMKT_REDPKT")) {
            return "当月累计充电收入（驿吧营销活动红包）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRYER_EBMKT_REDPKT", "MIX_INCOME_CURRYER_EBMKT_REDPKT")) {
            return "当年累计充电收入（驿吧营销活动红包）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_TOTAL_EBCRGCARD", "MIX_INCOME_TOTAL_EBCRGCARD")) {
            return "累计充电收入（驿吧充电卡）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRDAY_EBCRGCARD", "MIX_INCOME_CURRDAY_EBCRGCARD")) {
            return "当日累计充电收入（驿吧充电卡）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRMON_EBCRGCARD", "MIX_INCOME_CURRMON_EBCRGCARD")) {
            return "当月累计充电收入（驿吧充电卡）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRYER_EBCRGCARD", "MIX_INCOME_CURRYER_EBCRGCARD")) {
            return "当年累计充电收入（驿吧充电卡）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_TOTAL_EBCRGCOIN", "MIX_INCOME_TOTAL_EBCRGCOIN")) {
            return "累计充电收入（投币）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRDAY_EBCRGCOIN", "MIX_INCOME_CURRDAY_EBCRGCOIN")) {
            return "当日累计充电收入（投币）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRMON_EBCRGCOIN", "MIX_INCOME_CURRMON_EBCRGCOIN")) {
            return "当月累计充电收入（投币）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_CURRYER_EBCRGCOIN", "MIX_INCOME_CURRYER_EBCRGCOIN")) {
            return "当年累计充电收入（投币）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_TOTAL", "MIX_USERCNT_TOTAL")) {
            return "累计充电用户数";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRDAY", "MIX_USERCNT_CURRDAY")) {
            return "当日累计充电用户数";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRMON", "MIX_USERCNT_CURRMON")) {
            return "当月累计充电用户数";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRYER", "MIX_USERCNT_CURRYER")) {
            return "当年累计充电用户数";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_LIVEMON", "MIX_USERCNT_LIVEMON")) {
            return "月活充电用户数";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_TOTAL_WXPAY", "MIX_USERCNT_TOTAL_WXPAY")) {
            return "累计充电用户数（微信支付）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRDAY_WXPAY", "MIX_USERCNT_CURRDAY_WXPAY")) {
            return "当日累计充电用户数（微信支付）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRMON_WXPAY", "MIX_USERCNT_CURRMON_WXPAY")) {
            return "当月累计充电用户数（微信支付）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRYER_WXPAY", "MIX_USERCNT_CURRYER_WXPAY")) {
            return "当年累计充电用户数（微信支付）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_TOTAL_ALIPAY", "MIX_USERCNT_TOTAL_ALIPAY")) {
            return "累计充电用户数（支付宝）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRDAY_ALIPAY", "MIX_USERCNT_CURRDAY_ALIPAY")) {
            return "当日累计充电用户数（支付宝）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRMON_ALIPAY", "MIX_USERCNT_CURRMON_ALIPAY")) {
            return "当月累计充电用户数（支付宝）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRYER_ALIPAY", "MIX_USERCNT_CURRYER_ALIPAY")) {
            return "当年累计充电用户数（支付宝）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_TOTAL_INNERACCT", "MIX_USERCNT_TOTAL_INNERACCT")) {
            return "累计充电用户数（账户余额）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRDAY_INNERACCT", "MIX_USERCNT_CURRDAY_INNERACCT")) {
            return "当日累计充电用户数（账户余额）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRMON_INNERACCT", "MIX_USERCNT_CURRMON_INNERACCT")) {
            return "当月累计充电用户数（账户余额）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRYER_INNERACCT", "MIX_USERCNT_CURRYER_INNERACCT")) {
            return "当年累计充电用户数（账户余额）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_TOTAL_EBMKT_REDPKT", "MIX_USERCNT_TOTAL_EBMKT_REDPKT")) {
            return "累计充电用户数（驿吧营销活动红包）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRDAY_EBMKT_REDPKT", "MIX_USERCNT_CURRDAY_EBMKT_REDPKT")) {
            return "当日累计充电用户数（驿吧营销活动红包）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRMON_EBMKT_REDPKT", "MIX_USERCNT_CURRMON_EBMKT_REDPKT")) {
            return "当月累计充电用户数（驿吧营销活动红包）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRYER_EBMKT_REDPKT", "MIX_USERCNT_CURRYER_EBMKT_REDPKT")) {
            return "当年累计充电用户数（驿吧营销活动红包）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_TOTAL_EBCRGCARD", "MIX_USERCNT_TOTAL_EBCRGCARD")) {
            return "累计充电用户数（驿吧充电卡）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRDAY_EBCRGCARD", "MIX_USERCNT_CURRDAY_EBCRGCARD")) {
            return "当日累计充电用户数（驿吧充电卡）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRMON_EBCRGCARD", "MIX_USERCNT_CURRMON_EBCRGCARD")) {
            return "当月累计充电用户数（驿吧充电卡）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRYER_EBCRGCARD", "MIX_USERCNT_CURRYER_EBCRGCARD")) {
            return "当年累计充电用户数（驿吧充电卡）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_TOTAL_EBCRGCOIN", "MIX_USERCNT_TOTAL_EBCRGCOIN")) {
            return "累计充电用户数（投币）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRDAY_EBCRGCOIN", "MIX_USERCNT_CURRDAY_EBCRGCOIN")) {
            return "当日累计充电用户数（投币）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRMON_EBCRGCOIN", "MIX_USERCNT_CURRMON_EBCRGCOIN")) {
            return "当月累计充电用户数（投币）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_CURRYER_EBCRGCOIN", "MIX_USERCNT_CURRYER_EBCRGCOIN")) {
            return "当年累计充电用户数（投币）";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "ELECCONS_TOTAL", "EVCAR_ELECCONS_TOTAL", "MIX_ELECCONS_TOTAL")) {
            return "累计充电电量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "ELECCONS_CURRDAY", "EVCAR_ELECCONS_CURRDAY", "MIX_ELECCONS_CURRDAY")) {
            return "当日累计充电电量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "ELECCONS_CURRMON", "EVCAR_ELECCONS_CURRMON", "MIX_ELECCONS_CURRMON")) {
            return "当月累计充电电量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "ELECCONS_CURRYER", "EVCAR_ELECCONS_CURRYER", "MIX_ELECCONS_CURRYER")) {
            return "当年累计充电电量";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "CUMCRG_BECRGING_CNT", "EVCAR_CUMCRG_BECRGING_CNT", "MIX_CUMCRG_BECRGING_CNT")) {
            return "正在充电次数";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "INCOME_BECRGING", "EVCAR_INCOME_BECRGING", "MIX_INCOME_BECRGING")) {
            return "正在充电收入";
        }
        else if(StringUtils.equalsAnyIgnoreCase(indCode, "USERCNT_BECRGING", "EVCAR_USERCNT_BECRGING", "MIX_USERCNT_BECRGING")) {
            return "正在充电用户数";
        }
        return "";
    }

    private Map<String, Object> buildAdindRealtimeDataSql(int type, Date date) {
        Map<String, Object> m = new HashMap<>();
        StringBuilder sqlBuilder = new StringBuilder();
        List<Object> sqlParams = new ArrayList<>();
        if(type == 1) {
            // 充电站信息：TOTAL_CS_CNT 充电站总数、NPTS_CS_CNT 未投运充电站数量、PTS_CS_CNT 投运充电站数量、OFS_CS_CNT 退运充电站数量、OFFLINE_CS_CNT 离线充电站数量、ONLINE_CS_CNT 在线充电站数量
            sqlBuilder.append("     , SUM(IF(psr.status IN ('10', '20', '40'), 1, 0)) AS TOTAL_CS_CNT, SUM(IF(psr.status IN ('10', '20', '40'), 1, 0)) AS MIX_TOTAL_CS_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('10'), 1, 0)) AS NPTS_CS_CNT, SUM(IF(psr.status IN ('10'), 1, 0)) AS MIX_NPTS_CS_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20'), 1, 0)) AS PTS_CS_CNT, SUM(IF(psr.status IN ('20'), 1, 0)) AS MIX_PTS_CS_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('40'), 1, 0)) AS OFS_CS_CNT, SUM(IF(psr.status IN ('40'), 1, 0)) AS MIX_OFS_CS_CNT ");
            // 2020年7月15日，去除在线/离线充电站数量
            //sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND ops.opStatus = '0', 1, 0)) AS OFFLINE_CS_CNT ");
            //sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND ops.opStatus = '1', 1, 0)) AS ONLINE_CS_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND ecs.servicePlaceType = '01', 1, 0)) AS SP_INC_CS_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND ecs.servicePlaceType = '02', 1, 0)) AS SP_RES_CS_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND ecs.chargeFeeMode = '01', 1, 0)) AS CFM_PROFIT_CS_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND ecs.chargeFeeMode = '02', 1, 0)) AS CFM_PUBLIC_CS_CNT ");
            sqlBuilder.append("  FROM cisp_dev.dev_ebikechargestation ecs ");
            sqlBuilder.append(" INNER JOIN cisp_dev.dev_powersystemresource psr ON psr.id = ecs.id AND psr.className = 'EBikeChargeStation' ");
            sqlBuilder.append(" INNER JOIN ebike.code_adcode ad ON ad.adcode = ecs.adcode ");
            //sqlBuilder.append("  LEFT JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.chargestationId = ecs.id ");
            //sqlBuilder.append("  LEFT JOIN ebike.ebike_chargedevice_ops ops ON ops.chargedeviceId = ecd.id ");
        }
        else if(type == 2) {
            // 充电设备信息：TOTAL_CD_CNT 充电设备总数、NPTS_CD_CNT 未投运充电设备数量、PTS_CD_CNT 投运充电设备数量、OFS_CD_CNT 退运充电设备数量、OFFLINE_CD_CNT 离线充电设备数量、ONLINE_CD_CNT 在线充电设备数量
            sqlBuilder.append("     , SUM(IF(psr.status IN ('10', '20', '40'), 1, 0)) AS TOTAL_CD_CNT, SUM(IF(psr.status IN ('10', '20', '40'), 1, 0)) AS MIX_TOTAL_CP_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('10'), 1, 0)) AS NPTS_CD_CNT, SUM(IF(psr.status IN ('10'), 1, 0)) AS MIX_NPTS_CP_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20'), 1, 0)) AS PTS_CD_CNT, SUM(IF(psr.status IN ('20'), 1, 0)) AS MIX_PTS_CP_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('40'), 1, 0)) AS OFS_CD_CNT, SUM(IF(psr.status IN ('40'), 1, 0)) AS MIX_OFS_CP_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND ops.opStatus = '0', 1, 0)) AS OFFLINE_CD_CNT, SUM(IF(psr.status IN ('20') AND ops.opStatus = '0', 1, 0)) AS MIX_OFFLINE_CP_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND ops.opStatus = '1', 1, 0)) AS ONLINE_CD_CNT, SUM(IF(psr.status IN ('20') AND ops.opStatus = '1', 1, 0)) AS MIX_ONLINE_CP_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND eac.installMode = '01', 1, 0)) AS INSMODE_WALL_CD_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND eac.installMode = '02', 1, 0)) AS INSMODE_PILLAR_CD_CNT ");
            sqlBuilder.append("  FROM cisp_dev.dev_ebikechargedevice ecd ");
            sqlBuilder.append(" INNER JOIN cisp_dev.dev_powersystemresource psr ON psr.id = ecd.id AND psr.className = 'EBikeChargeDevice' ");
            sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargestation ecs ON ecs.id = ecd.chargestationId ");
            sqlBuilder.append(" INNER JOIN ebike.ebike_assets_chargedevice eac ON eac.chargedeviceId = ecd.id ");
            sqlBuilder.append(" INNER JOIN ebike.code_adcode ad ON ad.adcode = ecs.adcode ");
            sqlBuilder.append("  LEFT JOIN ebike.ebike_chargedevice_ops ops ON ops.chargedeviceId = ecd.id ");
        }
        else if(type == 3) {
            // 充电插座信息：TOTAL_CP_CNT 充电插座总数、NPTS_CP_CNT 未投运充电插座数量、PTS_CP_CNT 投运充电插座数量、OFS_CP_CNT 退运充电插座数量、USABLE_CP_CNT 可用（空闲）充电插座数量、BEUSING_CP_CNT 正在使用充电插座数量、BEREPAIRING_CP_CNT 正在检修充电插座数量、UNUSABLE_CP_CNT 不可用（离线）充电插座数量
            sqlBuilder.append("     , SUM(IF(psr.status IN ('10', '20', '40'), 1, 0)) AS TOTAL_CP_CNT, SUM(IF(psr.status IN ('10', '20', '40'), 1, 0)) AS MIX_TOTAL_CG_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('10'), 1, 0)) AS NPTS_CP_CNT, SUM(IF(psr.status IN ('10'), 1, 0)) AS MIX_NPTS_CG_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20'), 1, 0)) AS PTS_CP_CNT, SUM(IF(psr.status IN ('20'), 1, 0)) AS MIX_PTS_CG_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('40'), 1, 0)) AS OFS_CP_CNT, SUM(IF(psr.status IN ('40'), 1, 0)) AS MIX_OFS_CG_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND ops.opStatus = '0', 1, 0)) AS USABLE_CP_CNT, SUM(IF(psr.status IN ('20') AND ops.opStatus = '0', 1, 0)) AS MIX_USABLE_CG_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND ops.opStatus IN ('1','2'), 1, 0)) AS BEUSING_CP_CNT, SUM(IF(psr.status IN ('20') AND ops.opStatus IN ('1','2'), 1, 0)) AS MIX_BEUSING_CG_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND ops.opStatus = '8', 1, 0)) AS BEREPAIRING_CP_CNT, SUM(IF(psr.status IN ('20') AND ops.opStatus = '8', 1, 0)) AS MIX_BEREPAIRING_CG_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND ops.opStatus = '9', 1, 0)) AS UNUSABLE_CP_CNT, SUM(IF(psr.status IN ('20') AND ops.opStatus = '9', 1, 0)) AS MIX_UNUSABLE_CG_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND ow.opsworkorderType IN ('103'), 1, 0)) AS UNUSABLE_NNSRVDUE_CP_CNT, SUM(IF(psr.status IN ('20') AND ow.opsworkorderType IN ('103'), 1, 0)) AS MIX_UNUSABLE_NNSRVDUE_CG_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND ow.opsworkorderType IN ('102'), 1, 0)) AS UNUSABLE_POWEROFF_CP_CNT, SUM(IF(psr.status IN ('20') AND ow.opsworkorderType IN ('102'), 1, 0)) AS MIX_UNUSABLE_POWEROFF_CG_CNT ");
            sqlBuilder.append("     , SUM(IF(psr.status IN ('20') AND ow.opsworkorderType NOT IN ('103', '102'), 1, 0)) AS UNUSABLE_OTHER_CP_CNT, SUM(IF(psr.status IN ('20') AND ow.opsworkorderType NOT IN ('103', '102'), 1, 0)) AS MIX_UNUSABLE_OTHER_CG_CNT ");
            sqlBuilder.append("  FROM cisp_dev.dev_ebikechargeplug ecp ");
            sqlBuilder.append(" INNER JOIN cisp_dev.dev_powersystemresource psr ON psr.id = ecp.id AND psr.className = 'EBikeChargePlug' ");
            sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId ");
            sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargestation ecs ON ecs.id = ecd.chargestationId ");
            sqlBuilder.append(" INNER JOIN ebike.code_adcode ad ON ad.adcode = ecs.adcode ");
            sqlBuilder.append("  LEFT JOIN ebike.ebike_chargeplug_ops ops ON ops.chargeplugId = ecp.id ");
            sqlBuilder.append("  LEFT JOIN ebike.ops_workorder ow ON ow.opsObjectType = 'EBikeChargeDevice' AND ow.opsObjectId = ecd.id ");
        }
        else if(type == 4) {
            // 充电次数信息 & 充电收入信息：CUMCRG_TOTAL_CNT 累计充电总次数、CUMCRG_CURRDAY_CNT 当日累计充电次数、CUMCRG_CURRMON_CNT 当月累计充电次数、CUMCRG_CURRYER_CNT 当年累计充电次数、INCOME_TOTAL 累计充电收入、INCOME_CURRDAY 当日累计充电收入、INCOME_CURRMON 当月累计充电收入、INCOME_CURRYER 当年累计充电收入
            sqlBuilder.append("     , SUM(IFNULL(sct.chargeCnt,0)+IFNULL(scd.chargeCnt,0)) AS CUMCRG_TOTAL_CNT, SUM(IFNULL(sct.chargeCnt,0)+IFNULL(scd.chargeCnt,0)) AS MIX_CUMCRG_TOTAL_CNT ");
            sqlBuilder.append("     , SUM(IFNULL(scd.chargeCnt,0)) AS CUMCRG_CURRDAY_CNT, SUM(IFNULL(scd.chargeCnt,0)) AS MIX_CUMCRG_CURRDAY_CNT ");
            sqlBuilder.append("     , SUM(IFNULL(scm.chargeCnt,0)+IFNULL(scd.chargeCnt,0)) AS CUMCRG_CURRMON_CNT, SUM(IFNULL(scm.chargeCnt,0)+IFNULL(scd.chargeCnt,0)) AS MIX_CUMCRG_CURRMON_CNT ");
            sqlBuilder.append("     , SUM(IFNULL(scy.chargeCnt,0)+IFNULL(scd.chargeCnt,0)) AS CUMCRG_CURRYER_CNT, SUM(IFNULL(scy.chargeCnt,0)+IFNULL(scd.chargeCnt,0)) AS MIX_CUMCRG_CURRYER_CNT ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(sct.chargeIncome,0)+IFNULL(scd.chargeIncome,0)),0) AS INCOME_TOTAL, ROUND(SUM(IFNULL(sct.chargeIncome,0)+IFNULL(scd.chargeIncome,0)),0) AS MIX_INCOME_TOTAL ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scd.chargeIncome,0)),1) AS INCOME_CURRDAY, ROUND(SUM(IFNULL(scd.chargeIncome,0)),1) AS MIX_INCOME_CURRDAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scm.chargeIncome,0)+IFNULL(scd.chargeIncome,0)),1) AS INCOME_CURRMON, ROUND(SUM(IFNULL(scm.chargeIncome,0)+IFNULL(scd.chargeIncome,0)),1) AS MIX_INCOME_CURRMON ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scy.chargeIncome,0)+IFNULL(scd.chargeIncome,0)),1) AS INCOME_CURRYER, ROUND(SUM(IFNULL(scy.chargeIncome,0)+IFNULL(scd.chargeIncome,0)),1) AS MIX_INCOME_CURRYER ");
            sqlBuilder.append("  FROM cisp_dev.dev_ebikechargestation ecs ");
            sqlBuilder.append(" INNER JOIN cisp_dev.dev_powersystemresource psr ON psr.id = ecs.id AND psr.className = 'EBikeChargeStation' ");
            sqlBuilder.append(" INNER JOIN ebike.code_adcode ad ON ad.adcode = ecs.adcode ");
            sqlBuilder.append("  LEFT JOIN (SELECT chargestationId, SUM(chargeCnt) AS chargeCnt, SUM(chargeIncome) AS chargeIncome FROM ebike.stat_chargestation_year GROUP BY chargestationId) sct ON sct.chargestationId = ecs.id ");
            sqlBuilder.append("  LEFT JOIN (SELECT chargestationId, chargeCnt AS chargeCnt, chargeIncome FROM ebike.stat_chargestation_year WHERE statYear = ?) scy ON scy.chargestationId = ecs.id ");
            sqlParams.add(DateFormatUtils.format(date, "yyyy"));
            sqlBuilder.append("  LEFT JOIN (SELECT chargestationId, chargeCnt AS chargeCnt, chargeIncome FROM ebike.stat_chargestation_month WHERE statMonth = ?) scm ON scm.chargestationId = ecs.id ");
            sqlParams.add(DateFormatUtils.format(date, "yyyyMM"));
            sqlBuilder.append("  LEFT JOIN (SELECT chargestationId, COUNT(DISTINCT chargeRecordId) AS chargeCnt, SUM(income) AS chargeIncome FROM ebike.ebike_chargerecord_his WHERE chargeFinishTime >= STR_TO_DATE(?, '%Y-%m-%d') GROUP BY chargestationId) scd ON scd.chargestationId = ecs.id ");
            sqlParams.add(DateFormatUtils.format(date, "yyyy-MM-dd"));
        }
        else if(type == 5) {
            // 正在充电次数 & 正在充电收入 & 正在充电用户：CUMCRG_BECRGING_CNT 正在充电次数、INCOME_BECRGING 正在充电收入
            sqlBuilder.append("     , SUM(IFNULL(cur.chargeCnt,0)) AS CUMCRG_BECRGING_CNT, SUM(IFNULL(cur.chargeCnt,0)) AS MIX_CUMCRG_BECRGING_CNT ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(cur.chargeMoney,0)),1) AS INCOME_BECRGING, ROUND(SUM(IFNULL(cur.chargeMoney,0)),1) AS MIX_INCOME_BECRGINGs ");
            sqlBuilder.append("  FROM cisp_dev.dev_ebikechargestation ecs ");
            sqlBuilder.append(" INNER JOIN cisp_dev.dev_powersystemresource psr ON psr.id = ecs.id AND psr.className = 'EBikeChargeStation' ");
            sqlBuilder.append(" INNER JOIN ebike.code_adcode ad ON ad.adcode = ecs.adcode ");
            sqlBuilder.append("  LEFT JOIN (SELECT chargestationId, COUNT(DISTINCT chargeRecordId) AS chargeCnt, SUM(chargeMoney) AS chargeMoney FROM ebike.ebike_chargerecord GROUP BY chargestationId) cur ON cur.chargestationId = ecs.id ");
        }
        else if(type == 6) {
            // 充电次数信息 & 充电收入信息：CUMCRG_TOTAL_CNT 累计充电总次数、CUMCRG_CURRDAY_CNT 当日累计充电次数、CUMCRG_CURRMON_CNT 当月累计充电次数、CUMCRG_CURRYER_CNT 当年累计充电次数、INCOME_TOTAL 累计充电收入、INCOME_CURRDAY 当日累计充电收入、INCOME_CURRMON 当月累计充电收入、INCOME_CURRYER 当年累计充电收入
            sqlBuilder.append("     , SUM(IFNULL(sct.scanChargeWxpayCnt,0)) AS CUMCRG_TOTAL_WXPAY, SUM(IFNULL(sct.scanChargeWxpayCnt,0)) AS MIX_CUMCRG_TOTAL_WXPAY ");
            sqlBuilder.append("     , SUM(IFNULL(scd.scanChargeWxpayCnt,0)) AS CUMCRG_CURRDAY_WXPAY, SUM(IFNULL(scd.scanChargeWxpayCnt,0)) AS MIX_CUMCRG_CURRDAY_WXPAY ");
            sqlBuilder.append("     , SUM(IFNULL(scm.scanChargeWxpayCnt,0)) AS CUMCRG_CURRMON_WXPAY, SUM(IFNULL(scm.scanChargeWxpayCnt,0)) AS MIX_CUMCRG_CURRMON_WXPAY ");
            sqlBuilder.append("     , SUM(IFNULL(scy.scanChargeWxpayCnt,0)) AS CUMCRG_CURRYER_WXPAY, SUM(IFNULL(scy.scanChargeWxpayCnt,0)) AS MIX_CUMCRG_CURRYER_WXPAY ");
            sqlBuilder.append("     , SUM(IFNULL(sct.scanChargeAlipayCnt,0)) AS CUMCRG_TOTAL_ALIPAY, SUM(IFNULL(sct.scanChargeAlipayCnt,0)) AS MIX_CUMCRG_TOTAL_ALIPAY ");
            sqlBuilder.append("     , SUM(IFNULL(scd.scanChargeAlipayCnt,0)) AS CUMCRG_CURRDAY_ALIPAY, SUM(IFNULL(scd.scanChargeAlipayCnt,0)) AS MIX_CUMCRG_CURRDAY_ALIPAY ");
            sqlBuilder.append("     , SUM(IFNULL(scm.scanChargeAlipayCnt,0)) AS CUMCRG_CURRMON_ALIPAY, SUM(IFNULL(scm.scanChargeAlipayCnt,0)) AS MIX_CUMCRG_CURRMON_ALIPAY ");
            sqlBuilder.append("     , SUM(IFNULL(scy.scanChargeAlipayCnt,0)) AS CUMCRG_CURRYER_ALIPAY, SUM(IFNULL(scy.scanChargeAlipayCnt,0)) AS MIX_CUMCRG_CURRYER_ALIPAY ");
            sqlBuilder.append("     , SUM(IFNULL(sct.scanChargeInneracctCnt,0)) AS CUMCRG_TOTAL_INNERACCT, SUM(IFNULL(sct.scanChargeInneracctCnt,0)) AS MIX_CUMCRG_TOTAL_INNERACCT ");
            sqlBuilder.append("     , SUM(IFNULL(scd.scanChargeInneracctCnt,0)) AS CUMCRG_CURRDAY_INNERACCT, SUM(IFNULL(scd.scanChargeInneracctCnt,0)) AS MIX_CUMCRG_CURRDAY_INNERACCT ");
            sqlBuilder.append("     , SUM(IFNULL(scm.scanChargeInneracctCnt,0)) AS CUMCRG_CURRMON_INNERACCT, SUM(IFNULL(scm.scanChargeInneracctCnt,0)) AS MIX_CUMCRG_CURRMON_INNERACCT ");
            sqlBuilder.append("     , SUM(IFNULL(scy.scanChargeInneracctCnt,0)) AS CUMCRG_CURRYER_INNERACCT, SUM(IFNULL(scy.scanChargeInneracctCnt,0)) AS MIX_CUMCRG_CURRYER_INNERACCT ");
            sqlBuilder.append("     , SUM(IFNULL(sct.cardChargeCnt,0)) AS CUMCRG_TOTAL_EBCRGCARD, SUM(IFNULL(sct.cardChargeCnt,0)) AS MIX_CUMCRG_TOTAL_EBCRGCARD ");
            sqlBuilder.append("     , SUM(IFNULL(scd.cardChargeCnt,0)) AS CUMCRG_CURRDAY_EBCRGCARD, SUM(IFNULL(scd.cardChargeCnt,0)) AS MIX_CUMCRG_CURRDAY_EBCRGCARD ");
            sqlBuilder.append("     , SUM(IFNULL(scm.cardChargeCnt,0)) AS CUMCRG_CURRMON_EBCRGCARD, SUM(IFNULL(scm.cardChargeCnt,0)) AS MIX_CUMCRG_CURRMON_EBCRGCARD ");
            sqlBuilder.append("     , SUM(IFNULL(scy.cardChargeCnt,0)) AS CUMCRG_CURRYER_EBCRGCARD, SUM(IFNULL(scy.cardChargeCnt,0)) AS MIX_CUMCRG_CURRYER_EBCRGCARD ");
            sqlBuilder.append("     , SUM(IFNULL(sct.coinChargeCnt,0)) AS CUMCRG_TOTAL_EBCRGCOIN, SUM(IFNULL(sct.coinChargeCnt,0)) AS MIX_CUMCRG_TOTAL_EBCRGCOIN ");
            sqlBuilder.append("     , SUM(IFNULL(scd.coinChargeCnt,0)) AS CUMCRG_CURRDAY_EBCRGCOIN, SUM(IFNULL(scd.coinChargeCnt,0)) AS MIX_CUMCRG_CURRDAY_EBCRGCOIN ");
            sqlBuilder.append("     , SUM(IFNULL(scm.coinChargeCnt,0)) AS CUMCRG_CURRMON_EBCRGCOIN, SUM(IFNULL(scm.coinChargeCnt,0)) AS MIX_CUMCRG_CURRMON_EBCRGCOIN ");
            sqlBuilder.append("     , SUM(IFNULL(scy.coinChargeCnt,0)) AS CUMCRG_CURRYER_EBCRGCOIN, SUM(IFNULL(scy.coinChargeCnt,0)) AS MIX_CUMCRG_CURRYER_EBCRGCOIN ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(sct.scanChargeWxpayIncome,0)),0) AS INCOME_TOTAL_WXPAY, ROUND(SUM(IFNULL(sct.scanChargeWxpayIncome,0)),0) AS MIX_INCOME_TOTAL_WXPAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scd.scanChargeWxpayIncome,0)),1) AS INCOME_CURRDAY_WXPAY, ROUND(SUM(IFNULL(scd.scanChargeWxpayIncome,0)),1) AS MIX_INCOME_CURRDAY_WXPAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scm.scanChargeWxpayIncome,0)),1) AS INCOME_CURRMON_WXPAY, ROUND(SUM(IFNULL(scm.scanChargeWxpayIncome,0)),1) AS MIX_INCOME_CURRMON_WXPAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scy.scanChargeWxpayIncome,0)),1) AS INCOME_CURRYER_WXPAY, ROUND(SUM(IFNULL(scy.scanChargeWxpayIncome,0)),1) AS MIX_INCOME_CURRYER_WXPAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(sct.scanChargeAlipayIncome,0)),0) AS INCOME_TOTAL_ALIPAY, ROUND(SUM(IFNULL(sct.scanChargeAlipayIncome,0)),0) AS MIX_INCOME_TOTAL_ALIPAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scd.scanChargeAlipayIncome,0)),1) AS INCOME_CURRDAY_ALIPAY, ROUND(SUM(IFNULL(scd.scanChargeAlipayIncome,0)),1) AS MIX_INCOME_CURRDAY_ALIPAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scm.scanChargeAlipayIncome,0)),1) AS INCOME_CURRMON_ALIPAY, ROUND(SUM(IFNULL(scm.scanChargeAlipayIncome,0)),1) AS MIX_INCOME_CURRMON_ALIPAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scy.scanChargeAlipayIncome,0)),1) AS INCOME_CURRYER_ALIPAY, ROUND(SUM(IFNULL(scy.scanChargeAlipayIncome,0)),1) AS MIX_INCOME_CURRYER_ALIPAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(sct.scanChargeInneracctIncome,0)),0) AS INCOME_TOTAL_INNERACCT, ROUND(SUM(IFNULL(sct.scanChargeInneracctIncome,0)),0) AS MIX_INCOME_TOTAL_INNERACCT ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scd.scanChargeInneracctIncome,0)),1) AS INCOME_CURRDAY_INNERACCT, ROUND(SUM(IFNULL(scd.scanChargeInneracctIncome,0)),1) AS MIX_INCOME_CURRDAY_INNERACCT ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scm.scanChargeInneracctIncome,0)),1) AS INCOME_CURRMON_INNERACCT, ROUND(SUM(IFNULL(scm.scanChargeInneracctIncome,0)),1) AS MIX_INCOME_CURRMON_INNERACCT ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scy.scanChargeInneracctIncome,0)),1) AS INCOME_CURRYER_INNERACCT, ROUND(SUM(IFNULL(scy.scanChargeInneracctIncome,0)),1) AS MIX_INCOME_CURRYER_INNERACCT ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(sct.cardChargeIncome,0)),0) AS INCOME_TOTAL_EBCRGCARD, ROUND(SUM(IFNULL(sct.cardChargeIncome,0)),0) AS MIX_INCOME_TOTAL_EBCRGCARD ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scd.cardChargeIncome,0)),1) AS INCOME_CURRDAY_EBCRGCARD, ROUND(SUM(IFNULL(scd.cardChargeIncome,0)),1) AS MIX_INCOME_CURRDAY_EBCRGCARD ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scm.cardChargeIncome,0)),1) AS INCOME_CURRMON_EBCRGCARD, ROUND(SUM(IFNULL(scm.cardChargeIncome,0)),1) AS MIX_INCOME_CURRMON_EBCRGCARD ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scy.cardChargeIncome,0)),1) AS INCOME_CURRYER_EBCRGCARD, ROUND(SUM(IFNULL(scy.cardChargeIncome,0)),1) AS MIX_INCOME_CURRYER_EBCRGCARD ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(sct.coinChargeIncome,0)),0) AS INCOME_TOTAL_EBCRGCOIN, ROUND(SUM(IFNULL(sct.coinChargeIncome,0)),0) AS MIX_INCOME_TOTAL_EBCRGCOIN ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scd.coinChargeIncome,0)),1) AS INCOME_CURRDAY_EBCRGCOIN, ROUND(SUM(IFNULL(scd.coinChargeIncome,0)),1) AS MIX_INCOME_CURRDAY_EBCRGCOIN ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scm.coinChargeIncome,0)),1) AS INCOME_CURRMON_EBCRGCOIN, ROUND(SUM(IFNULL(scm.coinChargeIncome,0)),1) AS MIX_INCOME_CURRMON_EBCRGCOIN ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scy.coinChargeIncome,0)),1) AS INCOME_CURRYER_EBCRGCOIN, ROUND(SUM(IFNULL(scy.coinChargeIncome,0)),1) AS MIX_INCOME_CURRYER_EBCRGCOIN ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(sct.chargeElecCons,0)),0) AS ELECCONS_TOTAL, ROUND(SUM(IFNULL(sct.chargeElecCons,0)),0) AS MIX_ELECCONS_TOTAL ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scd.chargeElecCons,0)),1) AS ELECCONS_CURRDAY, ROUND(SUM(IFNULL(scd.chargeElecCons,0)),1) AS MIX_ELECCONS_CURRDAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scm.chargeElecCons,0)),1) AS ELECCONS_CURRMON, ROUND(SUM(IFNULL(scm.chargeElecCons,0)),1) AS MIX_ELECCONS_CURRMON ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scy.chargeElecCons,0)),1) AS ELECCONS_CURRYER, ROUND(SUM(IFNULL(scy.chargeElecCons,0)),1) AS MIX_ELECCONS_CURRYER ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(sct.scanChargeWxpayElecCons,0)),0) AS ELECCONS_TOTAL_WXPAY, ROUND(SUM(IFNULL(sct.scanChargeWxpayElecCons,0)),0) AS MIX_ELECCONS_TOTAL_WXPAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scd.scanChargeWxpayElecCons,0)),1) AS ELECCONS_CURRDAY_WXPAY, ROUND(SUM(IFNULL(scd.scanChargeWxpayElecCons,0)),1) AS MIX_ELECCONS_CURRDAY_WXPAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scm.scanChargeWxpayElecCons,0)),1) AS ELECCONS_CURRMON_WXPAY, ROUND(SUM(IFNULL(scm.scanChargeWxpayElecCons,0)),1) AS MIX_ELECCONS_CURRMON_WXPAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scy.scanChargeWxpayElecCons,0)),1) AS ELECCONS_CURRYER_WXPAY, ROUND(SUM(IFNULL(scy.scanChargeWxpayElecCons,0)),1) AS MIX_ELECCONS_CURRYER_WXPAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(sct.scanChargeAlipayElecCons,0)),0) AS ELECCONS_TOTAL_ALIPAY, ROUND(SUM(IFNULL(sct.scanChargeAlipayElecCons,0)),0) AS MIX_ELECCONS_TOTAL_ALIPAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scd.scanChargeAlipayElecCons,0)),1) AS ELECCONS_CURRDAY_ALIPAY, ROUND(SUM(IFNULL(scd.scanChargeAlipayElecCons,0)),1) AS MIX_ELECCONS_CURRDAY_ALIPAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scm.scanChargeAlipayElecCons,0)),1) AS ELECCONS_CURRMON_ALIPAY, ROUND(SUM(IFNULL(scm.scanChargeAlipayElecCons,0)),1) AS MIX_ELECCONS_CURRMON_ALIPAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scy.scanChargeAlipayElecCons,0)),1) AS ELECCONS_CURRYER_ALIPAY, ROUND(SUM(IFNULL(scy.scanChargeAlipayElecCons,0)),1) AS MIX_ELECCONS_CURRYER_ALIPAY ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(sct.scanChargeInneracctElecCons,0)),0) AS ELECCONS_TOTAL_INNERACCT, ROUND(SUM(IFNULL(sct.scanChargeInneracctElecCons,0)),0) AS MIX_ELECCONS_TOTAL_INNERACCT ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scd.scanChargeInneracctElecCons,0)),1) AS ELECCONS_CURRDAY_INNERACCT, ROUND(SUM(IFNULL(scd.scanChargeInneracctElecCons,0)),1) AS MIX_ELECCONS_CURRDAY_INNERACCT ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scm.scanChargeInneracctElecCons,0)),1) AS ELECCONS_CURRMON_INNERACCT, ROUND(SUM(IFNULL(scm.scanChargeInneracctElecCons,0)),1) AS MIX_ELECCONS_CURRMON_INNERACCT ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scy.scanChargeInneracctElecCons,0)),1) AS ELECCONS_CURRYER_INNERACCT, ROUND(SUM(IFNULL(scy.scanChargeInneracctElecCons,0)),1) AS MIX_ELECCONS_CURRYER_INNERACCT ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(sct.cardChargeElecCons,0)),0) AS ELECCONS_TOTAL_EBCRGCARD, ROUND(SUM(IFNULL(sct.cardChargeElecCons,0)),0) AS MIX_ELECCONS_TOTAL_EBCRGCARD ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scd.cardChargeElecCons,0)),1) AS ELECCONS_CURRDAY_EBCRGCARD, ROUND(SUM(IFNULL(scd.cardChargeElecCons,0)),1) AS MIX_ELECCONS_CURRDAY_EBCRGCARD ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scm.cardChargeElecCons,0)),1) AS ELECCONS_CURRMON_EBCRGCARD, ROUND(SUM(IFNULL(scm.cardChargeElecCons,0)),1) AS MIX_ELECCONS_CURRMON_EBCRGCARD ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scy.cardChargeElecCons,0)),1) AS ELECCONS_CURRYER_EBCRGCARD, ROUND(SUM(IFNULL(scy.cardChargeElecCons,0)),1) AS MIX_ELECCONS_CURRYER_EBCRGCARD ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(sct.coinChargeElecCons,0)),0) AS ELECCONS_TOTAL_EBCRGCOIN, ROUND(SUM(IFNULL(sct.coinChargeElecCons,0)),0) AS MIX_ELECCONS_TOTAL_EBCRGCOIN ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scd.coinChargeElecCons,0)),1) AS ELECCONS_CURRDAY_EBCRGCOIN, ROUND(SUM(IFNULL(scd.coinChargeElecCons,0)),1) AS MIX_ELECCONS_CURRDAY_EBCRGCOIN ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scm.coinChargeElecCons,0)),1) AS ELECCONS_CURRMON_EBCRGCOIN, ROUND(SUM(IFNULL(scm.coinChargeElecCons,0)),1) AS MIX_ELECCONS_CURRMON_EBCRGCOIN ");
            sqlBuilder.append("     , ROUND(SUM(IFNULL(scy.coinChargeElecCons,0)),1) AS ELECCONS_CURRYER_EBCRGCOIN, ROUND(SUM(IFNULL(scy.coinChargeElecCons,0)),1) AS MIX_ELECCONS_CURRYER_EBCRGCOIN ");
            sqlBuilder.append("  FROM cisp_dev.dev_ebikechargestation ecs ");
            sqlBuilder.append(" INNER JOIN cisp_dev.dev_powersystemresource psr ON psr.id = ecs.id AND psr.className = 'EBikeChargeStation' ");
            sqlBuilder.append(" INNER JOIN ebike.code_adcode ad ON ad.adcode = ecs.adcode ");
            sqlBuilder.append("  LEFT JOIN (SELECT ecr.chargestationId, SUM(IF(ecr.chargePayMode IN ('1'), 1, 0)) AS scanChargeCnt, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('WXPAY'), 1, 0)) AS scanChargeWxpayCnt, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('ALIPAY'), 1, 0)) AS scanChargeAlipayCnt, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('INNERACCT'), 1, 0)) AS scanChargeInneracctCnt, SUM(IF(ecr.chargePayMode IN ('2'), 1, 0)) AS coinChargeCnt, SUM(IF(ecr.chargePayMode IN ('3'), 1, 0)) AS cardChargeCnt, SUM(IF(ecr.chargePayMode IN ('1'), ecr.income, 0)) AS scanChargeIncome, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('WXPAY'), ecr.income, 0)) AS scanChargeWxpayIncome, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('ALIPAY'), ecr.income, 0)) AS scanChargeAlipayIncome, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('INNERACCT'), ecr.income, 0)) AS scanChargeInneracctIncome, SUM(IF(ecr.chargePayMode IN ('2'), ecr.income, 0)) AS coinChargeIncome, SUM(IF(ecr.chargePayMode IN ('3'), ecr.income, 0)) AS cardChargeIncome, SUM(IF(ecr.chargePayMode IN ('1','2','3','4'), ecr.usageElecCons, 0)) AS chargeElecCons, SUM(IF(ecr.chargePayMode IN ('1'), ecr.usageElecCons, 0)) AS scanChargeElecCons, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('WXPAY'), ecr.usageElecCons, 0)) AS scanChargeWxpayElecCons, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('ALIPAY'), ecr.usageElecCons, 0)) AS scanChargeAlipayElecCons, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('INNERACCT'), ecr.usageElecCons, 0)) AS scanChargeInneracctElecCons, SUM(IF(ecr.chargePayMode IN ('2'), ecr.usageElecCons, 0)) AS coinChargeElecCons, SUM(IF(ecr.chargePayMode IN ('3'), ecr.usageElecCons, 0)) AS cardChargeElecCons FROM ebike.ebike_chargerecord_his ecr LEFT JOIN ebpay.trade_order t ON t.order_id = ecr.chargeTradeOrderId WHERE 1 = 1 GROUP BY ecr.chargestationId) sct ON sct.chargestationId = ecs.id ");
            sqlBuilder.append("  LEFT JOIN (SELECT ecr.chargestationId, SUM(IF(ecr.chargePayMode IN ('1'), 1, 0)) AS scanChargeCnt, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('WXPAY'), 1, 0)) AS scanChargeWxpayCnt, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('ALIPAY'), 1, 0)) AS scanChargeAlipayCnt, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('INNERACCT'), 1, 0)) AS scanChargeInneracctCnt, SUM(IF(ecr.chargePayMode IN ('2'), 1, 0)) AS coinChargeCnt, SUM(IF(ecr.chargePayMode IN ('3'), 1, 0)) AS cardChargeCnt, SUM(IF(ecr.chargePayMode IN ('1'), ecr.income, 0)) AS scanChargeIncome, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('WXPAY'), ecr.income, 0)) AS scanChargeWxpayIncome, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('ALIPAY'), ecr.income, 0)) AS scanChargeAlipayIncome, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('INNERACCT'), ecr.income, 0)) AS scanChargeInneracctIncome, SUM(IF(ecr.chargePayMode IN ('2'), ecr.income, 0)) AS coinChargeIncome, SUM(IF(ecr.chargePayMode IN ('3'), ecr.income, 0)) AS cardChargeIncome, SUM(IF(ecr.chargePayMode IN ('1','2','3','4'), ecr.usageElecCons, 0)) AS chargeElecCons, SUM(IF(ecr.chargePayMode IN ('1'), ecr.usageElecCons, 0)) AS scanChargeElecCons, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('WXPAY'), ecr.usageElecCons, 0)) AS scanChargeWxpayElecCons, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('ALIPAY'), ecr.usageElecCons, 0)) AS scanChargeAlipayElecCons, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('INNERACCT'), ecr.usageElecCons, 0)) AS scanChargeInneracctElecCons, SUM(IF(ecr.chargePayMode IN ('2'), ecr.usageElecCons, 0)) AS coinChargeElecCons, SUM(IF(ecr.chargePayMode IN ('3'), ecr.usageElecCons, 0)) AS cardChargeElecCons FROM ebike.ebike_chargerecord_his ecr LEFT JOIN ebpay.trade_order t ON t.order_id = ecr.chargeTradeOrderId WHERE ecr.chargeFinishTime >= STR_TO_DATE(CONCAT(?, '-01-01'), '%Y-%m-%d') GROUP BY ecr.chargestationId) scy ON scy.chargestationId = ecs.id ");
            sqlParams.add(DateFormatUtils.format(date, "yyyy"));
            sqlBuilder.append("  LEFT JOIN (SELECT ecr.chargestationId, SUM(IF(ecr.chargePayMode IN ('1'), 1, 0)) AS scanChargeCnt, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('WXPAY'), 1, 0)) AS scanChargeWxpayCnt, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('ALIPAY'), 1, 0)) AS scanChargeAlipayCnt, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('INNERACCT'), 1, 0)) AS scanChargeInneracctCnt, SUM(IF(ecr.chargePayMode IN ('2'), 1, 0)) AS coinChargeCnt, SUM(IF(ecr.chargePayMode IN ('3'), 1, 0)) AS cardChargeCnt, SUM(IF(ecr.chargePayMode IN ('1'), ecr.income, 0)) AS scanChargeIncome, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('WXPAY'), ecr.income, 0)) AS scanChargeWxpayIncome, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('ALIPAY'), ecr.income, 0)) AS scanChargeAlipayIncome, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('INNERACCT'), ecr.income, 0)) AS scanChargeInneracctIncome, SUM(IF(ecr.chargePayMode IN ('2'), ecr.income, 0)) AS coinChargeIncome, SUM(IF(ecr.chargePayMode IN ('3'), ecr.income, 0)) AS cardChargeIncome, SUM(IF(ecr.chargePayMode IN ('1','2','3','4'), ecr.usageElecCons, 0)) AS chargeElecCons, SUM(IF(ecr.chargePayMode IN ('1'), ecr.usageElecCons, 0)) AS scanChargeElecCons, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('WXPAY'), ecr.usageElecCons, 0)) AS scanChargeWxpayElecCons, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('ALIPAY'), ecr.usageElecCons, 0)) AS scanChargeAlipayElecCons, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('INNERACCT'), ecr.usageElecCons, 0)) AS scanChargeInneracctElecCons, SUM(IF(ecr.chargePayMode IN ('2'), ecr.usageElecCons, 0)) AS coinChargeElecCons, SUM(IF(ecr.chargePayMode IN ('3'), ecr.usageElecCons, 0)) AS cardChargeElecCons FROM ebike.ebike_chargerecord_his ecr LEFT JOIN ebpay.trade_order t ON t.order_id = ecr.chargeTradeOrderId WHERE ecr.chargeFinishTime >= STR_TO_DATE(CONCAT(?, '-01'), '%Y-%m-%d') GROUP BY ecr.chargestationId) scm ON scm.chargestationId = ecs.id ");
            sqlParams.add(DateFormatUtils.format(date, "yyyy-MM"));
            sqlBuilder.append("  LEFT JOIN (SELECT ecr.chargestationId, SUM(IF(ecr.chargePayMode IN ('1'), 1, 0)) AS scanChargeCnt, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('WXPAY'), 1, 0)) AS scanChargeWxpayCnt, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('ALIPAY'), 1, 0)) AS scanChargeAlipayCnt, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('INNERACCT'), 1, 0)) AS scanChargeInneracctCnt, SUM(IF(ecr.chargePayMode IN ('2'), 1, 0)) AS coinChargeCnt, SUM(IF(ecr.chargePayMode IN ('3'), 1, 0)) AS cardChargeCnt, SUM(IF(ecr.chargePayMode IN ('1'), ecr.income, 0)) AS scanChargeIncome, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('WXPAY'), ecr.income, 0)) AS scanChargeWxpayIncome, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('ALIPAY'), ecr.income, 0)) AS scanChargeAlipayIncome, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('INNERACCT'), ecr.income, 0)) AS scanChargeInneracctIncome, SUM(IF(ecr.chargePayMode IN ('2'), ecr.income, 0)) AS coinChargeIncome, SUM(IF(ecr.chargePayMode IN ('3'), ecr.income, 0)) AS cardChargeIncome, SUM(IF(ecr.chargePayMode IN ('1','2','3','4'), ecr.usageElecCons, 0)) AS chargeElecCons, SUM(IF(ecr.chargePayMode IN ('1'), ecr.usageElecCons, 0)) AS scanChargeElecCons, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('WXPAY'), ecr.usageElecCons, 0)) AS scanChargeWxpayElecCons, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('ALIPAY'), ecr.usageElecCons, 0)) AS scanChargeAlipayElecCons, SUM(IF(ecr.chargePayMode IN ('1') AND t.pay_type IN ('INNERACCT'), ecr.usageElecCons, 0)) AS scanChargeInneracctElecCons, SUM(IF(ecr.chargePayMode IN ('2'), ecr.usageElecCons, 0)) AS coinChargeElecCons, SUM(IF(ecr.chargePayMode IN ('3'), ecr.usageElecCons, 0)) AS cardChargeElecCons FROM ebike.ebike_chargerecord_his ecr LEFT JOIN ebpay.trade_order t ON t.order_id = ecr.chargeTradeOrderId WHERE ecr.chargeFinishTime >= STR_TO_DATE(?, '%Y-%m-%d') GROUP BY ecr.chargestationId) scd ON scd.chargestationId = ecs.id ");
            sqlParams.add(DateFormatUtils.format(date, "yyyy-MM-dd"));
        }
        m.put("sql", sqlBuilder.toString());
        m.put("params", sqlParams);
        return m;
    }

    private Map<String, Object> buildAdindRealtimeDataSqlByChargeUser(Boolean isAll, String adfield, Date date) {
        Map<String, Object> m = new HashMap<>();
        StringBuilder sqlBuilder = new StringBuilder();
        List<Object> sqlParams = new ArrayList<>();
        // 充电用户信息：USERCNT_TOTAL 累计充电用户数、USERCNT_CURRDAY 当日累计充电用户数、USERCNT_CURRMON 当月累计充电用户数、USERCNT_CURRYER 当年累计充电用户数、USERCNT_BECRGING 正在充电用户数
        if(isAll) {
            // '000000000' 是平台级
            sqlBuilder.append("SELECT '000000000', '000000000', ecs.").append(adfield).append(" ");
            sqlBuilder.append("     , SUM(IFNULL(sct.chargeUserCnt,0)) AS USERCNT_TOTAL, SUM(IFNULL(sct.chargeUserCnt,0)) AS MIX_USERCNT_TOTAL ");
            sqlBuilder.append("     , SUM(IFNULL(scd.chargeUserCnt,0)) AS USERCNT_CURRDAY, SUM(IFNULL(scd.chargeUserCnt,0)) AS MIX_USERCNT_CURRDAY ");
            sqlBuilder.append("     , SUM(IFNULL(scm.chargeUserCnt,0)) AS USERCNT_CURRMON, SUM(IFNULL(scm.chargeUserCnt,0)) AS MIX_USERCNT_CURRMON ");
            sqlBuilder.append("     , SUM(IFNULL(scm.chargeUserCnt,0)) AS USERCNT_LIVEMON, SUM(IFNULL(scm.chargeUserCnt,0)) AS MIX_USERCNT_LIVEMON ");
            sqlBuilder.append("     , SUM(IFNULL(scy.chargeUserCnt,0)) AS USERCNT_CURRYER, SUM(IFNULL(scy.chargeUserCnt,0)) AS MIX_USERCNT_CURRYER ");
            sqlBuilder.append("     , SUM(IFNULL(cur.chargeUserCnt,0)) AS USERCNT_BECRGING, SUM(IFNULL(cur.chargeUserCnt,0)) AS MIX_USERCNT_BECRGING ");
            sqlBuilder.append("  FROM (SELECT DISTINCT d.").append(adfield).append(" FROM cisp_dev.dev_ebikechargestation b, cisp_dev.dev_powersystemresource c, ebike.code_adcode d WHERE b.id = c.id AND c.className = 'EBikeChargeStation' AND d.adcode = b.adcode) ecs ");
            sqlBuilder.append("  LEFT JOIN (SELECT d.").append(adfield).append(", COUNT(DISTINCT chargeUserId) AS chargeUserCnt FROM ebike.ebike_chargerecord_his a, cisp_dev.dev_ebikechargestation b, cisp_dev.dev_powersystemresource c, ebike.code_adcode d WHERE a.chargestationId = b.id AND b.id = c.id AND c.className = 'EBikeChargeStation' AND d.adcode = b.adcode GROUP BY d.").append(adfield).append(") sct ON sct.").append(adfield).append(" = ecs.").append(adfield).append(" ");
            sqlBuilder.append("  LEFT JOIN (SELECT d.").append(adfield).append(", COUNT(DISTINCT chargeUserId) AS chargeUserCnt FROM ebike.ebike_chargerecord_his a, cisp_dev.dev_ebikechargestation b, cisp_dev.dev_powersystemresource c, ebike.code_adcode d WHERE a.chargestationId = b.id AND b.id = c.id AND c.className = 'EBikeChargeStation' AND d.adcode = b.adcode AND a.chargeFinishTime >= STR_TO_DATE(?, '%Y-%m-%d') GROUP BY d.").append(adfield).append(") scy ON scy.").append(adfield).append(" = ecs.").append(adfield).append(" ");
            sqlParams.add(DateFormatUtils.format(date, "yyyy") + "-01-01");
            sqlBuilder.append("  LEFT JOIN (SELECT d.").append(adfield).append(", COUNT(DISTINCT chargeUserId) AS chargeUserCnt FROM ebike.ebike_chargerecord_his a, cisp_dev.dev_ebikechargestation b, cisp_dev.dev_powersystemresource c, ebike.code_adcode d WHERE a.chargestationId = b.id AND b.id = c.id AND c.className = 'EBikeChargeStation' AND d.adcode = b.adcode AND a.chargeFinishTime >= STR_TO_DATE(?, '%Y-%m-%d') GROUP BY d.").append(adfield).append(") scm ON scm.").append(adfield).append(" = ecs.").append(adfield).append(" ");
            sqlParams.add(DateFormatUtils.format(date, "yyyy-MM") + "-01");
            sqlBuilder.append("  LEFT JOIN (SELECT d.").append(adfield).append(", COUNT(DISTINCT chargeUserId) AS chargeUserCnt FROM ebike.ebike_chargerecord_his a, cisp_dev.dev_ebikechargestation b, cisp_dev.dev_powersystemresource c, ebike.code_adcode d WHERE a.chargestationId = b.id AND b.id = c.id AND c.className = 'EBikeChargeStation' AND d.adcode = b.adcode AND a.chargeFinishTime >= STR_TO_DATE(?, '%Y-%m-%d') GROUP BY d.").append(adfield).append(") scd ON scd.").append(adfield).append(" = ecs.").append(adfield).append(" ");
            sqlParams.add(DateFormatUtils.format(date, "yyyy-MM-dd"));
            sqlBuilder.append("  LEFT JOIN (SELECT d.").append(adfield).append(", COUNT(DISTINCT chargeUserId) AS chargeUserCnt FROM ebike.ebike_chargerecord a, cisp_dev.dev_ebikechargestation b, cisp_dev.dev_powersystemresource c, ebike.code_adcode d WHERE a.chargestationId = b.id AND b.id = c.id AND c.className = 'EBikeChargeStation' AND d.adcode = b.adcode GROUP BY d.").append(adfield).append(") cur ON cur.").append(adfield).append(" = ecs.").append(adfield).append(" ");
            sqlBuilder.append(" GROUP BY ecs.").append(adfield).append(" ");
        }
        else {
            sqlBuilder.append("SELECT ecs.buro, ecs.subburo, ecs.").append(adfield).append(" ");
            sqlBuilder.append("     , SUM(IFNULL(sct.chargeUserCnt,0)) AS USERCNT_TOTAL, SUM(IFNULL(sct.chargeUserCnt,0)) AS MIX_USERCNT_TOTAL ");
            sqlBuilder.append("     , SUM(IFNULL(scd.chargeUserCnt,0)) AS USERCNT_CURRDAY, SUM(IFNULL(scd.chargeUserCnt,0)) AS MIX_USERCNT_CURRDAY ");
            sqlBuilder.append("     , SUM(IFNULL(scm.chargeUserCnt,0)) AS USERCNT_CURRMON, SUM(IFNULL(scm.chargeUserCnt,0)) AS MIX_USERCNT_CURRMON ");
            sqlBuilder.append("     , SUM(IFNULL(scm.chargeUserCnt,0)) AS USERCNT_LIVEMON, SUM(IFNULL(scm.chargeUserCnt,0)) AS MIX_USERCNT_LIVEMON ");
            sqlBuilder.append("     , SUM(IFNULL(scy.chargeUserCnt,0)) AS USERCNT_CURRYER, SUM(IFNULL(scy.chargeUserCnt,0)) AS MIX_USERCNT_CURRYER ");
            sqlBuilder.append("     , SUM(IFNULL(cur.chargeUserCnt,0)) AS USERCNT_BECRGING, SUM(IFNULL(cur.chargeUserCnt,0)) AS MIX_USERCNT_BECRGING ");
            sqlBuilder.append("  FROM (SELECT DISTINCT c.buro, c.subburo, d.").append(adfield).append(" FROM cisp_dev.dev_ebikechargestation b, cisp_dev.dev_powersystemresource c, ebike.code_adcode d WHERE b.id = c.id AND c.className = 'EBikeChargeStation' AND d.adcode = b.adcode) ecs ");
            sqlBuilder.append("  LEFT JOIN (SELECT c.buro, c.subburo, d.").append(adfield).append(", COUNT(DISTINCT chargeUserId) AS chargeUserCnt FROM ebike.ebike_chargerecord_his a, cisp_dev.dev_ebikechargestation b, cisp_dev.dev_powersystemresource c, ebike.code_adcode d WHERE a.chargestationId = b.id AND b.id = c.id AND c.className = 'EBikeChargeStation' AND d.adcode = b.adcode GROUP BY c.buro, c.subburo, d.").append(adfield).append(") sct ON sct.buro = ecs.buro AND sct.subburo = ecs.subburo AND sct.").append(adfield).append(" = ecs.").append(adfield).append(" ");
            sqlBuilder.append("  LEFT JOIN (SELECT c.buro, c.subburo, d.").append(adfield).append(", COUNT(DISTINCT chargeUserId) AS chargeUserCnt FROM ebike.ebike_chargerecord_his a, cisp_dev.dev_ebikechargestation b, cisp_dev.dev_powersystemresource c, ebike.code_adcode d WHERE a.chargestationId = b.id AND b.id = c.id AND c.className = 'EBikeChargeStation' AND d.adcode = b.adcode AND a.chargeFinishTime >= STR_TO_DATE(?, '%Y-%m-%d') GROUP BY c.buro, c.subburo, d.").append(adfield).append(") scy ON scy.buro = ecs.buro AND scy.subburo = ecs.subburo AND scy.").append(adfield).append(" = ecs.").append(adfield).append(" ");
            sqlParams.add(DateFormatUtils.format(date, "yyyy") + "-01-01");
            sqlBuilder.append("  LEFT JOIN (SELECT c.buro, c.subburo, d.").append(adfield).append(", COUNT(DISTINCT chargeUserId) AS chargeUserCnt FROM ebike.ebike_chargerecord_his a, cisp_dev.dev_ebikechargestation b, cisp_dev.dev_powersystemresource c, ebike.code_adcode d WHERE a.chargestationId = b.id AND b.id = c.id AND c.className = 'EBikeChargeStation' AND d.adcode = b.adcode AND a.chargeFinishTime >= STR_TO_DATE(?, '%Y-%m-%d') GROUP BY c.buro, c.subburo, d.").append(adfield).append(") scm ON scm.buro = ecs.buro AND scm.subburo = ecs.subburo AND scm.").append(adfield).append(" = ecs.").append(adfield).append(" ");
            sqlParams.add(DateFormatUtils.format(date, "yyyy-MM") + "-01");
            sqlBuilder.append("  LEFT JOIN (SELECT c.buro, c.subburo, d.").append(adfield).append(", COUNT(DISTINCT chargeUserId) AS chargeUserCnt FROM ebike.ebike_chargerecord_his a, cisp_dev.dev_ebikechargestation b, cisp_dev.dev_powersystemresource c, ebike.code_adcode d WHERE a.chargestationId = b.id AND b.id = c.id AND c.className = 'EBikeChargeStation' AND d.adcode = b.adcode AND a.chargeFinishTime >= STR_TO_DATE(?, '%Y-%m-%d') GROUP BY c.buro, c.subburo, d.").append(adfield).append(") scd ON scd.buro = ecs.buro AND scd.subburo = ecs.subburo AND scd.").append(adfield).append(" = ecs.").append(adfield).append(" ");
            sqlParams.add(DateFormatUtils.format(date, "yyyy-MM-dd"));
            sqlBuilder.append("  LEFT JOIN (SELECT c.buro, c.subburo, d.").append(adfield).append(", COUNT(DISTINCT chargeUserId) AS chargeUserCnt FROM ebike.ebike_chargerecord a, cisp_dev.dev_ebikechargestation b, cisp_dev.dev_powersystemresource c, ebike.code_adcode d WHERE a.chargestationId = b.id AND b.id = c.id AND c.className = 'EBikeChargeStation' AND d.adcode = b.adcode GROUP BY c.buro, c.subburo, d.").append(adfield).append(") cur ON cur.buro = ecs.buro AND cur.subburo = ecs.subburo AND cur.").append(adfield).append(" = ecs.").append(adfield).append("  ");
            sqlBuilder.append(" GROUP BY ecs.buro, ecs.subburo, ecs.").append(adfield).append(" ");
        }
        m.put("sql", sqlBuilder.toString());
        m.put("params", sqlParams);
        return m;
    }

    @Override
    @SuppressWarnings("unchecked")
    public void calcAdindRealtimeData() {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start calcAdindRealtimeData >>>>>> ");
        }
        Date now = new Date();
        Joiner joiner = Joiner.on(" ").skipNulls();
        List<AdcodeIndData> results = Lists.newArrayList();
        String[] adarray = {"district", "city", "province", "country"};
        for(int i = 1; i <= 6; i++) {
            Map<String, Object> sqlMap = buildAdindRealtimeDataSql(i, now);
            if(MapUtils.isNotEmpty(sqlMap)) {
                String sql = (String) sqlMap.get("sql");
                List<Object> params = (List<Object>) sqlMap.get("params");
                for(String adfield : adarray) {
                    String sqlAs = joiner.join("SELECT psr.buro, psr.subburo, ad." + adfield, sql, "GROUP BY psr.buro, psr.subburo, ad." + adfield);
                    List<List<AdcodeIndData>> aidssAs = ebikeJdbcTemplate.query(sqlAs, params.toArray(), indDataListRowMapper);
                    for(List<AdcodeIndData> aids : aidssAs) {
                        results.addAll(aids);
                    }
                    String sqlAt = joiner.join("SELECT '000000000', '000000000', ad." + adfield, sql, "GROUP BY ad." + adfield);
                    List<List<AdcodeIndData>> aidssAt = ebikeJdbcTemplate.query(sqlAt, params.toArray(), indDataListRowMapper);
                    for(List<AdcodeIndData> aids : aidssAt) {
                        results.addAll(aids);
                    }

                    // 充电用户统计
                    Map<String, Object> sqlChargeUserMap1 = buildAdindRealtimeDataSqlByChargeUser(false, adfield, now);
                    List<List<AdcodeIndData>> aidssChargeUserPs = ebikeJdbcTemplate.query((String) sqlChargeUserMap1.get("sql"), ((List<Object>) sqlChargeUserMap1.get("params")).toArray(), indDataListRowMapper);
                    for(List<AdcodeIndData> aids : aidssChargeUserPs) {
                        results.addAll(aids);
                    }
                    Map<String, Object> sqlChargeUserMap2 = buildAdindRealtimeDataSqlByChargeUser(true, adfield, now);
                    List<List<AdcodeIndData>> aidssChargeUserPt = ebikeJdbcTemplate.query((String) sqlChargeUserMap2.get("sql"), ((List<Object>) sqlChargeUserMap2.get("params")).toArray(), indDataListRowMapper);
                    for(List<AdcodeIndData> aids : aidssChargeUserPt) {
                        results.addAll(aids);
                    }
                }
            }
        }

        String sqlBatchUpdate = "INSERT INTO ebike.ebike_adcodeind_realtime (buro, subburo, adcode, indCode, indValue, indName, updateTime) " +
                "SELECT ?, ?, ?, ?, ?, ?, ? " +
                "ON DUPLICATE KEY UPDATE indValue = VALUES(indValue), indName = VALUES(indName), updateTime = VALUES(updateTime) ";

        ebikeJdbcTemplate.batchUpdate(sqlBatchUpdate, new BatchPreparedStatementSetter() {

            @Override
            public int getBatchSize() {
                return results.size();
            }

            @Override
            public void setValues(PreparedStatement ps, int romNum) throws SQLException {
                AdcodeIndData aid = results.get(romNum);
                ps.setString(1, aid.getBuro());
                ps.setString(2, aid.getSubburo());
                ps.setString(3, aid.getAdcode());
                ps.setString(4, aid.getIndCode());
                ps.setString(5, aid.getIndValue());
                ps.setString(6, aid.getIndName());
                ps.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
            }

        });

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end calcAdindRealtimeData <<<<<<<  ");
        }
    }

    @Override
    public void calcOrgindRealtimeData() {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start calcOrgindRealtimeData >>>>>> ");
        }
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end calcOrgindRealtimeData <<<<<<<  ");
        }
    }

}
