package cn.yunrui.bizservices.ebikemgmt.service.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.*;
import cn.yunrui.bizservices.ebikemgmt.entity.*;
import cn.yunrui.bizservices.ebikemgmt.service.ChargeService;
import cn.yunrui.bizservices.ebikemgmt.utils.BillingUtil;
import cn.yunrui.mqttclient.ebikesrv.common.utils.*;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.service.EBikeChargeService;
import com.google.common.base.Joiner;
import org.apache.commons.lang3.RandomUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 充电服务
 *
 * @author Nick Zhang
 * @date 2019-07-09
 */
public class ChargeServiceImpl implements ChargeService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource(name = "billingSchemeDao")
    private BillingSchemeDao billingSchemeDao;

    @Resource(name = "costSchemeDao")
    private CostSchemeDao costSchemeDao;

    @Resource(name = "chargeDao")
    private ChargeDao chargeDao;

    @Resource(name = "serviceRateDao")
    private ServiceRateDao serviceRateDao;

    @Resource(name = "fitConnectDao")
    private FitConnectDao fitConnectDao;

    @Resource(name = "ebikeChargeService")
    private EBikeChargeService ebikeChargeService;

    private String getNewChargeRecordId(String chargeplugNo, Date chargeTime) {
        return Joiner.on("-").skipNulls().join("EB" + chargeplugNo, new DateTime(chargeTime).toString("yyyyMMddHHmmssSSS"), RandomUtils.nextInt(101, 999));
    }

    @Override
    public ChargeResponse charge(ChargeRequest chargeRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start charge >>>>>> ");
            logger.debug(" chargeRequest : " + (chargeRequest != null ? chargeRequest.toString() : null));
        }

        String chargeRecordId;
        Date requestTime = new Date();
        Date chargeTime = new Date();
        ChargeResponse chargeResponse = new ChargeResponse();
        chargeResponse.setStatus(-1);
        chargeResponse.setMsg("下发开始/结束充电命令失败");
        if(chargeRequest != null) {
            // 充电插座编号（充电设备编号 + 2位插座序号（如：01、02、…））
            String chargeplugNo = chargeRequest.getChargeplugNo();
            // 获取充电记录标识
            chargeRecordId = getNewChargeRecordId(chargeplugNo, chargeTime);

            //
            int insCrlResult = chargeDao.insertChargeRequestLog(requestTime, chargeRequest, chargeRecordId);
            boolean gnrtChargeRecord = false;
            String gnrtFailReason = "";
            if(insCrlResult > 0) {
                if(logger.isDebugEnabled()) {
                    logger.debug(" insertChargeRequestLog success ");
                }

                String chargedeviceNo;                                  // 充电设备编号
                String plugSn;                                          // 充电插座序号
                if(chargeplugNo != null && chargeplugNo.trim().length() >= 3) {
                    chargedeviceNo = chargeplugNo.trim().substring(0, chargeplugNo.trim().length() - 2);
                    plugSn = chargeplugNo.trim().substring(chargeplugNo.trim().length() - 2);
                    ChargeDeviceInfo cdi = fitConnectDao.getChargeDeviceInfoFromAssetsRepo(chargeRequest.getOrgNo(), chargedeviceNo);
                    if(ObjectUtils.isNotNull(cdi) && StringUtils.isNotBlank(cdi.getDeviceId())) {
                        if(StringUtils.equals("start", chargeRequest.getType())) {
                            // 开始充电
                            if(logger.isDebugEnabled()) {
                                logger.debug(" 充电设备编号[chargedeviceNo] : " + chargedeviceNo + " , 充电插座序号[plugSn] : " + plugSn);
                                logger.debug(" 　　>>>>>> 开始充电... ");
                            }
                            // 获取充电插座标识
                            Map chargePlugValueMap = chargeDao.getChargePlugValueMap(chargeRequest.getOrgNo(), chargeRequest.getChargeplugNo());
                            if(MapUtils.isNotEmpty(chargePlugValueMap)) {
                                Long chargeplugId = (Long) chargePlugValueMap.get("chargeplugId");
                                Long chargedeviceId = (Long) chargePlugValueMap.get("chargedeviceId");
                                Long chargestationId = (Long) chargePlugValueMap.get("chargestationId");
                                // 判断充电插座是否正在充电
                                if(chargeDao.checkIsCharging(chargeplugId)) {
                                    chargeResponse.setStatus(-2);
                                    chargeResponse.setMsg("下发开始充电命令失败，充电插座正在充电");
                                }
                                else if(StringUtils.isNotBlank(chargeRequest.getChargeTradeOrderId()) && chargeDao.checkIsBeChargedByChargeTradeOrderId(chargeRequest.getChargeTradeOrderId())) {
                                    chargeResponse.setStatus(-6);
                                    chargeResponse.setMsg("下发开始充电命令失败，重复充电");
                                }
                                else {
                                    // 获取充电用户标识
                                    String chargeUserNo = chargeRequest.getChargeUserNo();
                                    String chargeUserType = chargeRequest.getChargeUserType();
                                    String chargeUserId = chargeDao.getChargeUserIdByChargeUserNo(chargeUserNo, chargeUserType);
                                    String msgExt = null;
                                    //
                                    if(StringUtils.isBlank(chargeUserId)) {
                                        if(StringUtils.equals(chargeUserType, "10")) {
                                            chargeUserType = "30";
                                            chargeUserId = chargeDao.getChargeUserIdByChargeUserNo(chargeUserNo, chargeUserType);
                                            msgExt = "充电用户类型（微信公众号）使用微信小程序充电";
                                        }
                                        else if(StringUtils.equals(chargeUserType, "30")) {
                                            chargeUserType = "10";
                                            chargeUserId = chargeDao.getChargeUserIdByChargeUserNo(chargeUserNo, chargeUserType);
                                            msgExt = "充电用户类型（微信小程序）使用微信公众号充电";
                                        }
                                    }
                                    // 获取计费方案信息
                                    BillingSchemeInfo bsi = billingSchemeDao.getBillingSchemeInfoByChargedeviceNo(chargeRequest.getOrgNo(), chargedeviceNo, chargeUserNo, chargeUserType);
                                    // 获取服务费率
                                    Double serviceRate = serviceRateDao.getServiceRateByChargestationId(chargestationId);
                                    // 获取成本方案
                                    CostSchemeInfo csi = costSchemeDao.getCostSchemeInfoByChargedeviceNo(chargeRequest.getOrgNo(), chargedeviceNo);
                                    if(logger.isDebugEnabled()) {
                                        logger.debug(" chargeUserId          : " + chargeUserId);
                                        logger.debug(" BillingSchemeInfo     : " + JsonConvertUtils.convertToString(bsi));
                                        logger.debug(" CostSchemeInfo        : " + JsonConvertUtils.convertToString(csi));
                                        logger.debug(" serviceRate           : " + serviceRate);
                                    }
                                    //
                                    if(StringUtils.isNotBlank(chargeUserId) && ObjectUtils.isNotNull(bsi)) {
                                        Map<String, Object> chargeRecordMap = BillingUtil.getChargeRecordMap(bsi, chargeRequest.getMoney());
                                        if(logger.isDebugEnabled()) {
                                            logger.debug(" 2.chargeRecordMap      : " + JsonConvertUtils.convertToString(chargeRecordMap));
                                        }
                                        if(chargeRecordMap != null) {
                                            chargeRecordMap.put("chargeRecordId", chargeRecordId);
                                            chargeRecordMap.put("chargeTime", chargeTime);
                                            chargeRecordMap.put("chargePayMode", 1);
                                            chargeRecordMap.put("chargeplugId", chargeplugId);
                                            chargeRecordMap.put("chargedeviceId", chargedeviceId);
                                            chargeRecordMap.put("chargestationId", chargestationId);
                                            chargeRecordMap.put("chargeUserId", chargeUserId);
                                            if(ObjectUtils.isNotNull(csi)) {
                                                chargeRecordMap.put("costSchemeId", csi.getCostSchemeId());
                                                chargeRecordMap.put("costUnitPrice", csi.getCostUnitPrice());
                                            }
                                            if(StringUtils.isNotBlank(chargeRequest.getChargeTradeOrderId())) {
                                                chargeRecordMap.put("chargeTradeOrderId", chargeRequest.getChargeTradeOrderId());
                                            }
                                            if(StringUtils.isNotBlank(chargeRequest.getEnterUserType())) {
                                                chargeRecordMap.put("enterUserType", chargeRequest.getEnterUserType());
                                            }
                                            if(StringUtils.isNotBlank(chargeRequest.getEnterUserId())) {
                                                chargeRecordMap.put("enterUserId", chargeRequest.getEnterUserId());
                                            }
                                            {
                                                chargeRecordMap.put("sharingReceivers", "{}");
                                                chargeRecordMap.put("sharingMoneyFreezeCycle", 25);
                                            }
                                            if(serviceRate != null) {
                                                chargeRecordMap.put("serviceRate", serviceRate);
                                            }

                                            //
                                            StringBuilder msg2Device = new StringBuilder();
                                            msg2Device.append(chargeRequest.getType());
                                            msg2Device.append("#").append(Integer.parseInt(plugSn));
                                            // 设备限制的最大充电电量，单位为1/1000度，需转换
                                            msg2Device.append("#").append(Math.round(((Double) chargeRecordMap.get("remainElecCons")) * 1000.0D));
                                            // 设备限制的最大充电时间，单位为分钟
                                            // 适配佳和新充电桩---下发超过999分钟，下发的值就是999
                                            long remainTime = Math.round((Double) chargeRecordMap.get("remainTime"));
                                            msg2Device.append("#").append(remainTime);
                                            if(logger.isDebugEnabled()) {
                                                logger.debug(" 3.chargeRecordMap      : " + JsonConvertUtils.convertToString(chargeRecordMap));
                                            }
                                            logger.info("<<==================正常充电-----------------开始充电报文========= >>: " + msg2Device);
                                            int result = chargeDao.insertChargeRecord(chargeRecordMap);
                                            if(result > 0) {
                                                chargeResponse.setChargeRecordId(chargeRecordId);
                                                // 下发开始充电命令
                                                boolean r = ebikeChargeService.publish2device(cdi.getDeviceId(), msg2Device.toString(), chargeRequest.getType());
                                                if(r) {
                                                    chargeResponse.setStatus(0);
                                                    chargeResponse.setMsg("下发开始充电命令成功" + (msgExt != null ? "（" + msgExt + "）" : ""));
                                                    gnrtChargeRecord = true;
                                                }
                                                else {
                                                    chargeResponse.setStatus(-1);
                                                    chargeResponse.setMsg("下发开始充电命令失败");
                                                }
                                            }
                                        }
                                        else {
                                            chargeResponse.setStatus(-5);
                                            chargeResponse.setMsg("下发开始充电命令失败，计费方案为空");
                                        }
                                    }
                                    else {
                                        if(StringUtils.isBlank(chargeUserId)) {
                                            chargeResponse.setStatus(-4);
                                            chargeResponse.setMsg("下发开始充电命令失败，无该充电用户");
                                        }
                                        else {
                                            chargeResponse.setStatus(-5);
                                            chargeResponse.setMsg("下发开始充电命令失败，计费方案为空");
                                        }
                                    }
                                }
                            }
                            else {
                                chargeResponse.setStatus(-3);
                                chargeResponse.setMsg("下发开始充电命令失败，无该充电插座");
                            }
                        }
                        else if(StringUtils.equals("stop", chargeRequest.getType())) {
                            // 结束充电
                            if(logger.isDebugEnabled()) {
                                logger.debug(" 充电设备编号[chargedeviceNo] : " + chargedeviceNo + " , 充电插座序号[plugSn] : " + plugSn);
                                logger.debug(" 　　<<<<<< 结束充电... ");
                            }
                            String msg2Device = chargeRequest.getType() + "#" + Integer.parseInt(plugSn);
                            // 下发结束充电命令
                            boolean r = ebikeChargeService.publish2device(cdi.getDeviceId(), msg2Device, chargeRequest.getType());
                            if(r) {
                                chargeResponse.setStatus(0);
                                chargeResponse.setMsg("下发结束充电命令成功");
                            }
                            else {
                                chargeResponse.setStatus(-1);
                                chargeResponse.setMsg("下发结束充电命令失败");
                            }
                        }
                    }
                    else {
                        chargeResponse.setStatus(-97);
                        chargeResponse.setMsg("无该充电设备");
                    }
                }
                else {
                    chargeResponse.setStatus(-98);
                    chargeResponse.setMsg("请求参数（充电插座编号）非法");
                }
                //
                Date responseTime = new Date();
                int uptCrlResult = chargeDao.updateChargeRequestLog(responseTime, chargeResponse, chargeRecordId, gnrtChargeRecord, gnrtFailReason);
                if(uptCrlResult > 0) {
                    if(logger.isDebugEnabled()) {
                        logger.debug(" updateChargeRequestLog success ");
                    }
                }
                else {
                    if(logger.isDebugEnabled()) {
                        logger.debug(" updateChargeRequestLog failure ");
                    }
                }
            }
            else {
                logger.warn(" insertChargeRequestLog failure ");
                logger.warn(" chargeRequest     : " + chargeRequest.toString());
                logger.warn(" chargeResponse    : " + chargeResponse.toString());
                logger.warn(" chargeRecordId    : " + chargeRecordId);
            }
        }
        else {
            chargeResponse.setStatus(-99);
            chargeResponse.setMsg("请求参数为空");
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end charge <<<<<<< ");
        }

        return chargeResponse;
    }

    public static void main(String[] args) {
        long remainTime = Math.round((new Double(1200)));
        if (remainTime > 999) {
            remainTime = 999;
        }

        System.out.println(remainTime);
    }

    @Override
    public void updateChargePrepayOrderLog(String chargeTradeOrderId, int payFlag, Date paySuccTime, String payFailReason) {
        chargeDao.updateChargePrepayOrderLog(chargeTradeOrderId, payFlag, paySuccTime, payFailReason);
    }

    @Override
    public ChargeRequest buildChargeRequestPaySuccessWithnoCharging(String chargeTradeOrderId) {
        return chargeDao.buildChargeRequestPaySuccessWithnoCharging(chargeTradeOrderId);
    }

    @Override
    public List<Map<String, Object>> getGnrtFailedChargeRequestList(Date startTime, Date endTime) {
        return chargeDao.getGnrtFailedChargeRequestList(startTime, endTime);
    }

    @Override
    public void updateChargeRequestLogByReturn(String chargeRecordId, String returnFlag, BigDecimal returnMoney, Date returnTime, String returnDesc, String returnTradeOrderId) {
        chargeDao.updateChargeRequestLogByReturn(chargeRecordId, returnFlag, returnMoney, returnTime, returnDesc, returnTradeOrderId);
    }

    @Override
    public void updateChargeRequestLogByReturnResult(String chargeTradeOrderId, String returnTradeOrderId, String returnFlag, Date returnSuccessTime) {
        chargeDao.updateChargeRequestLogByReturnResult(chargeTradeOrderId, returnTradeOrderId, returnFlag, returnSuccessTime);
    }

}
