package cn.yunrui.bizservices.ebikemgmt.service.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.ChargeDao;
import cn.yunrui.bizservices.ebikemgmt.dao.DebugDao;
import cn.yunrui.bizservices.ebikemgmt.dao.FitConnectDao;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeDeviceInfo;
import cn.yunrui.bizservices.ebikemgmt.entity.DebugRequest;
import cn.yunrui.bizservices.ebikemgmt.entity.DebugResponse;
import cn.yunrui.bizservices.ebikemgmt.service.DebugService;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.service.EBikeChargeService;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import java.util.Map;

/**
 * 装接调试服务
 */
public class DebugServiceImpl implements DebugService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource(name = "debugDao")
    private DebugDao debugDao;

    @Resource(name = "chargeDao")
    private ChargeDao chargeDao;

    @Resource(name = "fitConnectDao")
    private FitConnectDao fitConnectDao;

    @Resource(name = "ebikeChargeService")
    private EBikeChargeService ebikeChargeService;

    @Override
    public DebugResponse debugging(DebugRequest debugRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start debugging >>>>>> ");
            logger.debug(" DebugRequest : " + (debugRequest != null ? debugRequest.toString() : null));
        }

        DebugResponse debugResponse = new DebugResponse();
        debugResponse.setStatus(-1);
        debugResponse.setMsg("下发装接调试命令失败");
        if(debugRequest != null) {
            String chargeplugNo = debugRequest.getChargeplugNo();       // 充电插座编号（充电设备编号 + 2位插座序号（如：01、02、…））
            String chargedeviceNo;                                      // 充电设备编号
            String plugSn;                                              // 充电插座序号
            if(chargeplugNo != null && chargeplugNo.trim().length() >= 3) {
                chargedeviceNo = chargeplugNo.trim().substring(0, chargeplugNo.trim().length() - 2);
                plugSn = chargeplugNo.trim().substring(chargeplugNo.trim().length() - 2);
                ChargeDeviceInfo cdi = fitConnectDao.getChargeDeviceInfoFromAssetsRepo(debugRequest.getOrgNo(), chargedeviceNo);
                if(ObjectUtils.isNotNull(cdi) && StringUtils.isNotBlank(cdi.getDeviceId())) {
                    if(StringUtils.equals("start", debugRequest.getDebugType())) {
                        // 装接调试 - 开始充电
                        if(logger.isDebugEnabled()) {
                            logger.debug(" 充电设备编号[chargedeviceNo] : " + chargedeviceNo + " , 充电插座序号[plugSn] : " + plugSn);
                            logger.debug(" 　　>>>>>> 装接调试 - 开始充电... ");
                        }
                        // 获取充电插座标识
                        Map chargePlugValueMap = chargeDao.getChargePlugValueMap(debugRequest.getOrgNo(), debugRequest.getChargeplugNo());
                        if(MapUtils.isNotEmpty(chargePlugValueMap)) {
                            Long chargeplugId = (Long) chargePlugValueMap.get("chargeplugId");
                            // 判断充电插座是否正在充电
                            if(chargeDao.checkIsCharging(chargeplugId)) {
                                debugResponse.setStatus(-2);
                                debugResponse.setMsg("下发装接调试（开始充电）命令失败，充电插座正在充电");
                            }
                            else {
                                String msg2Device = debugRequest.getDebugType() + "#" + Integer.parseInt(plugSn) + "#10#10";   // 设备限制的最大充电电量，装接调试时为0.01kWh；设备限制的最大充电时间，装接调试时为10分钟
                                // 下发开始充电命令
                                boolean r = ebikeChargeService.publish2device(cdi.getDeviceId(), msg2Device, debugRequest.getDebugType());
                                if(r) {
                                    debugResponse.setStatus(0);
                                    debugResponse.setMsg("下发装接调试（开始充电）命令成功");
                                }
                                else {
                                    debugResponse.setStatus(-1);
                                    debugResponse.setMsg("下发装接调试（开始充电）命令失败");
                                }
                            }
                        }
                        else {
                            debugResponse.setStatus(-3);
                            debugResponse.setMsg("下发装接调试（开始充电）命令失败，无该充电插座");
                        }
                    }
                    else if(StringUtils.equals("stop", debugRequest.getDebugType())) {
                        // 结束充电
                        if(logger.isDebugEnabled()) {
                            logger.debug(" 充电设备编号[chargedeviceNo] : " + chargedeviceNo + " , 充电插座序号[plugSn] : " + plugSn);
                            logger.debug(" 　　<<<<<< 装接调试 - 结束充电... ");
                        }
                        String msg2Device = debugRequest.getDebugType() + "#" + Integer.parseInt(plugSn);
                        // 下发结束充电命令
                        boolean r = ebikeChargeService.publish2device(cdi.getDeviceId(), msg2Device, debugRequest.getDebugType());
                        if(r) {
                            debugResponse.setStatus(0);
                            debugResponse.setMsg("下发装接调试（结束充电）命令成功");
                        }
                        else {
                            debugResponse.setStatus(-1);
                            debugResponse.setMsg("下发装接调试（结束充电）命令失败");
                        }
                    }
                }
                else {
                    debugResponse.setStatus(-97);
                    debugResponse.setMsg("无该充电设备");
                }
            }
            else {
                debugResponse.setStatus(-98);
                debugResponse.setMsg("请求参数（充电插座编号）非法");
            }
        }
        else {
            debugResponse.setStatus(-99);
            debugResponse.setMsg("请求参数为空");
        }

        int insFdlResult = debugDao.insertFitconnDebuggingLog(debugRequest, debugResponse);
        if(insFdlResult > 0) {
            if(logger.isDebugEnabled()) {
                logger.debug(" insertFitconnDebuggingLog success ");
            }
        }
        else {
            logger.warn(" insertFitconnDebuggingLog failure ");
            logger.warn(" debugRequest     : " + (ObjectUtils.isNotNull(debugRequest) ? debugRequest.toString() : null));
            logger.warn(" debugResponse    : " + debugResponse.toString());
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end debugging <<<<<<< ");
        }
        return debugResponse;
    }
}
