package cn.yunrui.bizservices.ebikemgmt.service.impl;

import cn.yunrui.bizservices.ebikemgmt.constant.Constant;
import cn.yunrui.bizservices.ebikemgmt.dao.FitConnectDao;
import cn.yunrui.bizservices.ebikemgmt.entity.*;
import cn.yunrui.bizservices.ebikemgmt.service.FitConnectService;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.ChargeDeviceCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargePlugProps;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import com.ebike.openservices.devmgmt.entity.DevEbikeChargedeviceDo;
import com.ebike.openservices.devmgmt.entity.DevEbikeChargeplugDo;
import com.ebike.openservices.devmgmt.request.EbikeChargedeviceDismantleRequest;
import com.ebike.openservices.devmgmt.request.EbikeChargedeviceInstallRequest;
import com.ebike.openservices.devmgmt.response.EbikeChargedeviceDismantleResponse;
import com.ebike.openservices.devmgmt.response.EbikeChargedeviceInstallResponse;
import com.ebike.openservices.devmgmt.service.EbikeChargedeviceMgmtService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 装接服务
 *
 * @author Nick Zhang
 * @date 2019-04-11
 */
public class FitConnectServiceImpl implements FitConnectService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource(name = "ebikeChargedeviceMgmtService")
    private EbikeChargedeviceMgmtService ebikeChargedeviceMgmtService;

    @Resource(name = "fitConnectDao")
    private FitConnectDao fitConnectDao;

    @Resource(name = "chargeDeviceCache")
    private ChargeDeviceCache chargeDeviceCache;

    @Override
    public FitConnectResponse fitconnect(FitConnectRequest fitConnectRequest) {
        if(logger.isInfoEnabled()) {
            logger.info(" >>>>>> 开始装接设备 >>>>>> ");
            logger.info(" 装接请求参数[FitConnectRequest] : " + JsonConvertUtils.convertToString(fitConnectRequest));
        }
        FitConnectResponse res = new FitConnectResponse();
        res.setStatus(-1);
        res.setMsg("该充电设备装接失败");
        if(fitConnectRequest != null) {
            ChargeDeviceInfo cdi = fitConnectDao.getChargeDeviceInfoFromAssetsRepo(fitConnectRequest.getOrgNo(), fitConnectRequest.getChargedeviceNo());
            if(logger.isDebugEnabled()) {
                logger.debug(" ChargeDeviceInfo [cdi] : " + JsonConvertUtils.convertToString(cdi));
            }
            if(cdi == null) {
                res.setStatus(-2);
                res.setMsg("设备资产库中无该设备或不在管辖范围内");
            }
            else if(cdi.getChargedeviceId() != null && cdi.getChargedeviceId() > 0) {
                res.setStatus(-3);
                res.setMsg("该充电设备已装接");
                res.setCdInfo(cdi);
                if(StringUtils.equals("07", cdi.getStatus())) {
                    // 该设备已拆除，重新安装
                    EbikeChargedeviceInstallRequest installRequest = new EbikeChargedeviceInstallRequest();
                    installRequest.setChargedeviceId(cdi.getChargedeviceId());
                    installRequest.setChargedeviceNo(cdi.getChargedeviceNo());
                    installRequest.setChargedeviceName(cdi.getChargedeviceNo());
                    installRequest.setDeviceId(cdi.getDeviceId());
                    installRequest.setProtocolType(cdi.getProtocolType());
                    installRequest.setProtocolVersion(cdi.getProtocolVersion());
                    installRequest.setPlugCount(cdi.getPlugCount());
                    installRequest.setMfrCode(cdi.getChargedeviceFactory());
                    installRequest.setModelCode(cdi.getChargedeviceModelNo());
                    installRequest.setInstaller(fitConnectRequest.getOperator());
                    installRequest.setInstallRemark(Constant.REMARK_FITCONNECT);
                    installRequest.setInstallType("reinstall");
                    installRequest.setOrgNo(fitConnectRequest.getOrgNo());
                    installRequest.setChargestationId(fitConnectRequest.getChargestationId());
                    EbikeChargedeviceInstallResponse installResponse = ebikeChargedeviceMgmtService.installEbikeChargedevice(installRequest);
                    if(installResponse.isSuccess()) {
                        // 更新充电设备资产信息
                        fitConnectDao.updateDeviceAssertInfo(fitConnectRequest.getOrgNo(), fitConnectRequest.getChargedeviceNo(), "02", cdi.getChargedeviceId());
                        // 更新缓存
                        chargeDeviceCache.reload(cdi.getDeviceId());
                        res.setStatus(0);
                        res.setMsg("该充电设备重新装接成功");
                    }
                }
            }
            else {
                res.setStatus(-1);
                res.setMsg("该充电设备装接失败");
                res.setCdInfo(cdi);
                try {
                    EbikeChargedeviceInstallRequest installRequest = new EbikeChargedeviceInstallRequest();
                    installRequest.setChargedeviceNo(cdi.getChargedeviceNo());
                    installRequest.setChargedeviceName(cdi.getChargedeviceNo());
                    installRequest.setDeviceId(cdi.getDeviceId());
                    installRequest.setProtocolType(cdi.getProtocolType());
                    installRequest.setProtocolVersion(cdi.getProtocolVersion());
                    installRequest.setPlugCount(cdi.getPlugCount());
                    installRequest.setMfrCode(cdi.getChargedeviceFactory());
                    installRequest.setModelCode(cdi.getChargedeviceModelNo());
                    installRequest.setInstaller(fitConnectRequest.getOperator());
                    installRequest.setInstallRemark(Constant.REMARK_FITCONNECT);
                    installRequest.setInstallType("newinstall");
                    installRequest.setOrgNo(fitConnectRequest.getOrgNo());
                    installRequest.setChargestationId(fitConnectRequest.getChargestationId());
                    EbikeChargedeviceInstallResponse installResponse = ebikeChargedeviceMgmtService.installEbikeChargedevice(installRequest);
                    Long chargedeviceId = null;
                    Long[] chargeplugIds = null;
                    if(installResponse.isSuccess()) {
                        DevEbikeChargedeviceDo devEbikeChargedevice = installResponse.getDevEbikeChargedevice();
                        List<DevEbikeChargeplugDo> devEbikeChargeplugList = installResponse.getDevEbikeChargeplugList();
                        chargedeviceId = devEbikeChargedevice.getId();
                        chargeplugIds = new Long[devEbikeChargedevice.getPlugCount()];
                        int i = 0;
                        for(DevEbikeChargeplugDo devEbikeChargeplug : devEbikeChargeplugList) {
                            if(i < devEbikeChargedevice.getPlugCount()) {
                                chargeplugIds[i] = devEbikeChargeplug.getId();
                            }
                            i++;
                        }
                    }
                    if(chargedeviceId != null && chargedeviceId > 0) {
                        // 初始化充电设备状态
                        fitConnectDao.initChargeDeviceStatus(chargedeviceId);
                        cdi.setChargedeviceId(chargedeviceId);
                        // 初始化充电插座状态
                        if(chargeplugIds.length > 0) {
                            //
                            fitConnectDao.initChargePlugStatus(chargeplugIds);
                        }
                        // 更新充电设备资产信息
                        fitConnectDao.updateDeviceAssertInfo(fitConnectRequest.getOrgNo(), fitConnectRequest.getChargedeviceNo(), "02", chargedeviceId);
                        // 更新缓存
                        chargeDeviceCache.reload(cdi.getDeviceId());
                        res.setStatus(0);
                        res.setMsg("该充电设备装接成功");
                        res.setCdInfo(cdi);
                    }
                }
                catch(Exception e) {
                    logger.error(e.getMessage(), e.fillInStackTrace());
                }
            }
        }
        else {
            res.setStatus(-99);
            res.setMsg("请求参数为空");
        }

        if(logger.isInfoEnabled()) {
            logger.info(" 装接结果[FitConnectResponse] : " + JsonConvertUtils.convertToString(res));
            logger.info(" <<<<<< 结束装接设备 <<<<<< ");
        }
        return res;
    }

    @Override
    public FitConnectResponse dismantle(FitConnectRequest fitConnectRequest) {
        if(logger.isInfoEnabled()) {
            logger.info(" >>>>>> 开始拆除设备 >>>>>> ");
            logger.info(" 拆除请求参数[FitConnectRequest] : " + JsonConvertUtils.convertToString(fitConnectRequest));
        }

        FitConnectResponse res = new FitConnectResponse();
        res.setStatus(-1);
        res.setMsg("该充电设备拆除失败");
        if(fitConnectRequest != null) {
            ChargeDeviceInfo cdi = fitConnectDao.getChargeDeviceInfoFromAssetsRepo(fitConnectRequest.getOrgNo(), fitConnectRequest.getChargedeviceNo());
            if(logger.isDebugEnabled()) {
                logger.debug(" ChargeDeviceInfo [cdi] : " + JsonConvertUtils.convertToString(cdi));
            }
            if(cdi == null) {
                res.setStatus(-2);
                res.setMsg("设备资产库中无该设备或不在管辖范围内");
            }
            else if(cdi.getChargedeviceId() == null) {
                res.setStatus(-4);
                res.setMsg("该充电设备未装接");
            }
            else {
                res.setStatus(-1);
                res.setMsg("该充电设备拆除失败");
                boolean canDismantle = true;
                ChargeDeviceProps cdp = chargeDeviceCache.get(cdi.getDeviceId());
                if(logger.isDebugEnabled()) {
                    logger.debug(" ChargeDeviceProps [cdp] : " + JsonConvertUtils.convertToString(cdp));
                }
                if(ObjectUtils.isNotNull(cdp)) {
                    Map<Integer, ChargePlugProps> plugPropsMap = cdp.getPlugPropsMap();
                    if(logger.isDebugEnabled()) {
                        logger.debug(" plugPropsMap  : " + JsonConvertUtils.convertToString(plugPropsMap));
                    }
                    if(MapUtils.isNotEmpty(plugPropsMap)) {
                        for(Integer plugSn : plugPropsMap.keySet()) {
                            ChargePlugProps cpp = plugPropsMap.get(plugSn);
                            if(ObjectUtils.isNotNull(cpp) && StringUtils.equals("1", cpp.getOpStatus())) {
                                canDismantle = false;
                                break;
                            }
                        }
                    }

                    if(canDismantle) {
                        EbikeChargedeviceDismantleRequest dismantleRequest = new EbikeChargedeviceDismantleRequest();
                        dismantleRequest.setChargedeviceId(cdi.getChargedeviceId());
                        dismantleRequest.setDismantler(fitConnectRequest.getOperator());
                        dismantleRequest.setDismantleRemark(Constant.REMARK_DISMANTLE);
                        EbikeChargedeviceDismantleResponse dismantleResponse = ebikeChargedeviceMgmtService.dismantleEbikeChargedevice(dismantleRequest);
                        if(dismantleResponse.isSuccess()) {
                            // 更新充电设备资产信息
                            fitConnectDao.updateDeviceAssertInfo(fitConnectRequest.getOrgNo(), fitConnectRequest.getChargedeviceNo(), "07", null);
                            // 从缓存中删除
                            chargeDeviceCache.remove(cdi.getDeviceId());
                            res.setStatus(0);
                            res.setMsg("该充电设备拆除成功");
                        }
                    }
                    else {
                        res.setStatus(-5);
                        res.setMsg("该充电设备有插座正在充电中，无法拆除");
                    }
                }
                else {
                    res.setStatus(-2);
                    res.setMsg("设备资产库中无该设备或不在管辖范围内");
                }
            }
        }
        else {
            res.setStatus(-99);
            res.setMsg("请求参数为空");
        }

        if(logger.isInfoEnabled()) {
            logger.info(" 拆除结果[FitConnectResponse] : " + JsonConvertUtils.convertToString(res));
            logger.info(" <<<<<< 结束拆除设备 <<<<<< ");
        }
        return res;
    }

}
