package cn.yunrui.bizservices.ebikemgmt.service.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.TestDao;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeDeviceInfo;
import cn.yunrui.bizservices.ebikemgmt.entity.CustomTestRequest;
import cn.yunrui.bizservices.ebikemgmt.entity.TestRequest;
import cn.yunrui.bizservices.ebikemgmt.entity.TestResponse;
import cn.yunrui.bizservices.ebikemgmt.service.TestService;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.service.EBikeChargeService;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;

/**
 * 测试服务
 */
public class TestServiceImpl implements TestService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource(name = "testDao")
    private TestDao testDao;

    @Resource(name = "ebikeChargeService")
    private EBikeChargeService ebikeChargeService;

    @Override
    public TestResponse test(TestRequest testRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start test >>>>>> ");
            logger.debug(" TestRequest : " + (testRequest != null ? testRequest.toString() : null));
        }

        TestResponse testResponse = new TestResponse();
        testResponse.setStatus(-1);
        testResponse.setMsg("下发测试命令失败");
        if(testRequest != null) {
            String chargeplugNo = testRequest.getChargeplugNo();        // 充电插座编号（充电设备编号 + 2位插座序号（如：01、02、…））
            String chargedeviceNo;                                      // 充电设备编号
            String plugSn;                                              // 充电插座序号
            if(chargeplugNo != null && chargeplugNo.trim().length() >= 3) {
                chargedeviceNo = chargeplugNo.trim().substring(0, chargeplugNo.trim().length() - 2);
                plugSn = chargeplugNo.trim().substring(chargeplugNo.trim().length() - 2);
                ChargeDeviceInfo cdi = testDao.getChargeDeviceInfoFromAssetsRepo(chargedeviceNo);
                if(ObjectUtils.isNotNull(cdi)) {
                    if(StringUtils.equals("start", testRequest.getTestType())) {
                        // 测试 - 开始充电
                        if(logger.isDebugEnabled()) {
                            logger.debug(" 充电设备编号[chargedeviceNo] : " + chargedeviceNo + " , 充电插座序号[plugSn] : " + plugSn);
                            logger.debug(" 　　>>>>>> 测试 - 开始充电... ");
                        }
                        String msg2Device = testRequest.getTestType() + "#" + Integer.parseInt(plugSn) + "#10#10";   // 设备限制的最大充电电量，装接调试时为0.01kWh；设备限制的最大充电时间，装接调试时为10分钟
                        // 下发开始充电命令
                        boolean r = ebikeChargeService.publish2device(cdi.getDeviceId(), msg2Device, testRequest.getTestType());
                        if(r) {
                            testResponse.setStatus(0);
                            testResponse.setMsg("下发测试（开始充电）命令成功");
                        }
                        else {
                            testResponse.setStatus(-1);
                            testResponse.setMsg("下发测试（开始充电）命令失败");
                        }
                    }
                    else if(StringUtils.equals("stop", testRequest.getTestType())) {
                        // 结束充电
                        if(logger.isDebugEnabled()) {
                            logger.debug(" 充电设备编号[chargedeviceNo] : " + chargedeviceNo + " , 充电插座序号[plugSn] : " + plugSn);
                            logger.debug(" 　　<<<<<< 测试 - 结束充电... ");
                        }
                        String msg2Device = testRequest.getTestType() + "#" + Integer.parseInt(plugSn);
                        // 下发结束充电命令
                        boolean r = ebikeChargeService.publish2device(cdi.getDeviceId(), msg2Device, testRequest.getTestType());
                        if(r) {
                            testResponse.setStatus(0);
                            testResponse.setMsg("下发测试（结束充电）命令成功");
                        }
                        else {
                            testResponse.setStatus(-1);
                            testResponse.setMsg("下发测试（结束充电）命令失败");
                        }
                    }
                }
                else {
                    testResponse.setStatus(-97);
                    testResponse.setMsg("无该充电设备");
                }
            }
            else {
                testResponse.setStatus(-98);
                testResponse.setMsg("请求参数（充电插座编号）非法");
            }
        }
        else {
            testResponse.setStatus(-99);
            testResponse.setMsg("请求参数为空");
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end test <<<<<<< ");
        }
        return testResponse;
    }

    @Override
    public TestResponse custom(CustomTestRequest testRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start custom test >>>>>> ");
            logger.debug(" CustomTestRequest : " + (testRequest != null ? testRequest.toString() : null));
        }

        TestResponse testResponse = new TestResponse();
        testResponse.setStatus(-1);
        testResponse.setMsg("下发自定义测试命令失败");
        if(testRequest != null) {
            String chargedeviceNo = testRequest.getChargedeviceNo();    // 充电设备编号
            //String plugSn = null;                                       // 充电插座序号
            if(StringUtils.isNotBlank(chargedeviceNo)) {
                ChargeDeviceInfo cdi = testDao.getChargeDeviceInfoFromAssetsRepo(chargedeviceNo);
                if(ObjectUtils.isNotNull(cdi)) {
                    if(logger.isDebugEnabled()) {
                        logger.debug(" 充电设备编号[chargedeviceNo] : " + chargedeviceNo);
                        logger.debug(" 　　<<<<<< 自定义测试... ");
                    }
                    // 下发结束充电命令
                    boolean r = ebikeChargeService.publish2device(cdi.getDeviceId(), testRequest.getCustomContent(), testRequest.getTestType());
                    if(r) {
                        testResponse.setStatus(0);
                        testResponse.setMsg("下发自定义测试命令成功");
                    }
                    else {
                        testResponse.setStatus(-1);
                        testResponse.setMsg("下发自定义测试命令失败");
                    }
                }
                else {
                    testResponse.setStatus(-97);
                    testResponse.setMsg("无该充电设备");
                }
            }
            else {
                testResponse.setStatus(-98);
                testResponse.setMsg("请求参数（充电设备编号）非法");
            }
        }
        else {
            testResponse.setStatus(-99);
            testResponse.setMsg("请求参数为空");
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end custom test <<<<<<< ");
        }
        return testResponse;
    }
}
