package cn.yunrui.bizservices.ebikemgmt.syncevent.subscriber.impl;

import cn.cc.cisp.message.Event;
import cn.cc.cisp.message.SyncEventType;
import cn.cc.cisp.message.channel.EventChannel;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeRequest;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeResponse;
import cn.yunrui.bizservices.ebikemgmt.service.ChargeService;
import cn.yunrui.bizservices.ebikemgmt.syncevent.subscriber.ChargeOrderPayResultSubscriber;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import com.ebikepay.openservices.entity.PayResultEnum;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import java.util.Date;
import java.util.Map;

/**
 *
 */
public class ChargeOrderPayResultSubscriberImpl implements ChargeOrderPayResultSubscriber {

    private final static String EVENT_TYPE = "TRADE_ORDER_PAY_RESULT_NOTIFY";
    private final static String[] BUSINESS_MODULE_EBIKE_CHARGES = new String[] { "bike_yezf", "i380v-bike", "i380v-bike-xcx", "ebike-charge" };        // 电动自行车充电

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource(name = "eventChannel")
    private EventChannel eventChannel;

    @Resource(name = "chargeService")
    private ChargeService chargeService;

    /**
     * 初始化
     */
    @PostConstruct
    public void init() throws Exception {
        eventChannel.subscribe(this, SyncEventType.valueOfKey(EVENT_TYPE));
    }

    /**
     * 销毁
     */
    @PreDestroy
    public void destroy() {
        eventChannel.unsubscribe(this, SyncEventType.valueOfKey(EVENT_TYPE));
    }

    @Override
    public void handleEvent(Event event) throws Exception {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleEvent >>>>>> ");
            logger.debug(" event : " + JsonConvertUtils.convertToString(event));
        }
        if(SyncEventType.valueOfKey(EVENT_TYPE).equals(event.getEventType())) {
            String messageStr = (String) event.getClientObject();
            Map msg = JsonConvertUtils.convertFromString(Map.class, messageStr);
            if(logger.isDebugEnabled()) {
                logger.debug(" msg : " + JsonConvertUtils.convertToString(msg));
            }
            if(msg != null) {
                String businessModule = (String) msg.get("businessModule");
                String businessId = (String) msg.get("businessId");
                String orderId = (String) msg.get("orderId");
                Integer payResult = (Integer) msg.get("payResult");
                if(logger.isDebugEnabled()) {
                    logger.debug(" businessModule   : " + businessModule);
                    logger.debug(" businessId       : " + businessId);
                    logger.debug(" orderId          : " + orderId);
                    logger.debug(" payResult        : " + payResult);
                }
                if(ArrayUtils.contains(BUSINESS_MODULE_EBIKE_CHARGES, businessModule)) {
                    if(PayResultEnum.PAY_SUCCESS.getResult().equals(payResult)) {
                        // 成功
                        chargeService.updateChargePrepayOrderLog(orderId, 0, new Date(), null);
                        if(StringUtils.isNotBlank(orderId)) {
                            // 检查是否支付成功但未充电
                            ChargeRequest chargeRequest = chargeService.buildChargeRequestPaySuccessWithnoCharging(orderId);
                            if(chargeRequest != null) {
                                ChargeResponse response = chargeService.charge(chargeRequest);
                                if(logger.isDebugEnabled()) {
                                    logger.debug(" ChargeRequest    : " + JsonConvertUtils.convertToString(chargeRequest));
                                    logger.debug(" ChargeResponse   : " + JsonConvertUtils.convertToString(response));
                                }
                            }
                        }
                    }
                    else {
                        // 失败
                        chargeService.updateChargePrepayOrderLog(orderId, -1, null, (payResult != null ? payResult.toString() : null));
                    }
                }
            }
        }
    }

}
