package cn.yunrui.bizservices.ebikemgmt.syncevent.subscriber.impl;

import cn.cc.cisp.message.Event;
import cn.cc.cisp.message.SyncEventType;
import cn.cc.cisp.message.channel.EventChannel;
import cn.yunrui.bizservices.ebikemgmt.dao.ChargeDao;
import cn.yunrui.bizservices.ebikemgmt.syncevent.subscriber.ChargeOrderRefundResultSubscriber;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeRecordDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeRecord;
import com.ebikepay.openservices.entity.RefundResultEnum;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import java.util.Date;
import java.util.Map;

/**
 *
 */
public class ChargeOrderRefundResultSubscriberImpl implements ChargeOrderRefundResultSubscriber {

    private final static String EVENT_TYPE = "TRADE_ORDER_REFUND_RESULT_NOTIFY";
    private final static String[] BUSINESS_MODULE_EBIKE_CHARGES = new String[] { "i380v-bike", "ebike-charge" };        // 电动自行车充电

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource(name = "eventChannel")
    private EventChannel eventChannel;

    @Resource(name = "chargeRecordDao")
    private ChargeRecordDao chargeRecordDao;

    @Resource(name = "chargeDao")
    private ChargeDao chargeDao;


    /**
     * 初始化
     */
    @PostConstruct
    public void init() throws Exception {
        eventChannel.subscribe(this, SyncEventType.valueOfKey(EVENT_TYPE));
    }

    /**
     * 销毁
     */
    @PreDestroy
    public void destroy() {
        eventChannel.unsubscribe(this, SyncEventType.valueOfKey(EVENT_TYPE));
    }

    @Override
    public void handleEvent(Event event) throws Exception {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start handleEvent >>>>>> ");
            logger.debug(" event : " + JsonConvertUtils.convertToString(event));
        }
        if(SyncEventType.valueOfKey(EVENT_TYPE).equals(event.getEventType())) {
            String messageStr = (String) event.getClientObject();
            Map msg = JsonConvertUtils.convertFromString(Map.class, messageStr);
            if(logger.isDebugEnabled()) {
                logger.debug(" msg : " + JsonConvertUtils.convertToString(msg));
            }
            if(msg != null) {
                String orderId = (String) msg.get("orderId");
                String orderType = (String) msg.get("orderType");
                String businessModule = (String) msg.get("businessModule");
                String businessId = (String) msg.get("businessId");
                String refundNo = (String) msg.get("refundNo");
                String refundType = (String) msg.get("refundType");
                String refundTime = (String) msg.get("refundTime");
                Integer refundResult = (Integer) msg.get("refundResult");
                String refundChannelNo = (String) msg.get("refundChannelNo");
                if(logger.isDebugEnabled()) {
                    logger.debug(" orderId          : " + orderId);
                    logger.debug(" orderType        : " + orderType);
                    logger.debug(" businessModule   : " + businessModule);
                    logger.debug(" businessId       : " + businessId);
                    logger.debug(" refundNo         : " + refundNo);
                    logger.debug(" refundType       : " + refundType);
                    logger.debug(" refundTime       : " + refundTime);
                    logger.debug(" refundResult     : " + refundResult);
                    logger.debug(" refundChannelNo  : " + refundChannelNo);
                }
                if(ArrayUtils.contains(BUSINESS_MODULE_EBIKE_CHARGES, businessModule)) {
                    // 处理充电订单退费
                    ChargeRecord chargeRecord = chargeRecordDao.getHistroyChargeRecordByReturnTradeOrderId(orderId, refundNo);
                    if(chargeRecord != null) {
                        if(StringUtils.equals("W", chargeRecord.getReturnFlag())) {
                            // 对充电记录中退费标记为： W 已处理，等待通知，进行处理
                            if(RefundResultEnum.REFUND_SUCCESS.getResult().equals(refundResult)) {
                                // 退费成功
                                chargeRecord.setReturnFlag("Y");
                                chargeRecord.setReturnSuccessTime(new Date());
                                chargeRecordDao.finshReturnChargeRecord(chargeRecord);
                            }
                            else if(RefundResultEnum.REFUND_FAILURE.getResult().equals(refundResult)) {
                                // 退费失败
                                chargeRecord.setReturnFlag("F");
                                chargeRecordDao.finshReturnChargeRecord(chargeRecord);
                            }
                        }
                    }
                    else {
                        // 处理充电订单客服工单退款
                        chargeRecord = chargeRecordDao.getHistroyChargeRecordByCsrefundTradeOrderId(orderId, refundNo);
                        if(chargeRecord != null) {
                            if(StringUtils.equals("T", chargeRecord.getCsrefundResult())) {
                                // 对退款申请处理结果为： T 退款处理，等待通知，进行处理
                                if(RefundResultEnum.REFUND_SUCCESS.getResult().equals(refundResult)) {
                                    // 退费成功
                                    chargeRecord.setCsrefundResult("S");
                                    chargeRecordDao.finshReturnChargeRecord(chargeRecord);
                                }
                                else if(RefundResultEnum.REFUND_FAILURE.getResult().equals(refundResult)) {
                                    // 退费失败
                                    chargeRecord.setCsrefundResult("F");
                                    chargeRecordDao.finshReturnChargeRecord(chargeRecord);
                                }
                            }
                        }
                        else {
                            // 处理充电请求失败订单
                            if(RefundResultEnum.REFUND_SUCCESS.getResult().equals(refundResult)) {
                                // 退费成功
                                int res = chargeDao.updateChargeRequestLogByReturnResult(orderId, refundNo, "Y", new Date());
                                if(res > 0 && logger.isInfoEnabled()) {
                                    logger.info(" orderId   : " + orderId);
                                    logger.info(" refundNo  : " + refundNo);
                                    logger.info(" 处理充电请求失败订单，退款成功！");
                                }
                            }
                            else if(RefundResultEnum.REFUND_FAILURE.getResult().equals(refundResult)) {
                                // 退费失败
                                int res = chargeDao.updateChargeRequestLogByReturnResult(orderId, refundNo, "F", null);
                                if(res > 0 && logger.isInfoEnabled()) {
                                    logger.info(" orderId   : " + orderId);
                                    logger.info(" refundNo  : " + refundNo);
                                    logger.info(" 处理充电请求失败订单，退费失败！");
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
