package cn.yunrui.bizservices.ebikemgmt.utils;

import cn.yunrui.bizservices.ebikemgmt.entity.BillingSchemeInfo;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.constant.ChargeOpenFlag;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;

/**
 * 计费常用工具类
 */
public class BillingUtil {

    private final static Double MAX_CHARGE_EC = 9000.0D;                // 计时间模式，最大充电电量，9000W
    private final static Double MAX_CHARGE_TIME = 900.0D;               // 计电量模式，最大充电时间，900分钟
    private final static Double MAX_CHARGE_TIME_2024 = 1000.0D;               // 计电量模式，需要下发最大充电时间超过999，液晶屏才能显示电能数值
    private final static Double MAX_CHARGE_EC_FOR_FREE = 2000.0D;       // 计电量模式，免费最大充电电量，2000W
    private final static Double MAX_CHARGE_TIME_FOR_FREE = 600.0D;      // 计时间模式，免费最大充电时长，600分钟
    //private final static Double MAX_CHARGE_TIME_FOR_FREE = 480.0D;      // 计时间模式，免费最大充电时长，国网最新标准480分钟，2024/5/10修改
    private final static Logger logger = LoggerFactory.getLogger(BillingUtil.class);

    public static void main(String[] args) {
        Double chargeMoney = 1D;
        Double price = 0.558;
        Double fee1 = 0.4;
        Double fee2 = 0.1;
        Double firstChargeAmount = chargeMoney/(price + fee1 + fee2);        // 单位为分钟，需转换
        System.out.println("================="  + new BigDecimal(firstChargeAmount.doubleValue()).setScale(2, RoundingMode.HALF_UP));
    }

    /**
     * 获取充电记录结果集
     * @param billingSchemeInfo
     *              计费方案信息
     * @param chargeMoney
     *              充电金额
     * @return 充电记录结果集
     */
    public static Map<String, Object> getChargeRecordMap(BillingSchemeInfo billingSchemeInfo, Double chargeMoney) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getChargeRecordMap >>>>>>> ");
            logger.debug(" billingSchemeInfo    : " + (billingSchemeInfo != null ? billingSchemeInfo.toString() : null));
            logger.debug(" chargeMoney          : " + chargeMoney);
        }
        if(billingSchemeInfo == null) {
            return null;
        }
        chargeMoney = (chargeMoney != null ? chargeMoney : 0.0D);
        Double coinMoney = 0.0D;
        Map<String, Object> chargeRecordMap = new HashMap<>();
        chargeRecordMap.put("chargeMoney", chargeMoney);                            // 充电金额
        chargeRecordMap.put("coinMoney", coinMoney);                                // 投币金额
        chargeRecordMap.put("schemeId", billingSchemeInfo.getSchemeId());
        chargeRecordMap.put("schemeType", billingSchemeInfo.getSchemeType());
        Double unitPrice = billingSchemeInfo.getUnitPrice1();
        chargeRecordMap.put("unitPrice1", unitPrice);
        chargeRecordMap.put("unitPrice2", billingSchemeInfo.getUnitPrice2());
        chargeRecordMap.put("unitPrice3", billingSchemeInfo.getUnitPrice3());
        chargeRecordMap.put("unitPrice4", billingSchemeInfo.getUnitPrice4());
        chargeRecordMap.put("unitPrice5", billingSchemeInfo.getUnitPrice5());
        chargeRecordMap.put("stepCount", billingSchemeInfo.getStepCount());
        chargeRecordMap.put("stepPower1", billingSchemeInfo.getStepPower1());
        chargeRecordMap.put("stepPower2", billingSchemeInfo.getStepPower2());
        chargeRecordMap.put("stepPower3", billingSchemeInfo.getStepPower3());
        chargeRecordMap.put("stepPower4", billingSchemeInfo.getStepPower4());
        chargeRecordMap.put("minCharge", billingSchemeInfo.getMinCharge());
        chargeRecordMap.put("isReturn", billingSchemeInfo.getIsReturn());
        chargeRecordMap.put("closingPeriod", billingSchemeInfo.getClosingPeriod());
        chargeRecordMap.put("schemeDetails", billingSchemeInfo.getSchemeDetails());

        chargeRecordMap.put("chargeOpenFlag", ChargeOpenFlag.FLAG_WAITING);         // 充电开启标志：为1表示充电等待中（等待主站回应）
        Integer firstUnitPriceFlag = 1;
        Double firstChargeAmount = 0.0D;
        Double usageAmount = 0.0D;
        Double surplusAmount = 0.0D;
        Double usageElecCons = 0.0D;
        if(StringUtils.equals("01", billingSchemeInfo.getSchemeType())) {
            // 计时间
            firstUnitPriceFlag = 1;
            if(billingSchemeInfo.getUnitPrice1() != null && billingSchemeInfo.getUnitPrice1().compareTo(0.0D) > 0) {
                firstChargeAmount = chargeMoney * billingSchemeInfo.getUnitPrice1() * 60;        // 单位为分钟，需转换
                BigDecimal bd = new BigDecimal(firstChargeAmount);
                bd = bd.setScale(4, BigDecimal.ROUND_HALF_UP);
                firstChargeAmount = bd.doubleValue();
            }
            else if(billingSchemeInfo.getUnitPrice1() != null && billingSchemeInfo.getUnitPrice1().compareTo(0.0D) == 0) {
                // 免费充电
                firstChargeAmount = (billingSchemeInfo.getMaxChargeTime() != null && billingSchemeInfo.getMaxChargeTime() > 0 ? billingSchemeInfo.getMaxChargeTime() * 1.0D : MAX_CHARGE_TIME_FOR_FREE);
            }
            surplusAmount = firstChargeAmount - usageAmount;
        }
        else if(StringUtils.equals("02", billingSchemeInfo.getSchemeType())) {
            // 计电量
            firstUnitPriceFlag = 1;
            // 2024-11-27新增计费方案详情，应对计电量时的服务费用--普通服务费以及损耗费
            Double chargeServiceFee = billingSchemeInfo.getChargeServiceFee();
            Double elecLossFee = billingSchemeInfo.getElecLossFee();
            if(billingSchemeInfo.getUnitPrice1() != null && billingSchemeInfo.getUnitPrice1().compareTo(0.0D) > 0) {
                // 计算总体电量
                firstChargeAmount = chargeMoney/(billingSchemeInfo.getUnitPrice1() + chargeServiceFee + elecLossFee);             // 单位为kWh
                //firstChargeAmount = chargeMoney * billingSchemeInfo.getUnitPrice1();             // 单位为kWh
                BigDecimal bd = new BigDecimal(firstChargeAmount);
                bd = bd.setScale(2, BigDecimal.ROUND_HALF_UP);// 保留小数点两位
                firstChargeAmount = bd.doubleValue();
            }
            else if(billingSchemeInfo.getUnitPrice1() != null && billingSchemeInfo.getUnitPrice1().compareTo(0.0D) == 0) {
                // 免费充电
                firstChargeAmount = MAX_CHARGE_EC_FOR_FREE / 1000.0;
            }
            surplusAmount = firstChargeAmount - usageAmount;
        }
        else if(StringUtils.equals("03", billingSchemeInfo.getSchemeType())) {
            // 计次（按时间）
            firstUnitPriceFlag = 1;
            firstChargeAmount = (billingSchemeInfo.getMaxChargeTime() != null && billingSchemeInfo.getMaxChargeTime() > 0 ? billingSchemeInfo.getMaxChargeTime() * 1.0D : MAX_CHARGE_TIME_FOR_FREE);
            surplusAmount = firstChargeAmount - usageAmount;
            if(logger.isDebugEnabled()) {
                logger.debug(" firstUnitPriceFlag   : " + firstUnitPriceFlag);
                logger.debug(" firstChargeAmount    : " + firstChargeAmount);
                logger.debug(" surplusAmount        : " + surplusAmount);
            }
        }else if(StringUtils.equals("05", billingSchemeInfo.getSchemeType())) {
            Double elecCost = billingSchemeInfo.getElecCost();
            chargeRecordMap.put("unitPrice1", elecCost);
            chargeRecordMap.put("unitPrice2", billingSchemeInfo.getUnitPrice1());
            chargeRecordMap.put("unitPrice3", billingSchemeInfo.getUnitPrice2());
            chargeRecordMap.put("unitPrice4", billingSchemeInfo.getUnitPrice3());
            chargeRecordMap.put("unitPrice5", billingSchemeInfo.getUnitPrice4());
            //计电量+计时
            firstUnitPriceFlag = 1;
            //2025-7-28新增计费方案详情，计电量+计时
            //电度单价
            JSONObject billingSchemeDetails = JSONObject.fromObject(billingSchemeInfo.getSchemeDetails());
            if (ObjectUtils.isNotEmpty(billingSchemeInfo.getStepPower1())&&ObjectUtils.isNotEmpty(billingSchemeInfo.getUnitPrice1())){
                //计时转为记电量
                double elecCostAdd = billingSchemeInfo.getUnitPrice1() / (billingSchemeInfo.getStepPower1()*0.001);
                elecCostAdd = new BigDecimal(elecCostAdd).setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
                elecCost = elecCost+elecCostAdd;
                billingSchemeDetails.put("charge_service_fee", elecCostAdd);
            }
            firstChargeAmount=chargeMoney/elecCost;
            BigDecimal bd = new BigDecimal(firstChargeAmount);
            bd = bd.setScale(2, BigDecimal.ROUND_HALF_UP);// 保留小数点两位
            firstChargeAmount = bd.doubleValue();
            surplusAmount = firstChargeAmount - usageAmount;
            chargeRecordMap.put("schemeDetails", String.valueOf(billingSchemeDetails));

        }
        chargeRecordMap.put("firstUnitPriceFlag", firstUnitPriceFlag);
        chargeRecordMap.put("firstChargeAmount", firstChargeAmount);
        chargeRecordMap.put("currUnitPriceFlag", firstUnitPriceFlag);
        chargeRecordMap.put("chargeAmount", firstChargeAmount);                     // 充电量
        chargeRecordMap.put("usageAmount", usageAmount);                            // 使用量
        chargeRecordMap.put("surplusAmount", surplusAmount);                        // 剩余量
        chargeRecordMap.put("usageElecCons", usageElecCons);                        // 使用电量
        if(StringUtils.equals("02", billingSchemeInfo.getSchemeType())||StringUtils.equals("05", billingSchemeInfo.getSchemeType())) {
            // 计电量
            chargeRecordMap.put("remainElecCons", firstChargeAmount);               // 剩余充电电量：单位为kWh
            chargeRecordMap.put("remainTime", MAX_CHARGE_TIME_2024);                     // 剩余充电时间：单位为分钟
        }
        else {
            // 计时间
            chargeRecordMap.put("remainElecCons", (MAX_CHARGE_EC / 1000.0D));       // 剩余充电电量：单位为kWh，需转换
            if(firstChargeAmount > 999){
                firstChargeAmount = 999D;
            }
            chargeRecordMap.put("remainTime", firstChargeAmount);                   // 剩余充电时间：单位为分钟
        }
        if(logger.isDebugEnabled()) {
            logger.debug(" chargeRecordMap      : " + JsonConvertUtils.convertToString(chargeRecordMap));
        }
        return chargeRecordMap;
    }

}
