/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.bizservices.ebikemgmt.dao.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.BillingSchemeDao;
import cn.yunrui.bizservices.ebikemgmt.entity.BillingSchemeInfo;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class BillingSchemeDaoImpl
implements BillingSchemeDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RowMapper<BillingSchemeInfo> bsiRowMapper = (rs, rowNum) -> {
        BillingSchemeInfo bsi = new BillingSchemeInfo();
        bsi.setSchemeId(rs.getString(1));
        bsi.setBuro(rs.getString(2));
        bsi.setSubburo(rs.getString(3));
        bsi.setSchemeNo(rs.getString(4));
        bsi.setSchemeName(rs.getString(5));
        bsi.setSchemeType(rs.getString(6));
        bsi.setUnitPrice1(Double.valueOf(rs.getDouble(7)));
        bsi.setUnitPrice2(Double.valueOf(rs.getDouble(8)));
        bsi.setUnitPrice3(Double.valueOf(rs.getDouble(9)));
        bsi.setUnitPrice4(Double.valueOf(rs.getDouble(10)));
        bsi.setUnitPrice5(Double.valueOf(rs.getDouble(11)));
        bsi.setStepCount(Integer.valueOf(rs.getInt(12)));
        bsi.setStepPower1(Integer.valueOf(rs.getInt(13)));
        bsi.setStepPower2(Integer.valueOf(rs.getInt(14)));
        bsi.setStepPower3(Integer.valueOf(rs.getInt(15)));
        bsi.setStepPower4(Integer.valueOf(rs.getInt(16)));
        bsi.setMinCharge(Double.valueOf(rs.getDouble(17)));
        bsi.setIsReturn(rs.getString(18));
        bsi.setClosingPeriod(Integer.valueOf(rs.getInt(19)));
        bsi.setMaxChargeTime(Integer.valueOf(rs.getInt(20)));
        bsi.setSchemeDetails(rs.getString(21));
        bsi.setChargeServiceFee(Double.valueOf(rs.getDouble(22)));
        bsi.setElecLossFee(Double.valueOf(rs.getDouble(23)));
        bsi.setElecCost(Double.valueOf(rs.getDouble(24)));
        return bsi;
    };
    private final JdbcTemplate ebikeJdbcTemplate;

    private StringBuilder builderBillingSchemePreSQL() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT ebs.schemeId, ebs.buro, ebs.subburo, ebs.schemeNo, ebs.schemeName, ebs.schemeType, ebs.unitPrice1, ebs.unitPrice2, ebs.unitPrice3, ebs.unitPrice4, ebs.unitPrice5, ebs.stepCount, ebs.stepPower1, ebs.stepPower2, ebs.stepPower3, ebs.stepPower4, ebs.minCharge, ebs.isReturn, ebs.closingPeriod, ebs.maxChargeTime,ebs.schemeDetails,ebs.schemeDetails->>'$.charge_service_fee' as chargeServiceFee,ebs.schemeDetails->>'$.elec_loss_fee' as elecLossFee,ebs.schemeDetails->>'$.elec_cost' as elecCost");
        sqlBuilder.append("  FROM ebike.ebike_billingscheme ebs ");
        return sqlBuilder;
    }

    public BillingSchemeDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    public BillingSchemeInfo getBillingSchemeInfoById(String schemeId) {
        BillingSchemeInfo bsi;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getBillingSchemeInfoById >>>>>>> ");
            this.logger.debug(" schemeId : " + schemeId);
        }
        StringBuilder sqlBuilder = this.builderBillingSchemePreSQL();
        ArrayList<String> params = new ArrayList<String>();
        sqlBuilder.append(" WHERE ebs.schemeId = ? ");
        params.add(schemeId);
        try {
            bsi = (BillingSchemeInfo)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), this.bsiRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            bsi = null;
        }
        return bsi;
    }

    public BillingSchemeInfo getBillingSchemeInfoByNo(String orgNo, String schemeNo) {
        BillingSchemeInfo bsi;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getBillingSchemeInfoByNo >>>>>>> ");
            this.logger.debug(" orgNo    : " + orgNo);
            this.logger.debug(" schemeNo : " + schemeNo);
        }
        StringBuilder sqlBuilder = this.builderBillingSchemePreSQL();
        ArrayList<String> params = new ArrayList<String>();
        sqlBuilder.append(" WHERE ebs.buro = ? AND ebs.subburo = ? AND ebs.schemeNo = ? ");
        params.add(orgNo);
        params.add(orgNo);
        params.add(schemeNo);
        sqlBuilder.append(" LIMIT 1 ");
        try {
            bsi = (BillingSchemeInfo)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), this.bsiRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            bsi = null;
        }
        return bsi;
    }

    public BillingSchemeInfo getBillingSchemeInfoByChargedeviceId(Long chargedeviceId) {
        BillingSchemeInfo bsi;
        StringBuilder sqlBuilder = this.builderBillingSchemePreSQL();
        ArrayList<Long> params = new ArrayList<Long>();
        sqlBuilder.append(" INNER JOIN ebike.ebike_cs_bs_rela cbr ON cbr.schemeId = ebs.schemeId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.chargestationId = cbr.chargestationId ");
        sqlBuilder.append(" WHERE ecd.`id` = ? ");
        params.add(chargedeviceId);
        sqlBuilder.append(" LIMIT 1 ");
        try {
            bsi = (BillingSchemeInfo)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), this.bsiRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            bsi = null;
        }
        return bsi;
    }

    public BillingSchemeInfo getBillingSchemeInfoByChargedeviceNo(String orgNo, String chargedeviceNo) {
        BillingSchemeInfo bsi;
        StringBuilder sqlBuilder = this.builderBillingSchemePreSQL();
        ArrayList<String> params = new ArrayList<String>();
        sqlBuilder.append(" INNER JOIN ebike.ebike_cs_bs_rela cbr ON cbr.schemeId = ebs.schemeId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.chargestationId = cbr.chargestationId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_powersystemresource pss ON pss.`id` = ecd.`id` AND pss.className = 'EBikeChargeDevice' ");
        sqlBuilder.append(" WHERE pss.buro = ? AND pss.subburo = ? AND ecd.chargedeviceNo = ? ");
        params.add(orgNo);
        params.add(orgNo);
        params.add(chargedeviceNo);
        sqlBuilder.append(" LIMIT 1 ");
        try {
            bsi = (BillingSchemeInfo)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), this.bsiRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            bsi = null;
        }
        return bsi;
    }

    public BillingSchemeInfo getBillingSchemeInfoByChargedeviceNo(String orgNo, String chargedeviceNo, String chargeUserNo, String chargeUserType) {
        BillingSchemeInfo bsi = null;
        Integer cnt = 0;
        StringBuilder sqlBuilder1 = new StringBuilder();
        ArrayList<String> params1 = new ArrayList<String>();
        sqlBuilder1.append("SELECT COUNT(*) AS CNT ");
        sqlBuilder1.append("  FROM ebmkt.ebmkt_cmpn_package_partrecord cmpnuser, ebmkt.ebmkt_cmpn_rel rel, cisp_dev.dev_ebikechargestation station, cisp_dev.dev_ebikechargedevice dev, ebike.ebike_chargeuser cu ");
        sqlBuilder1.append(" WHERE station.id = dev.chargestationId AND dev.chargedeviceNo = ? ");
        sqlBuilder1.append("   AND cmpnuser.package_status = '1' AND station.id = rel.rel_id AND rel.cmpn_id = cmpnuser.cmpn_id ");
        sqlBuilder1.append("   AND cmpnuser.package_end >= DATE_FORMAT(now(), '%Y-%m-%d') ");
        sqlBuilder1.append("   AND cmpnuser.charge_user_id = cu.chargeUserId ");
        sqlBuilder1.append("   AND cu.chargeUserNo = ? AND cu.chargeUserType = ? ");
        params1.add(chargedeviceNo);
        params1.add(chargeUserNo);
        params1.add(chargeUserType);
        sqlBuilder1.append(" LIMIT 1 ");
        if (StringUtils.isNotBlank((CharSequence)chargeUserNo) && StringUtils.isNotBlank((CharSequence)chargeUserType)) {
            try {
                cnt = (Integer)this.ebikeJdbcTemplate.queryForObject(sqlBuilder1.toString(), params1.toArray(), Integer.class);
            }
            catch (EmptyResultDataAccessException erdae) {
                cnt = 0;
            }
        }
        if (cnt > 0) {
            bsi = this.getBillingSchemeInfoById("FREE");
        }
        if (bsi == null) {
            StringBuilder sqlBuilder2 = this.builderBillingSchemePreSQL();
            ArrayList<String> params2 = new ArrayList<String>();
            sqlBuilder2.append(" INNER JOIN ebike.ebike_csbs_info cbi ON cbi.schemeId = ebs.schemeId AND cbi.csbsType = '01' AND cbi.csbsStatus IN ('00', '02', '03') ");
            sqlBuilder2.append(" INNER JOIN ebike.ebike_csbs_info_userlist cbiul ON cbiul.csbsUsersListId = cbi.csbsUsersListId ");
            sqlBuilder2.append(" INNER JOIN ebike.ebike_chargeuser cu ON cu.chargeUserMobile = cbiul.csbsUserMobile ");
            sqlBuilder2.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.chargestationId = cbi.chargestationId  ");
            sqlBuilder2.append(" INNER JOIN cisp_dev.dev_powersystemresource pss ON pss.`id` = ecd.`id` AND pss.className = 'EBikeChargeDevice' ");
            sqlBuilder2.append(" WHERE pss.buro = ? AND pss.subburo = ? AND ecd.chargedeviceNo = ?  AND cu.chargeUserNo = ? AND cu.chargeUserType = ? ");
            params2.add(orgNo);
            params2.add(orgNo);
            params2.add(chargedeviceNo);
            params2.add(chargeUserNo);
            params2.add(chargeUserType);
            sqlBuilder2.append(" LIMIT 1 ");
            if (StringUtils.isNotBlank((CharSequence)chargeUserNo) && StringUtils.isNotBlank((CharSequence)chargeUserType)) {
                try {
                    bsi = (BillingSchemeInfo)this.ebikeJdbcTemplate.queryForObject(sqlBuilder2.toString(), params2.toArray(), this.bsiRowMapper);
                }
                catch (EmptyResultDataAccessException erdae) {
                    bsi = null;
                }
            }
        }
        if (bsi == null) {
            bsi = this.getBillingSchemeInfoByChargedeviceNo(orgNo, chargedeviceNo);
        }
        return bsi;
    }
}

