/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.bizservices.ebikemgmt.dao.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.ChargeDao;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeRequest;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeResponse;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ChargeDaoImpl
implements ChargeDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RowMapper<Map<String, Object>> mapRowMapper = (rs, rowNum) -> {
        ResultSetMetaData rsmd = rs.getMetaData();
        HashMap<String, Object> map = new HashMap<String, Object>();
        block18: for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            if (rs.getObject(i) == null) {
                map.put(rsmd.getColumnLabel(i).trim(), null);
                continue;
            }
            switch (rsmd.getColumnType(i)) {
                case 4: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getInt(i));
                    continue block18;
                }
                case -5: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getLong(i));
                    continue block18;
                }
                case 6: {
                    map.put(rsmd.getColumnLabel(i).trim(), Float.valueOf(rs.getFloat(i)));
                    continue block18;
                }
                case 7: {
                    map.put(rsmd.getColumnLabel(i).trim(), Float.valueOf(rs.getFloat(i)));
                    continue block18;
                }
                case 8: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getDouble(i));
                    continue block18;
                }
                case 3: {
                    if (rsmd.getScale(i) == 0) {
                        map.put(rsmd.getColumnLabel(i).trim(), rs.getBigDecimal(i).longValue());
                        continue block18;
                    }
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getBigDecimal(i).doubleValue());
                    continue block18;
                }
                case 2: {
                    if (rsmd.getScale(i) == 0) {
                        map.put(rsmd.getColumnLabel(i).trim(), rs.getBigDecimal(i).longValue());
                        continue block18;
                    }
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getBigDecimal(i).doubleValue());
                    continue block18;
                }
                case 91: {
                    map.put(rsmd.getColumnLabel(i).trim(), new Date(rs.getDate(i).getTime()));
                    continue block18;
                }
                case 92: {
                    map.put(rsmd.getColumnLabel(i).trim(), new Date(rs.getTime(i).getTime()));
                    continue block18;
                }
                case 93: {
                    map.put(rsmd.getColumnLabel(i).trim(), new Date(rs.getTimestamp(i).getTime()));
                    continue block18;
                }
                case 1: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getString(i));
                    continue block18;
                }
                case -15: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getString(i));
                    continue block18;
                }
                case 12: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getString(i));
                    continue block18;
                }
                case -9: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getString(i));
                    continue block18;
                }
                case -1: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getString(i));
                    continue block18;
                }
                case -16: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getString(i));
                    continue block18;
                }
                default: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getString(i));
                }
            }
        }
        return map;
    };
    private final RowMapper<ChargeRequest> crRowMapper = (rs, rowNum) -> {
        ChargeRequest chargeRequest = new ChargeRequest();
        chargeRequest.setOrgNo(rs.getString("subburo"));
        chargeRequest.setChargeplugNo(rs.getString("chargeplugNo"));
        chargeRequest.setChargeUserNo(rs.getString("chargeUserNo"));
        chargeRequest.setChargeUserType(rs.getString("chargeUserType"));
        chargeRequest.setType("start");
        chargeRequest.setMoney(Double.valueOf(rs.getDouble("money")));
        chargeRequest.setChargeTradeOrderId(rs.getString("chargeTradeOrderId"));
        chargeRequest.setEnterUserType(rs.getString("enterUserType"));
        chargeRequest.setEnterUserId(rs.getString("enterUserId"));
        return chargeRequest;
    };
    private final JdbcTemplate ebikeJdbcTemplate;

    public ChargeDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    public boolean checkIsCharging(Long chargeplugId) {
        String sql = "SELECT COUNT(chargeplugId) AS CNT FROM ebike.ebike_chargerecord WHERE chargeplugId = ? ";
        int cnt = (Integer)this.ebikeJdbcTemplate.queryForObject(sql, new Object[]{chargeplugId}, Integer.class);
        return cnt > 0;
    }

    public ChargeRequest buildChargeRequestPaySuccessWithnoCharging(String chargeTradeOrderId) {
        ChargeRequest chargeRequest;
        String sql = "SELECT cpo.* FROM ebike.ebike_log_chargeprepayorder cpo WHERE cpo.chargeTradeOrderId = ?  AND NOT EXISTS (SELECT 1 FROM ebike.ebike_chargerecord crc WHERE crc.chargeTradeOrderId = cpo.chargeTradeOrderId)  AND NOT EXISTS (SELECT 1 FROM ebike.ebike_chargerecord_his crh WHERE crh.chargeTradeOrderId = cpo.chargeTradeOrderId)  LIMIT 1 ";
        try {
            chargeRequest = (ChargeRequest)this.ebikeJdbcTemplate.queryForObject(sql, new Object[]{chargeTradeOrderId}, this.crRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            chargeRequest = null;
        }
        return chargeRequest;
    }

    public boolean checkIsBeChargedByChargeTradeOrderId(String chargeTradeOrderId) {
        String sql1 = "SELECT COUNT(chargeTradeOrderId) AS CNT FROM ebike.ebike_chargerecord WHERE chargeTradeOrderId = ? ";
        int cnt1 = (Integer)this.ebikeJdbcTemplate.queryForObject(sql1, new Object[]{chargeTradeOrderId}, Integer.class);
        String sql2 = "SELECT COUNT(chargeTradeOrderId) AS CNT FROM ebike.ebike_chargerecord_his WHERE chargeTradeOrderId = ? ";
        int cnt2 = (Integer)this.ebikeJdbcTemplate.queryForObject(sql2, new Object[]{chargeTradeOrderId}, Integer.class);
        return cnt1 > 0 || cnt2 > 0;
    }

    public int insertChargeRequestLog(Date requestTime, ChargeRequest chargeRequest, String chargeRecordId) {
        String sql = "INSERT INTO ebike.ebike_log_chargerequest(requestTime, chargeRecordId, buro, subburo, chargeplugNo, chargeUserNo, chargeUserType, type, money, chargeTradeOrderId, enterUserType, enterUserId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(requestTime != null ? requestTime : new Date());
        params.add(chargeRecordId);
        params.add(ObjectUtils.isNotNull((Object)chargeRequest) ? chargeRequest.getOrgNo() : null);
        params.add(ObjectUtils.isNotNull((Object)chargeRequest) ? chargeRequest.getOrgNo() : null);
        params.add(ObjectUtils.isNotNull((Object)chargeRequest) ? chargeRequest.getChargeplugNo() : null);
        params.add(ObjectUtils.isNotNull((Object)chargeRequest) ? chargeRequest.getChargeUserNo() : null);
        params.add(ObjectUtils.isNotNull((Object)chargeRequest) ? chargeRequest.getChargeUserType() : null);
        params.add(ObjectUtils.isNotNull((Object)chargeRequest) ? chargeRequest.getType() : null);
        params.add(ObjectUtils.isNotNull((Object)chargeRequest) ? chargeRequest.getMoney() : null);
        params.add(ObjectUtils.isNotNull((Object)chargeRequest) ? chargeRequest.getChargeTradeOrderId() : null);
        params.add(ObjectUtils.isNotNull((Object)chargeRequest) ? chargeRequest.getEnterUserType() : null);
        params.add(ObjectUtils.isNotNull((Object)chargeRequest) ? chargeRequest.getEnterUserId() : null);
        return this.ebikeJdbcTemplate.update(sql, params.toArray());
    }

    public int updateChargeRequestLog(Date responseTime, ChargeResponse chargeResponse, String chargeRecordId, Boolean gnrtChargeRecord, String gnrtFailReason) {
        String sql = "UPDATE ebike.ebike_log_chargerequest SET responseTime = ?, responseStatus = ?, responseMsg = ?, gnrtChargeRecord = ?, gnrtFailReason = ? WHERE chargeRecordId = ? ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(responseTime != null ? responseTime : new Date());
        params.add(ObjectUtils.isNotNull((Object)chargeResponse) ? Integer.valueOf(chargeResponse.getStatus()) : null);
        params.add(ObjectUtils.isNotNull((Object)chargeResponse) ? chargeResponse.getMsg() : null);
        params.add(gnrtChargeRecord);
        params.add(gnrtFailReason);
        params.add(chargeRecordId);
        return this.ebikeJdbcTemplate.update(sql, params.toArray());
    }

    public List<Map<String, Object>> getGnrtFailedChargeRequestList(Date startTime, Date endTime) {
        String sql = "SELECT log.chargeRecordId, log.chargeplugNo, log.chargeUserNo, log.chargeUserType, log.type, log.money, log.chargeTradeOrderId, log.responseTime, log.responseStatus, log.responseMsg   FROM ebike.ebike_log_chargerequest log  WHERE (gnrtChargeRecord = 0 OR gnrtChargeRecord IS NULL) AND type = 'start' AND money > 0.0 AND chargeTradeOrderId IS NOT NULL AND (returnFlag = 'N' OR returnFlag IS NULL)    AND NOT EXISTS (SELECT 1 FROM ebike.ebike_chargerecord cr WHERE cr.chargeTradeOrderId = log.chargeTradeOrderId AND chargeTime >= ?)    AND NOT EXISTS (SELECT 1 FROM ebike.ebike_chargerecord_his crh WHERE crh.chargeTradeOrderId = log.chargeTradeOrderId AND chargeTime >= ?)    AND requestTime >= ? AND requestTime <= ? ";
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" sql  : " + sql);
        }
        return this.ebikeJdbcTemplate.query(sql, new Object[]{startTime, startTime, startTime, endTime}, this.mapRowMapper);
    }

    public int updateChargeRequestLogByReturn(String chargeRecordId, String returnFlag, BigDecimal returnMoney, Date returnTime, String returnDesc, String returnTradeOrderId) {
        String sql = "UPDATE ebike.ebike_log_chargerequest SET returnFlag = ?, returnMoney = ?, returnTime = ?, returnDesc = ?, returnTradeOrderId = ? WHERE chargeRecordId = ? ";
        return this.ebikeJdbcTemplate.update(sql, new Object[]{returnFlag, returnMoney, returnTime, returnDesc, returnTradeOrderId, chargeRecordId});
    }

    public int updateChargeRequestLogByReturnResult(String chargeTradeOrderId, String returnTradeOrderId, String returnFlag, Date returnSuccessTime) {
        String sql = "UPDATE ebike.ebike_log_chargerequest SET returnFlag = ?, returnSuccessTime = ? WHERE chargeTradeOrderId = ? AND returnTradeOrderId = ? ";
        return this.ebikeJdbcTemplate.update(sql, new Object[]{returnFlag, returnSuccessTime, chargeTradeOrderId, returnTradeOrderId});
    }

    public int updateChargePrepayOrderLog(String chargeTradeOrderId, int payFlag, Date paySuccTime, String payFailReason) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start updateChargePrepayOrderLog >>>>>> ");
            this.logger.debug(" chargeTradeOrderId   : " + chargeTradeOrderId);
        }
        if (StringUtils.isNotBlank((CharSequence)chargeTradeOrderId)) {
            String sql = "UPDATE ebike.ebike_log_chargeprepayorder SET payFlag = ?, paySuccTime = ?, payFailReason = ? WHERE chargeTradeOrderId = ? ";
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(payFlag);
            params.add(paySuccTime);
            params.add(payFailReason);
            params.add(chargeTradeOrderId);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" sql      : " + sql);
                this.logger.debug(" params   : " + JsonConvertUtils.convertToString(params));
                this.logger.debug(" <<<<<<< end updateChargePrepayOrderLog <<<<<<< ");
            }
            return this.ebikeJdbcTemplate.update(sql, params.toArray());
        }
        return 0;
    }

    public int insertChargeRecord(Map<String, Object> chargeRecordMap) {
        if (!MapUtils.isEmpty(chargeRecordMap)) {
            String sql = "INSERT INTO ebike.ebike_chargerecord(chargeRecordId, chargeplugId, chargedeviceId, chargestationId, chargeUserId, chargeTime, chargePayMode, chargeMoney, coinMoney, card_id, chargeTradeOrderId, enterUserType, enterUserId, sharingReceivers, sharingMoneyFreezeCycle, serviceRate, schemeId, schemeType, unitPrice1, unitPrice2, unitPrice3, unitPrice4, unitPrice5, stepCount, stepPower1, stepPower2, stepPower3, stepPower4, minCharge, isReturn, closingPeriod, costSchemeId, costUnitPrice, chargeOpenFlag, firstUnitPriceFlag, firstChargeAmount, currUnitPriceFlag, chargeAmount, usageAmount, surplusAmount, usageElecCons, remainElecCons, remainTime, updateTime, schemeDetails) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(chargeRecordMap.get("chargeRecordId"));
            params.add(chargeRecordMap.get("chargeplugId"));
            params.add(chargeRecordMap.get("chargedeviceId"));
            params.add(chargeRecordMap.get("chargestationId"));
            params.add(chargeRecordMap.get("chargeUserId"));
            params.add(chargeRecordMap.get("chargeTime"));
            params.add(chargeRecordMap.get("chargePayMode"));
            params.add(chargeRecordMap.get("chargeMoney"));
            params.add(chargeRecordMap.get("coinMoney"));
            params.add(chargeRecordMap.get("card_id"));
            params.add(chargeRecordMap.get("chargeTradeOrderId"));
            params.add(chargeRecordMap.get("enterUserType"));
            params.add(chargeRecordMap.get("enterUserId"));
            params.add(chargeRecordMap.get("sharingReceivers"));
            params.add(chargeRecordMap.get("sharingMoneyFreezeCycle"));
            params.add(chargeRecordMap.get("serviceRate"));
            params.add(chargeRecordMap.get("schemeId"));
            params.add(chargeRecordMap.get("schemeType"));
            params.add(chargeRecordMap.get("unitPrice1"));
            params.add(chargeRecordMap.get("unitPrice2"));
            params.add(chargeRecordMap.get("unitPrice3"));
            params.add(chargeRecordMap.get("unitPrice4"));
            params.add(chargeRecordMap.get("unitPrice5"));
            params.add(chargeRecordMap.get("stepCount"));
            params.add(chargeRecordMap.get("stepPower1"));
            params.add(chargeRecordMap.get("stepPower2"));
            params.add(chargeRecordMap.get("stepPower3"));
            params.add(chargeRecordMap.get("stepPower4"));
            params.add(chargeRecordMap.get("minCharge"));
            params.add(chargeRecordMap.get("isReturn"));
            params.add(chargeRecordMap.get("closingPeriod"));
            params.add(chargeRecordMap.get("costSchemeId"));
            params.add(chargeRecordMap.get("costUnitPrice"));
            params.add(chargeRecordMap.get("chargeOpenFlag"));
            params.add(chargeRecordMap.get("firstUnitPriceFlag"));
            params.add(chargeRecordMap.get("firstChargeAmount"));
            params.add(chargeRecordMap.get("currUnitPriceFlag"));
            params.add(chargeRecordMap.get("chargeAmount"));
            params.add(chargeRecordMap.get("usageAmount"));
            params.add(chargeRecordMap.get("surplusAmount"));
            params.add(chargeRecordMap.get("usageElecCons"));
            params.add(chargeRecordMap.get("remainElecCons"));
            params.add(chargeRecordMap.get("remainTime"));
            params.add(new Date());
            params.add(chargeRecordMap.get("schemeDetails"));
            return this.ebikeJdbcTemplate.update(sql, params.toArray());
        }
        return 0;
    }

    public Long getChargeplugIdByChargeplugNo(String orgNo, String chargeplugNo) {
        if (StringUtils.isNotBlank((CharSequence)orgNo) && StringUtils.isNotBlank((CharSequence)chargeplugNo)) {
            Long chargeplugId;
            StringBuilder sqlBuilder = new StringBuilder();
            ArrayList<String> params = new ArrayList<String>();
            sqlBuilder.append("SELECT ecp.id ");
            sqlBuilder.append("  FROM cisp_dev.dev_ebikechargeplug ecp ");
            sqlBuilder.append(" INNER JOIN cisp_dev.dev_powersystemresource pss ON pss.id = ecp.id ");
            sqlBuilder.append(" WHERE ecp.chargeplugNo = ? AND pss.subburo = ? ");
            params.add(chargeplugNo);
            params.add(orgNo);
            sqlBuilder.append(" LIMIT 1 ");
            try {
                chargeplugId = (Long)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), Long.class);
            }
            catch (EmptyResultDataAccessException _erdae) {
                chargeplugId = null;
            }
            return chargeplugId;
        }
        return null;
    }

    public Map<String, Object> getChargePlugValueMap(String orgNo, String chargeplugNo) {
        if (StringUtils.isNotBlank((CharSequence)orgNo) && StringUtils.isNotBlank((CharSequence)chargeplugNo)) {
            Map chargePlugValueMap;
            StringBuilder sqlBuilder = new StringBuilder();
            ArrayList<String> params = new ArrayList<String>();
            sqlBuilder.append("SELECT ecp.`id` AS chargeplugId, ecp.chargedeviceId, ecd.chargestationId ");
            sqlBuilder.append("  FROM cisp_dev.dev_ebikechargeplug ecp ");
            sqlBuilder.append(" INNER JOIN cisp_dev.dev_powersystemresource pss ON pss.`id` = ecp.id AND pss.className = 'EBikeChargePlug' ");
            sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.`id` = ecp.chargedeviceId ");
            sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargestation ecs ON ecs.`id` = ecd.chargestationId ");
            sqlBuilder.append(" WHERE ecp.chargeplugNo = ? AND pss.subburo = ? ");
            params.add(chargeplugNo);
            params.add(orgNo);
            sqlBuilder.append(" LIMIT 1 ");
            try {
                chargePlugValueMap = (Map)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), this.mapRowMapper);
            }
            catch (EmptyResultDataAccessException _erdae) {
                chargePlugValueMap = null;
            }
            return chargePlugValueMap;
        }
        return null;
    }

    public String getChargeUserIdByChargeUserNo(String chargeUserNo, String chargeUserType) {
        if (StringUtils.isNotBlank((CharSequence)chargeUserNo) && StringUtils.isNotBlank((CharSequence)chargeUserType)) {
            String chargeUserId;
            StringBuilder sqlBuilder = new StringBuilder();
            ArrayList<String> params = new ArrayList<String>();
            sqlBuilder.append("SELECT ecu.chargeUserId ");
            sqlBuilder.append("  FROM ebike.ebike_chargeuser ecu ");
            sqlBuilder.append(" WHERE ecu.chargeUserNo = ? AND ecu.chargeUserType = ? ");
            params.add(chargeUserNo);
            params.add(chargeUserType);
            try {
                chargeUserId = (String)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), String.class);
            }
            catch (EmptyResultDataAccessException _erdae) {
                chargeUserId = null;
            }
            return chargeUserId;
        }
        return null;
    }
}

