/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.bizservices.ebikemgmt.dao.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.CostSchemeDao;
import cn.yunrui.bizservices.ebikemgmt.entity.CostSchemeInfo;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class CostSchemeDaoImpl
implements CostSchemeDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RowMapper<CostSchemeInfo> csiRowMapper = (rs, rowNum) -> {
        CostSchemeInfo csi = new CostSchemeInfo();
        csi.setCostSchemeId(rs.getString(1));
        csi.setBuro(rs.getString(2));
        csi.setSubburo(rs.getString(3));
        csi.setCostSchemeNo(rs.getString(4));
        csi.setCostSchemeName(rs.getString(5));
        csi.setCostUnitPrice(Double.valueOf(rs.getDouble(6)));
        return csi;
    };
    private final JdbcTemplate ebikeJdbcTemplate;

    private StringBuilder builderCostSchemePreSQL() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT ecs.costSchemeId, ecs.buro, ecs.subburo, ecs.costSchemeNo, ecs.costSchemeName, ecs.costUnitPrice ");
        sqlBuilder.append("  FROM ebike.ebike_costscheme ecs ");
        return sqlBuilder;
    }

    public CostSchemeDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    public CostSchemeInfo getCostSchemeInfoById(String costSchemeId) {
        CostSchemeInfo csi;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getCostSchemeInfoById >>>>>>> ");
            this.logger.debug(" costSchemeId : " + costSchemeId);
        }
        StringBuilder sqlBuilder = this.builderCostSchemePreSQL();
        ArrayList<String> params = new ArrayList<String>();
        sqlBuilder.append(" WHERE ecs.costSchemeId = ? ");
        params.add(costSchemeId);
        try {
            csi = (CostSchemeInfo)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), this.csiRowMapper);
        }
        catch (EmptyResultDataAccessException erdae) {
            csi = null;
        }
        return csi;
    }

    public CostSchemeInfo getCostSchemeInfoByNo(String orgNo, String costSchemeNo) {
        CostSchemeInfo csi;
        StringBuilder sqlBuilder = this.builderCostSchemePreSQL();
        ArrayList<String> params = new ArrayList<String>();
        sqlBuilder.append(" WHERE ecs.buro = ? AND ecs.subburo = ? AND ecs.costSchemeNo = ? ");
        params.add(orgNo);
        params.add(orgNo);
        params.add(costSchemeNo);
        sqlBuilder.append(" LIMIT 1 ");
        try {
            csi = (CostSchemeInfo)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), this.csiRowMapper);
        }
        catch (EmptyResultDataAccessException erdae) {
            csi = null;
        }
        return csi;
    }

    public CostSchemeInfo getCostSchemeInfoByChargedeviceId(Long chargedeviceId) {
        CostSchemeInfo csi;
        StringBuilder sqlBuilder = this.builderCostSchemePreSQL();
        ArrayList<Long> params = new ArrayList<Long>();
        sqlBuilder.append(" INNER JOIN ebike.ebike_cs_cs_rela ccr ON ccr.costSchemeId = ecs.costSchemeId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.chargestationId = ccr.chargestationId ");
        sqlBuilder.append(" WHERE ecd.`id` = ? ");
        params.add(chargedeviceId);
        sqlBuilder.append(" LIMIT 1 ");
        try {
            csi = (CostSchemeInfo)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), this.csiRowMapper);
        }
        catch (EmptyResultDataAccessException erdae) {
            csi = null;
        }
        return csi;
    }

    public CostSchemeInfo getCostSchemeInfoByChargedeviceNo(String orgNo, String chargedeviceNo) {
        CostSchemeInfo csi;
        StringBuilder sqlBuilder = this.builderCostSchemePreSQL();
        ArrayList<String> params = new ArrayList<String>();
        sqlBuilder.append(" INNER JOIN ebike.ebike_cs_cs_rela ccr ON ccr.costSchemeId = ecs.costSchemeId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.chargestationId = ccr.chargestationId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_powersystemresource pss ON pss.`id` = ecd.`id` AND pss.className = 'EBikeChargeDevice' ");
        sqlBuilder.append(" WHERE pss.buro = ? AND pss.subburo = ? AND ecd.chargedeviceNo = ? ");
        params.add(orgNo);
        params.add(orgNo);
        params.add(chargedeviceNo);
        sqlBuilder.append(" LIMIT 1 ");
        try {
            csi = (CostSchemeInfo)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), this.csiRowMapper);
        }
        catch (EmptyResultDataAccessException erdae) {
            csi = null;
        }
        return csi;
    }
}

