/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.bizservices.ebikemgmt.dao.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.FitConnectDao;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeDeviceInfo;
import cn.yunrui.bizservices.ebikemgmt.entity.FitConnectRequest;
import cn.yunrui.bizservices.ebikemgmt.entity.FitConnectResponse;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;

public class FitConnectDaoImpl
implements FitConnectDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JdbcTemplate ebikeJdbcTemplate;

    public FitConnectDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    public ChargeDeviceInfo getChargeDeviceInfoFromAssetsRepo(String orgNo, String chargedeviceNo) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start getChargeDeviceInfoFromAssetsRepo >>>>>> ");
            this.logger.debug(" orgNo            : " + orgNo);
            this.logger.debug(" chargedeviceNo   : " + chargedeviceNo);
        }
        if (StringUtils.isNotBlank((CharSequence)orgNo) && StringUtils.isNotBlank((CharSequence)chargedeviceNo)) {
            ChargeDeviceInfo cdi;
            StringBuilder sqlBuilder = new StringBuilder();
            ArrayList<String> params = new ArrayList<String>();
            sqlBuilder.append("SELECT eac.buro, eac.subburo, eac.chargedeviceNo, eac.deviceId, eac.protocolType, eac.protocolVersion, eac.plugCount, eac.factory, eac.modelNo ");
            sqlBuilder.append("     , eac.`status`, eac.chargedeviceId, eac.importTime, eac.installTime, eac.runTime, eac.dismantleTime ");
            sqlBuilder.append("  FROM ebike.ebike_assets_chargedevice eac ");
            sqlBuilder.append(" WHERE (eac.buro = ? OR eac.buro = '0' OR eac.buro = '000000000') ");
            params.add(orgNo);
            sqlBuilder.append("   AND (eac.subburo = ? OR eac.subburo = '0' OR eac.subburo = '000000000') ");
            params.add(orgNo);
            sqlBuilder.append("   AND eac.chargedeviceNo = ? ");
            params.add(chargedeviceNo);
            try {
                cdi = (ChargeDeviceInfo)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), (rs, rowNum) -> {
                    ChargeDeviceInfo cdiTemp = new ChargeDeviceInfo();
                    cdiTemp.setOrgNo(rs.getString(2));
                    cdiTemp.setChargedeviceNo(rs.getString(3));
                    cdiTemp.setDeviceId(rs.getString(4));
                    cdiTemp.setProtocolType(rs.getString(5));
                    cdiTemp.setProtocolVersion(rs.getString(6));
                    cdiTemp.setPlugCount(Integer.valueOf(rs.getInt(7)));
                    cdiTemp.setChargedeviceFactory(rs.getString(8));
                    cdiTemp.setChargedeviceModelNo(rs.getString(9));
                    if (StringUtils.isNotBlank((CharSequence)rs.getString(10))) {
                        cdiTemp.setStatus(rs.getString(10));
                    } else {
                        cdiTemp.setStatus("00");
                    }
                    if (rs.getObject(11) != null && rs.getLong(11) > 0L) {
                        cdiTemp.setChargedeviceId(Long.valueOf(rs.getLong(11)));
                    }
                    if (rs.getObject(12) != null) {
                        cdiTemp.setImportTime(new Date(rs.getTimestamp(12).getTime()));
                    }
                    if (rs.getObject(13) != null) {
                        cdiTemp.setInstallTime(new Date(rs.getTimestamp(13).getTime()));
                    }
                    if (rs.getObject(14) != null) {
                        cdiTemp.setRunTime(new Date(rs.getTimestamp(14).getTime()));
                    }
                    if (rs.getObject(15) != null) {
                        cdiTemp.setDismantleTime(new Date(rs.getTimestamp(15).getTime()));
                    }
                    return cdiTemp;
                });
            }
            catch (EmptyResultDataAccessException _erdae) {
                cdi = null;
            }
            return cdi;
        }
        return null;
    }

    public int insertFitconnRequestLog(FitConnectRequest fitConnectRequest, FitConnectResponse fitConnectResponse, String fitconnectType) {
        return 0;
    }

    public void initChargeDeviceStatus(Long chargedeviceId) {
        if (chargedeviceId != null && chargedeviceId > 0L) {
            String sql = "INSERT INTO ebike.ebike_chargedevice_ops(chargedeviceId, opStatus) SELECT `ID`, '0' FROM cisp_dev.dev_ebikechargedevice WHERE `ID` = ? ON DUPLICATE KEY UPDATE opStatus = VALUES(opStatus) ";
            this.ebikeJdbcTemplate.update(sql, new Object[]{chargedeviceId});
        }
    }

    public void initChargePlugStatus(final Long[] chargeplugIds) {
        if (chargeplugIds != null && chargeplugIds.length > 0) {
            String sql = "INSERT INTO ebike.ebike_chargeplug_ops(chargeplugId, opStatus, opStatusTime) SELECT `ID`, '9', ? FROM cisp_dev.dev_ebikechargeplug WHERE `ID` = ? ON DUPLICATE KEY UPDATE opStatus = VALUES(opStatus), opStatusTime = VALUES(opStatusTime) ";
            this.ebikeJdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

                public int getBatchSize() {
                    return chargeplugIds.length;
                }

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    ps.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    ps.setLong(2, chargeplugIds[i]);
                }
            });
        }
    }

    public void updateDeviceAssertInfo(String orgNo, String chargedeviceNo, String status, Long chargedeviceId) {
        if (StringUtils.isNotBlank((CharSequence)orgNo) && StringUtils.isNotBlank((CharSequence)chargedeviceNo) && StringUtils.isNotBlank((CharSequence)status)) {
            StringBuilder sqlBuilder = new StringBuilder();
            ArrayList<Object> params = new ArrayList<Object>();
            sqlBuilder.append("UPDATE ebike.ebike_assets_chargedevice eac ");
            sqlBuilder.append("   SET eac.buro = ? ");
            params.add(orgNo);
            sqlBuilder.append("     , eac.subburo = ? ");
            params.add(orgNo);
            sqlBuilder.append("     , eac.`status` = ? ");
            params.add(status);
            if (StringUtils.equals((CharSequence)"00", (CharSequence)status)) {
                sqlBuilder.append("     , eac.importTime = NULL ");
                sqlBuilder.append("     , eac.installTime = NULL ");
                sqlBuilder.append("     , eac.runTime = NULL ");
                sqlBuilder.append("     , eac.dismantleTime = NULL ");
            } else {
                if (chargedeviceId != null) {
                    sqlBuilder.append("     , eac.chargedeviceId = ? ");
                    params.add(chargedeviceId);
                }
                if (StringUtils.equals((CharSequence)"02", (CharSequence)status)) {
                    sqlBuilder.append("     , eac.installTime = ? ");
                    params.add(new Date());
                    sqlBuilder.append("     , eac.runTime = NULL ");
                    sqlBuilder.append("     , eac.dismantleTime = NULL ");
                } else if (StringUtils.equals((CharSequence)"03", (CharSequence)status)) {
                    sqlBuilder.append("     , eac.runTime = ? ");
                    params.add(new Date());
                    sqlBuilder.append("     , eac.dismantleTime = NULL ");
                } else if (StringUtils.equals((CharSequence)"07", (CharSequence)status)) {
                    sqlBuilder.append("     , eac.dismantleTime = ? ");
                    params.add(new Date());
                }
            }
            sqlBuilder.append(" WHERE eac.chargedeviceNo = ? ");
            params.add(chargedeviceNo);
            this.ebikeJdbcTemplate.update(sqlBuilder.toString(), params.toArray());
        }
    }
}

