/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.bizservices.ebikemgmt.dao.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.TestDao;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeDeviceInfo;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class TestDaoImpl
implements TestDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JdbcTemplate ebikeJdbcTemplate;

    public TestDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    public ChargeDeviceInfo getChargeDeviceInfoFromAssetsRepo(String chargedeviceNo) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getChargeDeviceInfoFromAssetsRepo >>>>>>> ");
            this.logger.debug(" chargedeviceNo   : " + chargedeviceNo);
        }
        if (StringUtils.isNotBlank((CharSequence)chargedeviceNo)) {
            ChargeDeviceInfo cdi;
            StringBuilder sqlBuilder = new StringBuilder();
            ArrayList<String> params = new ArrayList<String>();
            sqlBuilder.append("SELECT eac.buro, eac.subburo, eac.chargedeviceNo, eac.deviceId, eac.protocolType, eac.protocolVersion, eac.plugCount, eac.factory, eac.modelNo ");
            sqlBuilder.append("     , eac.`status`, eac.chargedeviceId, eac.importTime, eac.installTime, eac.runTime, eac.dismantleTime ");
            sqlBuilder.append("  FROM ebike.ebike_assets_chargedevice eac ");
            sqlBuilder.append(" WHERE eac.chargedeviceNo = ? ");
            params.add(chargedeviceNo);
            try {
                cdi = (ChargeDeviceInfo)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), (rs, rowNum) -> {
                    ChargeDeviceInfo cdiTemp = new ChargeDeviceInfo();
                    cdiTemp.setOrgNo(rs.getString(2));
                    cdiTemp.setChargedeviceNo(rs.getString(3));
                    cdiTemp.setDeviceId(rs.getString(4));
                    cdiTemp.setProtocolType(rs.getString(5));
                    cdiTemp.setProtocolVersion(rs.getString(6));
                    cdiTemp.setPlugCount(Integer.valueOf(rs.getInt(7)));
                    cdiTemp.setChargedeviceFactory(rs.getString(8));
                    cdiTemp.setChargedeviceModelNo(rs.getString(9));
                    if (StringUtils.isNotBlank((CharSequence)rs.getString(10))) {
                        cdiTemp.setStatus(rs.getString(10));
                    } else {
                        cdiTemp.setStatus("00");
                    }
                    return cdiTemp;
                });
            }
            catch (EmptyResultDataAccessException _erdae) {
                cdi = null;
            }
            return cdi;
        }
        return null;
    }
}

