/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.bizservices.ebikemgmt.service.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.BillingSchemeDao;
import cn.yunrui.bizservices.ebikemgmt.dao.ChargeDao;
import cn.yunrui.bizservices.ebikemgmt.dao.CostSchemeDao;
import cn.yunrui.bizservices.ebikemgmt.dao.FitConnectDao;
import cn.yunrui.bizservices.ebikemgmt.dao.ServiceRateDao;
import cn.yunrui.bizservices.ebikemgmt.entity.BillingSchemeInfo;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeDeviceInfo;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeRequest;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeResponse;
import cn.yunrui.bizservices.ebikemgmt.entity.CostSchemeInfo;
import cn.yunrui.bizservices.ebikemgmt.service.ChargeService;
import cn.yunrui.bizservices.ebikemgmt.utils.BillingUtil;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.service.EBikeChargeService;
import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.RandomUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChargeServiceImpl
implements ChargeService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="billingSchemeDao")
    private BillingSchemeDao billingSchemeDao;
    @Resource(name="costSchemeDao")
    private CostSchemeDao costSchemeDao;
    @Resource(name="chargeDao")
    private ChargeDao chargeDao;
    @Resource(name="serviceRateDao")
    private ServiceRateDao serviceRateDao;
    @Resource(name="fitConnectDao")
    private FitConnectDao fitConnectDao;
    @Resource(name="ebikeChargeService")
    private EBikeChargeService ebikeChargeService;

    private String getNewChargeRecordId(String chargeplugNo, Date chargeTime) {
        return Joiner.on((String)"-").skipNulls().join((Object)("EB" + chargeplugNo), (Object)new DateTime((Object)chargeTime).toString("yyyyMMddHHmmssSSS"), new Object[]{RandomUtils.nextInt((int)101, (int)999)});
    }

    public ChargeResponse charge(ChargeRequest chargeRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start charge >>>>>> ");
            this.logger.debug(" chargeRequest : " + (chargeRequest != null ? chargeRequest.toString() : null));
        }
        Date requestTime = new Date();
        Date chargeTime = new Date();
        ChargeResponse chargeResponse = new ChargeResponse();
        chargeResponse.setStatus(-1);
        chargeResponse.setMsg("\u4e0b\u53d1\u5f00\u59cb/\u7ed3\u675f\u5145\u7535\u547d\u4ee4\u5931\u8d25");
        if (chargeRequest != null) {
            String chargeplugNo = chargeRequest.getChargeplugNo();
            String chargeRecordId = this.getNewChargeRecordId(chargeplugNo, chargeTime);
            int insCrlResult = this.chargeDao.insertChargeRequestLog(requestTime, chargeRequest, chargeRecordId);
            boolean gnrtChargeRecord = false;
            String gnrtFailReason = "";
            if (insCrlResult > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" insertChargeRequestLog success ");
                }
                if (chargeplugNo != null && chargeplugNo.trim().length() >= 3) {
                    String chargedeviceNo = chargeplugNo.trim().substring(0, chargeplugNo.trim().length() - 2);
                    String plugSn = chargeplugNo.trim().substring(chargeplugNo.trim().length() - 2);
                    ChargeDeviceInfo cdi = this.fitConnectDao.getChargeDeviceInfoFromAssetsRepo(chargeRequest.getOrgNo(), chargedeviceNo);
                    if (ObjectUtils.isNotNull((Object)cdi) && StringUtils.isNotBlank((CharSequence)cdi.getDeviceId())) {
                        if (StringUtils.equals((CharSequence)"start", (CharSequence)chargeRequest.getType())) {
                            Map chargePlugValueMap;
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug(" \u5145\u7535\u8bbe\u5907\u7f16\u53f7[chargedeviceNo] : " + chargedeviceNo + " , \u5145\u7535\u63d2\u5ea7\u5e8f\u53f7[plugSn] : " + plugSn);
                                this.logger.debug(" \u3000\u3000>>>>>> \u5f00\u59cb\u5145\u7535... ");
                            }
                            if (MapUtils.isNotEmpty((Map)(chargePlugValueMap = this.chargeDao.getChargePlugValueMap(chargeRequest.getOrgNo(), chargeRequest.getChargeplugNo())))) {
                                Long chargeplugId = (Long)chargePlugValueMap.get("chargeplugId");
                                Long chargedeviceId = (Long)chargePlugValueMap.get("chargedeviceId");
                                Long chargestationId = (Long)chargePlugValueMap.get("chargestationId");
                                if (this.chargeDao.checkIsCharging(chargeplugId)) {
                                    chargeResponse.setStatus(-2);
                                    chargeResponse.setMsg("\u4e0b\u53d1\u5f00\u59cb\u5145\u7535\u547d\u4ee4\u5931\u8d25\uff0c\u5145\u7535\u63d2\u5ea7\u6b63\u5728\u5145\u7535");
                                } else if (StringUtils.isNotBlank((CharSequence)chargeRequest.getChargeTradeOrderId()) && this.chargeDao.checkIsBeChargedByChargeTradeOrderId(chargeRequest.getChargeTradeOrderId())) {
                                    chargeResponse.setStatus(-6);
                                    chargeResponse.setMsg("\u4e0b\u53d1\u5f00\u59cb\u5145\u7535\u547d\u4ee4\u5931\u8d25\uff0c\u91cd\u590d\u5145\u7535");
                                } else {
                                    String chargeUserNo = chargeRequest.getChargeUserNo();
                                    String chargeUserType = chargeRequest.getChargeUserType();
                                    String chargeUserId = this.chargeDao.getChargeUserIdByChargeUserNo(chargeUserNo, chargeUserType);
                                    String msgExt = null;
                                    if (StringUtils.isBlank((CharSequence)chargeUserId)) {
                                        if (StringUtils.equals((CharSequence)chargeUserType, (CharSequence)"10")) {
                                            chargeUserType = "30";
                                            chargeUserId = this.chargeDao.getChargeUserIdByChargeUserNo(chargeUserNo, chargeUserType);
                                            msgExt = "\u5145\u7535\u7528\u6237\u7c7b\u578b\uff08\u5fae\u4fe1\u516c\u4f17\u53f7\uff09\u4f7f\u7528\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u5145\u7535";
                                        } else if (StringUtils.equals((CharSequence)chargeUserType, (CharSequence)"30")) {
                                            chargeUserType = "10";
                                            chargeUserId = this.chargeDao.getChargeUserIdByChargeUserNo(chargeUserNo, chargeUserType);
                                            msgExt = "\u5145\u7535\u7528\u6237\u7c7b\u578b\uff08\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\uff09\u4f7f\u7528\u5fae\u4fe1\u516c\u4f17\u53f7\u5145\u7535";
                                        }
                                    }
                                    BillingSchemeInfo bsi = this.billingSchemeDao.getBillingSchemeInfoByChargedeviceNo(chargeRequest.getOrgNo(), chargedeviceNo, chargeUserNo, chargeUserType);
                                    Double serviceRate = this.serviceRateDao.getServiceRateByChargestationId(chargestationId);
                                    CostSchemeInfo csi = this.costSchemeDao.getCostSchemeInfoByChargedeviceNo(chargeRequest.getOrgNo(), chargedeviceNo);
                                    if (this.logger.isDebugEnabled()) {
                                        this.logger.debug(" chargeUserId          : " + chargeUserId);
                                        this.logger.debug(" BillingSchemeInfo     : " + JsonConvertUtils.convertToString((Object)bsi));
                                        this.logger.debug(" CostSchemeInfo        : " + JsonConvertUtils.convertToString((Object)csi));
                                        this.logger.debug(" serviceRate           : " + serviceRate);
                                    }
                                    if (StringUtils.isNotBlank((CharSequence)chargeUserId) && ObjectUtils.isNotNull((Object)bsi)) {
                                        Map<String, Object> chargeRecordMap = BillingUtil.getChargeRecordMap(bsi, chargeRequest.getMoney());
                                        if (this.logger.isDebugEnabled()) {
                                            this.logger.debug(" 2.chargeRecordMap      : " + JsonConvertUtils.convertToString(chargeRecordMap));
                                        }
                                        if (chargeRecordMap != null) {
                                            chargeRecordMap.put("chargeRecordId", chargeRecordId);
                                            chargeRecordMap.put("chargeTime", chargeTime);
                                            chargeRecordMap.put("chargePayMode", 1);
                                            chargeRecordMap.put("chargeplugId", chargeplugId);
                                            chargeRecordMap.put("chargedeviceId", chargedeviceId);
                                            chargeRecordMap.put("chargestationId", chargestationId);
                                            chargeRecordMap.put("chargeUserId", chargeUserId);
                                            if (ObjectUtils.isNotNull((Object)csi)) {
                                                chargeRecordMap.put("costSchemeId", csi.getCostSchemeId());
                                                chargeRecordMap.put("costUnitPrice", csi.getCostUnitPrice());
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)chargeRequest.getChargeTradeOrderId())) {
                                                chargeRecordMap.put("chargeTradeOrderId", chargeRequest.getChargeTradeOrderId());
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)chargeRequest.getEnterUserType())) {
                                                chargeRecordMap.put("enterUserType", chargeRequest.getEnterUserType());
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)chargeRequest.getEnterUserId())) {
                                                chargeRecordMap.put("enterUserId", chargeRequest.getEnterUserId());
                                            }
                                            chargeRecordMap.put("sharingReceivers", "{}");
                                            chargeRecordMap.put("sharingMoneyFreezeCycle", 25);
                                            if (serviceRate != null) {
                                                chargeRecordMap.put("serviceRate", serviceRate);
                                            }
                                            StringBuilder msg2Device = new StringBuilder();
                                            msg2Device.append(chargeRequest.getType());
                                            msg2Device.append("#").append(Integer.parseInt(plugSn));
                                            msg2Device.append("#").append(Math.round((Double)chargeRecordMap.get("remainElecCons") * 1000.0));
                                            long remainTime = Math.round((Double)chargeRecordMap.get("remainTime"));
                                            msg2Device.append("#").append(remainTime);
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug(" 3.chargeRecordMap      : " + JsonConvertUtils.convertToString(chargeRecordMap));
                                            }
                                            this.logger.info("<<==================\u6b63\u5e38\u5145\u7535-----------------\u5f00\u59cb\u5145\u7535\u62a5\u6587========= >>: " + msg2Device);
                                            int result = this.chargeDao.insertChargeRecord(chargeRecordMap);
                                            if (result > 0) {
                                                chargeResponse.setChargeRecordId(chargeRecordId);
                                                boolean r = this.ebikeChargeService.publish2device(cdi.getDeviceId(), msg2Device.toString(), chargeRequest.getType());
                                                if (r) {
                                                    chargeResponse.setStatus(0);
                                                    chargeResponse.setMsg("\u4e0b\u53d1\u5f00\u59cb\u5145\u7535\u547d\u4ee4\u6210\u529f" + (msgExt != null ? "\uff08" + msgExt + "\uff09" : ""));
                                                    gnrtChargeRecord = true;
                                                } else {
                                                    chargeResponse.setStatus(-1);
                                                    chargeResponse.setMsg("\u4e0b\u53d1\u5f00\u59cb\u5145\u7535\u547d\u4ee4\u5931\u8d25");
                                                }
                                            }
                                        } else {
                                            chargeResponse.setStatus(-5);
                                            chargeResponse.setMsg("\u4e0b\u53d1\u5f00\u59cb\u5145\u7535\u547d\u4ee4\u5931\u8d25\uff0c\u8ba1\u8d39\u65b9\u6848\u4e3a\u7a7a");
                                        }
                                    } else if (StringUtils.isBlank((CharSequence)chargeUserId)) {
                                        chargeResponse.setStatus(-4);
                                        chargeResponse.setMsg("\u4e0b\u53d1\u5f00\u59cb\u5145\u7535\u547d\u4ee4\u5931\u8d25\uff0c\u65e0\u8be5\u5145\u7535\u7528\u6237");
                                    } else {
                                        chargeResponse.setStatus(-5);
                                        chargeResponse.setMsg("\u4e0b\u53d1\u5f00\u59cb\u5145\u7535\u547d\u4ee4\u5931\u8d25\uff0c\u8ba1\u8d39\u65b9\u6848\u4e3a\u7a7a");
                                    }
                                }
                            } else {
                                chargeResponse.setStatus(-3);
                                chargeResponse.setMsg("\u4e0b\u53d1\u5f00\u59cb\u5145\u7535\u547d\u4ee4\u5931\u8d25\uff0c\u65e0\u8be5\u5145\u7535\u63d2\u5ea7");
                            }
                        } else if (StringUtils.equals((CharSequence)"stop", (CharSequence)chargeRequest.getType())) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug(" \u5145\u7535\u8bbe\u5907\u7f16\u53f7[chargedeviceNo] : " + chargedeviceNo + " , \u5145\u7535\u63d2\u5ea7\u5e8f\u53f7[plugSn] : " + plugSn);
                                this.logger.debug(" \u3000\u3000<<<<<< \u7ed3\u675f\u5145\u7535... ");
                            }
                            String msg2Device = chargeRequest.getType() + "#" + Integer.parseInt(plugSn);
                            boolean r = this.ebikeChargeService.publish2device(cdi.getDeviceId(), msg2Device, chargeRequest.getType());
                            if (r) {
                                chargeResponse.setStatus(0);
                                chargeResponse.setMsg("\u4e0b\u53d1\u7ed3\u675f\u5145\u7535\u547d\u4ee4\u6210\u529f");
                            } else {
                                chargeResponse.setStatus(-1);
                                chargeResponse.setMsg("\u4e0b\u53d1\u7ed3\u675f\u5145\u7535\u547d\u4ee4\u5931\u8d25");
                            }
                        }
                    } else {
                        chargeResponse.setStatus(-97);
                        chargeResponse.setMsg("\u65e0\u8be5\u5145\u7535\u8bbe\u5907");
                    }
                } else {
                    chargeResponse.setStatus(-98);
                    chargeResponse.setMsg("\u8bf7\u6c42\u53c2\u6570\uff08\u5145\u7535\u63d2\u5ea7\u7f16\u53f7\uff09\u975e\u6cd5");
                }
                Date responseTime = new Date();
                int uptCrlResult = this.chargeDao.updateChargeRequestLog(responseTime, chargeResponse, chargeRecordId, Boolean.valueOf(gnrtChargeRecord), gnrtFailReason);
                if (uptCrlResult > 0) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(" updateChargeRequestLog success ");
                    }
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" updateChargeRequestLog failure ");
                }
            } else {
                this.logger.warn(" insertChargeRequestLog failure ");
                this.logger.warn(" chargeRequest     : " + chargeRequest.toString());
                this.logger.warn(" chargeResponse    : " + chargeResponse.toString());
                this.logger.warn(" chargeRecordId    : " + chargeRecordId);
            }
        } else {
            chargeResponse.setStatus(-99);
            chargeResponse.setMsg("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end charge <<<<<<< ");
        }
        return chargeResponse;
    }

    public static void main(String[] args) {
        long remainTime = Math.round(new Double(1200.0));
        if (remainTime > 999L) {
            remainTime = 999L;
        }
        System.out.println(remainTime);
    }

    public void updateChargePrepayOrderLog(String chargeTradeOrderId, int payFlag, Date paySuccTime, String payFailReason) {
        this.chargeDao.updateChargePrepayOrderLog(chargeTradeOrderId, payFlag, paySuccTime, payFailReason);
    }

    public ChargeRequest buildChargeRequestPaySuccessWithnoCharging(String chargeTradeOrderId) {
        return this.chargeDao.buildChargeRequestPaySuccessWithnoCharging(chargeTradeOrderId);
    }

    public List<Map<String, Object>> getGnrtFailedChargeRequestList(Date startTime, Date endTime) {
        return this.chargeDao.getGnrtFailedChargeRequestList(startTime, endTime);
    }

    public void updateChargeRequestLogByReturn(String chargeRecordId, String returnFlag, BigDecimal returnMoney, Date returnTime, String returnDesc, String returnTradeOrderId) {
        this.chargeDao.updateChargeRequestLogByReturn(chargeRecordId, returnFlag, returnMoney, returnTime, returnDesc, returnTradeOrderId);
    }

    public void updateChargeRequestLogByReturnResult(String chargeTradeOrderId, String returnTradeOrderId, String returnFlag, Date returnSuccessTime) {
        this.chargeDao.updateChargeRequestLogByReturnResult(chargeTradeOrderId, returnTradeOrderId, returnFlag, returnSuccessTime);
    }
}

