/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.bizservices.ebikemgmt.service.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.ChargeDao;
import cn.yunrui.bizservices.ebikemgmt.dao.DebugDao;
import cn.yunrui.bizservices.ebikemgmt.dao.FitConnectDao;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeDeviceInfo;
import cn.yunrui.bizservices.ebikemgmt.entity.DebugRequest;
import cn.yunrui.bizservices.ebikemgmt.entity.DebugResponse;
import cn.yunrui.bizservices.ebikemgmt.service.DebugService;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.service.EBikeChargeService;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugServiceImpl
implements DebugService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="debugDao")
    private DebugDao debugDao;
    @Resource(name="chargeDao")
    private ChargeDao chargeDao;
    @Resource(name="fitConnectDao")
    private FitConnectDao fitConnectDao;
    @Resource(name="ebikeChargeService")
    private EBikeChargeService ebikeChargeService;

    public DebugResponse debugging(DebugRequest debugRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start debugging >>>>>> ");
            this.logger.debug(" DebugRequest : " + (debugRequest != null ? debugRequest.toString() : null));
        }
        DebugResponse debugResponse = new DebugResponse();
        debugResponse.setStatus(-1);
        debugResponse.setMsg("\u4e0b\u53d1\u88c5\u63a5\u8c03\u8bd5\u547d\u4ee4\u5931\u8d25");
        if (debugRequest != null) {
            String chargeplugNo = debugRequest.getChargeplugNo();
            if (chargeplugNo != null && chargeplugNo.trim().length() >= 3) {
                String chargedeviceNo = chargeplugNo.trim().substring(0, chargeplugNo.trim().length() - 2);
                String plugSn = chargeplugNo.trim().substring(chargeplugNo.trim().length() - 2);
                ChargeDeviceInfo cdi = this.fitConnectDao.getChargeDeviceInfoFromAssetsRepo(debugRequest.getOrgNo(), chargedeviceNo);
                if (ObjectUtils.isNotNull((Object)cdi) && StringUtils.isNotBlank((CharSequence)cdi.getDeviceId())) {
                    if (StringUtils.equals((CharSequence)"start", (CharSequence)debugRequest.getDebugType())) {
                        Map chargePlugValueMap;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(" \u5145\u7535\u8bbe\u5907\u7f16\u53f7[chargedeviceNo] : " + chargedeviceNo + " , \u5145\u7535\u63d2\u5ea7\u5e8f\u53f7[plugSn] : " + plugSn);
                            this.logger.debug(" \u3000\u3000>>>>>> \u88c5\u63a5\u8c03\u8bd5 - \u5f00\u59cb\u5145\u7535... ");
                        }
                        if (MapUtils.isNotEmpty((Map)(chargePlugValueMap = this.chargeDao.getChargePlugValueMap(debugRequest.getOrgNo(), debugRequest.getChargeplugNo())))) {
                            Long chargeplugId = (Long)chargePlugValueMap.get("chargeplugId");
                            if (this.chargeDao.checkIsCharging(chargeplugId)) {
                                debugResponse.setStatus(-2);
                                debugResponse.setMsg("\u4e0b\u53d1\u88c5\u63a5\u8c03\u8bd5\uff08\u5f00\u59cb\u5145\u7535\uff09\u547d\u4ee4\u5931\u8d25\uff0c\u5145\u7535\u63d2\u5ea7\u6b63\u5728\u5145\u7535");
                            } else {
                                String msg2Device = debugRequest.getDebugType() + "#" + Integer.parseInt(plugSn) + "#10#10";
                                boolean r = this.ebikeChargeService.publish2device(cdi.getDeviceId(), msg2Device, debugRequest.getDebugType());
                                if (r) {
                                    debugResponse.setStatus(0);
                                    debugResponse.setMsg("\u4e0b\u53d1\u88c5\u63a5\u8c03\u8bd5\uff08\u5f00\u59cb\u5145\u7535\uff09\u547d\u4ee4\u6210\u529f");
                                } else {
                                    debugResponse.setStatus(-1);
                                    debugResponse.setMsg("\u4e0b\u53d1\u88c5\u63a5\u8c03\u8bd5\uff08\u5f00\u59cb\u5145\u7535\uff09\u547d\u4ee4\u5931\u8d25");
                                }
                            }
                        } else {
                            debugResponse.setStatus(-3);
                            debugResponse.setMsg("\u4e0b\u53d1\u88c5\u63a5\u8c03\u8bd5\uff08\u5f00\u59cb\u5145\u7535\uff09\u547d\u4ee4\u5931\u8d25\uff0c\u65e0\u8be5\u5145\u7535\u63d2\u5ea7");
                        }
                    } else if (StringUtils.equals((CharSequence)"stop", (CharSequence)debugRequest.getDebugType())) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(" \u5145\u7535\u8bbe\u5907\u7f16\u53f7[chargedeviceNo] : " + chargedeviceNo + " , \u5145\u7535\u63d2\u5ea7\u5e8f\u53f7[plugSn] : " + plugSn);
                            this.logger.debug(" \u3000\u3000<<<<<< \u88c5\u63a5\u8c03\u8bd5 - \u7ed3\u675f\u5145\u7535... ");
                        }
                        String msg2Device = debugRequest.getDebugType() + "#" + Integer.parseInt(plugSn);
                        boolean r = this.ebikeChargeService.publish2device(cdi.getDeviceId(), msg2Device, debugRequest.getDebugType());
                        if (r) {
                            debugResponse.setStatus(0);
                            debugResponse.setMsg("\u4e0b\u53d1\u88c5\u63a5\u8c03\u8bd5\uff08\u7ed3\u675f\u5145\u7535\uff09\u547d\u4ee4\u6210\u529f");
                        } else {
                            debugResponse.setStatus(-1);
                            debugResponse.setMsg("\u4e0b\u53d1\u88c5\u63a5\u8c03\u8bd5\uff08\u7ed3\u675f\u5145\u7535\uff09\u547d\u4ee4\u5931\u8d25");
                        }
                    }
                } else {
                    debugResponse.setStatus(-97);
                    debugResponse.setMsg("\u65e0\u8be5\u5145\u7535\u8bbe\u5907");
                }
            } else {
                debugResponse.setStatus(-98);
                debugResponse.setMsg("\u8bf7\u6c42\u53c2\u6570\uff08\u5145\u7535\u63d2\u5ea7\u7f16\u53f7\uff09\u975e\u6cd5");
            }
        } else {
            debugResponse.setStatus(-99);
            debugResponse.setMsg("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        int insFdlResult = this.debugDao.insertFitconnDebuggingLog(debugRequest, debugResponse);
        if (insFdlResult > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" insertFitconnDebuggingLog success ");
            }
        } else {
            this.logger.warn(" insertFitconnDebuggingLog failure ");
            this.logger.warn(" debugRequest     : " + (ObjectUtils.isNotNull((Object)debugRequest) ? debugRequest.toString() : null));
            this.logger.warn(" debugResponse    : " + debugResponse.toString());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end debugging <<<<<<< ");
        }
        return debugResponse;
    }
}

