/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.bizservices.ebikemgmt.service.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.FitConnectDao;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeDeviceInfo;
import cn.yunrui.bizservices.ebikemgmt.entity.FitConnectRequest;
import cn.yunrui.bizservices.ebikemgmt.entity.FitConnectResponse;
import cn.yunrui.bizservices.ebikemgmt.service.FitConnectService;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.ChargeDeviceCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargePlugProps;
import com.ebike.openservices.devmgmt.entity.DevEbikeChargedeviceDo;
import com.ebike.openservices.devmgmt.entity.DevEbikeChargeplugDo;
import com.ebike.openservices.devmgmt.request.EbikeChargedeviceDismantleRequest;
import com.ebike.openservices.devmgmt.request.EbikeChargedeviceInstallRequest;
import com.ebike.openservices.devmgmt.response.EbikeChargedeviceDismantleResponse;
import com.ebike.openservices.devmgmt.response.EbikeChargedeviceInstallResponse;
import com.ebike.openservices.devmgmt.service.EbikeChargedeviceMgmtService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FitConnectServiceImpl
implements FitConnectService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="ebikeChargedeviceMgmtService")
    private EbikeChargedeviceMgmtService ebikeChargedeviceMgmtService;
    @Resource(name="fitConnectDao")
    private FitConnectDao fitConnectDao;
    @Resource(name="chargeDeviceCache")
    private ChargeDeviceCache chargeDeviceCache;

    public FitConnectResponse fitconnect(FitConnectRequest fitConnectRequest) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" >>>>>> \u5f00\u59cb\u88c5\u63a5\u8bbe\u5907 >>>>>> ");
            this.logger.info(" \u88c5\u63a5\u8bf7\u6c42\u53c2\u6570[FitConnectRequest] : " + JsonConvertUtils.convertToString((Object)fitConnectRequest));
        }
        FitConnectResponse res = new FitConnectResponse();
        res.setStatus(-1);
        res.setMsg("\u8be5\u5145\u7535\u8bbe\u5907\u88c5\u63a5\u5931\u8d25");
        if (fitConnectRequest != null) {
            ChargeDeviceInfo cdi = this.fitConnectDao.getChargeDeviceInfoFromAssetsRepo(fitConnectRequest.getOrgNo(), fitConnectRequest.getChargedeviceNo());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" ChargeDeviceInfo [cdi] : " + JsonConvertUtils.convertToString((Object)cdi));
            }
            if (cdi == null) {
                res.setStatus(-2);
                res.setMsg("\u8bbe\u5907\u8d44\u4ea7\u5e93\u4e2d\u65e0\u8be5\u8bbe\u5907\u6216\u4e0d\u5728\u7ba1\u8f96\u8303\u56f4\u5185");
            } else if (cdi.getChargedeviceId() != null && cdi.getChargedeviceId() > 0L) {
                res.setStatus(-3);
                res.setMsg("\u8be5\u5145\u7535\u8bbe\u5907\u5df2\u88c5\u63a5");
                res.setCdInfo(cdi);
                if (StringUtils.equals((CharSequence)"07", (CharSequence)cdi.getStatus())) {
                    EbikeChargedeviceInstallRequest installRequest = new EbikeChargedeviceInstallRequest();
                    installRequest.setChargedeviceId(cdi.getChargedeviceId());
                    installRequest.setChargedeviceNo(cdi.getChargedeviceNo());
                    installRequest.setChargedeviceName(cdi.getChargedeviceNo());
                    installRequest.setDeviceId(cdi.getDeviceId());
                    installRequest.setProtocolType(cdi.getProtocolType());
                    installRequest.setProtocolVersion(cdi.getProtocolVersion());
                    installRequest.setPlugCount(cdi.getPlugCount());
                    installRequest.setMfrCode(cdi.getChargedeviceFactory());
                    installRequest.setModelCode(cdi.getChargedeviceModelNo());
                    installRequest.setInstaller(fitConnectRequest.getOperator());
                    installRequest.setInstallRemark("\u626b\u63cf\u5b89\u88c5");
                    installRequest.setInstallType("reinstall");
                    installRequest.setOrgNo(fitConnectRequest.getOrgNo());
                    installRequest.setChargestationId(fitConnectRequest.getChargestationId());
                    EbikeChargedeviceInstallResponse installResponse = this.ebikeChargedeviceMgmtService.installEbikeChargedevice(installRequest);
                    if (installResponse.isSuccess()) {
                        this.fitConnectDao.updateDeviceAssertInfo(fitConnectRequest.getOrgNo(), fitConnectRequest.getChargedeviceNo(), "02", cdi.getChargedeviceId());
                        this.chargeDeviceCache.reload(cdi.getDeviceId());
                        res.setStatus(0);
                        res.setMsg("\u8be5\u5145\u7535\u8bbe\u5907\u91cd\u65b0\u88c5\u63a5\u6210\u529f");
                    }
                }
            } else {
                res.setStatus(-1);
                res.setMsg("\u8be5\u5145\u7535\u8bbe\u5907\u88c5\u63a5\u5931\u8d25");
                res.setCdInfo(cdi);
                try {
                    EbikeChargedeviceInstallRequest installRequest = new EbikeChargedeviceInstallRequest();
                    installRequest.setChargedeviceNo(cdi.getChargedeviceNo());
                    installRequest.setChargedeviceName(cdi.getChargedeviceNo());
                    installRequest.setDeviceId(cdi.getDeviceId());
                    installRequest.setProtocolType(cdi.getProtocolType());
                    installRequest.setProtocolVersion(cdi.getProtocolVersion());
                    installRequest.setPlugCount(cdi.getPlugCount());
                    installRequest.setMfrCode(cdi.getChargedeviceFactory());
                    installRequest.setModelCode(cdi.getChargedeviceModelNo());
                    installRequest.setInstaller(fitConnectRequest.getOperator());
                    installRequest.setInstallRemark("\u626b\u63cf\u5b89\u88c5");
                    installRequest.setInstallType("newinstall");
                    installRequest.setOrgNo(fitConnectRequest.getOrgNo());
                    installRequest.setChargestationId(fitConnectRequest.getChargestationId());
                    EbikeChargedeviceInstallResponse installResponse = this.ebikeChargedeviceMgmtService.installEbikeChargedevice(installRequest);
                    Long chargedeviceId = null;
                    Long[] chargeplugIds = null;
                    if (installResponse.isSuccess()) {
                        DevEbikeChargedeviceDo devEbikeChargedevice = installResponse.getDevEbikeChargedevice();
                        List devEbikeChargeplugList = installResponse.getDevEbikeChargeplugList();
                        chargedeviceId = devEbikeChargedevice.getId();
                        chargeplugIds = new Long[devEbikeChargedevice.getPlugCount().intValue()];
                        int i = 0;
                        for (DevEbikeChargeplugDo devEbikeChargeplug : devEbikeChargeplugList) {
                            if (i < devEbikeChargedevice.getPlugCount()) {
                                chargeplugIds[i] = devEbikeChargeplug.getId();
                            }
                            ++i;
                        }
                    }
                    if (chargedeviceId != null && chargedeviceId > 0L) {
                        this.fitConnectDao.initChargeDeviceStatus(chargedeviceId);
                        cdi.setChargedeviceId(chargedeviceId);
                        if (chargeplugIds.length > 0) {
                            this.fitConnectDao.initChargePlugStatus(chargeplugIds);
                        }
                        this.fitConnectDao.updateDeviceAssertInfo(fitConnectRequest.getOrgNo(), fitConnectRequest.getChargedeviceNo(), "02", chargedeviceId);
                        this.chargeDeviceCache.reload(cdi.getDeviceId());
                        res.setStatus(0);
                        res.setMsg("\u8be5\u5145\u7535\u8bbe\u5907\u88c5\u63a5\u6210\u529f");
                        res.setCdInfo(cdi);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e.fillInStackTrace());
                }
            }
        } else {
            res.setStatus(-99);
            res.setMsg("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" \u88c5\u63a5\u7ed3\u679c[FitConnectResponse] : " + JsonConvertUtils.convertToString((Object)res));
            this.logger.info(" <<<<<< \u7ed3\u675f\u88c5\u63a5\u8bbe\u5907 <<<<<< ");
        }
        return res;
    }

    public FitConnectResponse dismantle(FitConnectRequest fitConnectRequest) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" >>>>>> \u5f00\u59cb\u62c6\u9664\u8bbe\u5907 >>>>>> ");
            this.logger.info(" \u62c6\u9664\u8bf7\u6c42\u53c2\u6570[FitConnectRequest] : " + JsonConvertUtils.convertToString((Object)fitConnectRequest));
        }
        FitConnectResponse res = new FitConnectResponse();
        res.setStatus(-1);
        res.setMsg("\u8be5\u5145\u7535\u8bbe\u5907\u62c6\u9664\u5931\u8d25");
        if (fitConnectRequest != null) {
            ChargeDeviceInfo cdi = this.fitConnectDao.getChargeDeviceInfoFromAssetsRepo(fitConnectRequest.getOrgNo(), fitConnectRequest.getChargedeviceNo());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" ChargeDeviceInfo [cdi] : " + JsonConvertUtils.convertToString((Object)cdi));
            }
            if (cdi == null) {
                res.setStatus(-2);
                res.setMsg("\u8bbe\u5907\u8d44\u4ea7\u5e93\u4e2d\u65e0\u8be5\u8bbe\u5907\u6216\u4e0d\u5728\u7ba1\u8f96\u8303\u56f4\u5185");
            } else if (cdi.getChargedeviceId() == null) {
                res.setStatus(-4);
                res.setMsg("\u8be5\u5145\u7535\u8bbe\u5907\u672a\u88c5\u63a5");
            } else {
                res.setStatus(-1);
                res.setMsg("\u8be5\u5145\u7535\u8bbe\u5907\u62c6\u9664\u5931\u8d25");
                boolean canDismantle = true;
                ChargeDeviceProps cdp = this.chargeDeviceCache.get(cdi.getDeviceId());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" ChargeDeviceProps [cdp] : " + JsonConvertUtils.convertToString((Object)cdp));
                }
                if (ObjectUtils.isNotNull((Object)cdp)) {
                    Map plugPropsMap = cdp.getPlugPropsMap();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(" plugPropsMap  : " + JsonConvertUtils.convertToString((Object)plugPropsMap));
                    }
                    if (MapUtils.isNotEmpty((Map)plugPropsMap)) {
                        for (Integer plugSn : plugPropsMap.keySet()) {
                            ChargePlugProps cpp = (ChargePlugProps)plugPropsMap.get(plugSn);
                            if (!ObjectUtils.isNotNull((Object)cpp) || !StringUtils.equals((CharSequence)"1", (CharSequence)cpp.getOpStatus())) continue;
                            canDismantle = false;
                            break;
                        }
                    }
                    if (canDismantle) {
                        EbikeChargedeviceDismantleRequest dismantleRequest = new EbikeChargedeviceDismantleRequest();
                        dismantleRequest.setChargedeviceId(cdi.getChargedeviceId());
                        dismantleRequest.setDismantler(fitConnectRequest.getOperator());
                        dismantleRequest.setDismantleRemark("\u626b\u63cf\u62c6\u9664");
                        EbikeChargedeviceDismantleResponse dismantleResponse = this.ebikeChargedeviceMgmtService.dismantleEbikeChargedevice(dismantleRequest);
                        if (dismantleResponse.isSuccess()) {
                            this.fitConnectDao.updateDeviceAssertInfo(fitConnectRequest.getOrgNo(), fitConnectRequest.getChargedeviceNo(), "07", null);
                            this.chargeDeviceCache.remove(cdi.getDeviceId());
                            res.setStatus(0);
                            res.setMsg("\u8be5\u5145\u7535\u8bbe\u5907\u62c6\u9664\u6210\u529f");
                        }
                    } else {
                        res.setStatus(-5);
                        res.setMsg("\u8be5\u5145\u7535\u8bbe\u5907\u6709\u63d2\u5ea7\u6b63\u5728\u5145\u7535\u4e2d\uff0c\u65e0\u6cd5\u62c6\u9664");
                    }
                } else {
                    res.setStatus(-2);
                    res.setMsg("\u8bbe\u5907\u8d44\u4ea7\u5e93\u4e2d\u65e0\u8be5\u8bbe\u5907\u6216\u4e0d\u5728\u7ba1\u8f96\u8303\u56f4\u5185");
                }
            }
        } else {
            res.setStatus(-99);
            res.setMsg("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" \u62c6\u9664\u7ed3\u679c[FitConnectResponse] : " + JsonConvertUtils.convertToString((Object)res));
            this.logger.info(" <<<<<< \u7ed3\u675f\u62c6\u9664\u8bbe\u5907 <<<<<< ");
        }
        return res;
    }
}

