/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.bizservices.ebikemgmt.service.impl;

import cn.yunrui.bizservices.ebikemgmt.dao.TestDao;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeDeviceInfo;
import cn.yunrui.bizservices.ebikemgmt.entity.CustomTestRequest;
import cn.yunrui.bizservices.ebikemgmt.entity.TestRequest;
import cn.yunrui.bizservices.ebikemgmt.entity.TestResponse;
import cn.yunrui.bizservices.ebikemgmt.service.TestService;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.service.EBikeChargeService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServiceImpl
implements TestService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="testDao")
    private TestDao testDao;
    @Resource(name="ebikeChargeService")
    private EBikeChargeService ebikeChargeService;

    public TestResponse test(TestRequest testRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start test >>>>>> ");
            this.logger.debug(" TestRequest : " + (testRequest != null ? testRequest.toString() : null));
        }
        TestResponse testResponse = new TestResponse();
        testResponse.setStatus(-1);
        testResponse.setMsg("\u4e0b\u53d1\u6d4b\u8bd5\u547d\u4ee4\u5931\u8d25");
        if (testRequest != null) {
            String chargeplugNo = testRequest.getChargeplugNo();
            if (chargeplugNo != null && chargeplugNo.trim().length() >= 3) {
                String chargedeviceNo = chargeplugNo.trim().substring(0, chargeplugNo.trim().length() - 2);
                String plugSn = chargeplugNo.trim().substring(chargeplugNo.trim().length() - 2);
                ChargeDeviceInfo cdi = this.testDao.getChargeDeviceInfoFromAssetsRepo(chargedeviceNo);
                if (ObjectUtils.isNotNull((Object)cdi)) {
                    if (StringUtils.equals((CharSequence)"start", (CharSequence)testRequest.getTestType())) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(" \u5145\u7535\u8bbe\u5907\u7f16\u53f7[chargedeviceNo] : " + chargedeviceNo + " , \u5145\u7535\u63d2\u5ea7\u5e8f\u53f7[plugSn] : " + plugSn);
                            this.logger.debug(" \u3000\u3000>>>>>> \u6d4b\u8bd5 - \u5f00\u59cb\u5145\u7535... ");
                        }
                        String msg2Device = testRequest.getTestType() + "#" + Integer.parseInt(plugSn) + "#10#10";
                        boolean r = this.ebikeChargeService.publish2device(cdi.getDeviceId(), msg2Device, testRequest.getTestType());
                        if (r) {
                            testResponse.setStatus(0);
                            testResponse.setMsg("\u4e0b\u53d1\u6d4b\u8bd5\uff08\u5f00\u59cb\u5145\u7535\uff09\u547d\u4ee4\u6210\u529f");
                        } else {
                            testResponse.setStatus(-1);
                            testResponse.setMsg("\u4e0b\u53d1\u6d4b\u8bd5\uff08\u5f00\u59cb\u5145\u7535\uff09\u547d\u4ee4\u5931\u8d25");
                        }
                    } else if (StringUtils.equals((CharSequence)"stop", (CharSequence)testRequest.getTestType())) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(" \u5145\u7535\u8bbe\u5907\u7f16\u53f7[chargedeviceNo] : " + chargedeviceNo + " , \u5145\u7535\u63d2\u5ea7\u5e8f\u53f7[plugSn] : " + plugSn);
                            this.logger.debug(" \u3000\u3000<<<<<< \u6d4b\u8bd5 - \u7ed3\u675f\u5145\u7535... ");
                        }
                        String msg2Device = testRequest.getTestType() + "#" + Integer.parseInt(plugSn);
                        boolean r = this.ebikeChargeService.publish2device(cdi.getDeviceId(), msg2Device, testRequest.getTestType());
                        if (r) {
                            testResponse.setStatus(0);
                            testResponse.setMsg("\u4e0b\u53d1\u6d4b\u8bd5\uff08\u7ed3\u675f\u5145\u7535\uff09\u547d\u4ee4\u6210\u529f");
                        } else {
                            testResponse.setStatus(-1);
                            testResponse.setMsg("\u4e0b\u53d1\u6d4b\u8bd5\uff08\u7ed3\u675f\u5145\u7535\uff09\u547d\u4ee4\u5931\u8d25");
                        }
                    }
                } else {
                    testResponse.setStatus(-97);
                    testResponse.setMsg("\u65e0\u8be5\u5145\u7535\u8bbe\u5907");
                }
            } else {
                testResponse.setStatus(-98);
                testResponse.setMsg("\u8bf7\u6c42\u53c2\u6570\uff08\u5145\u7535\u63d2\u5ea7\u7f16\u53f7\uff09\u975e\u6cd5");
            }
        } else {
            testResponse.setStatus(-99);
            testResponse.setMsg("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end test <<<<<<< ");
        }
        return testResponse;
    }

    public TestResponse custom(CustomTestRequest testRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start custom test >>>>>> ");
            this.logger.debug(" CustomTestRequest : " + (testRequest != null ? testRequest.toString() : null));
        }
        TestResponse testResponse = new TestResponse();
        testResponse.setStatus(-1);
        testResponse.setMsg("\u4e0b\u53d1\u81ea\u5b9a\u4e49\u6d4b\u8bd5\u547d\u4ee4\u5931\u8d25");
        if (testRequest != null) {
            String chargedeviceNo = testRequest.getChargedeviceNo();
            if (StringUtils.isNotBlank((CharSequence)chargedeviceNo)) {
                ChargeDeviceInfo cdi = this.testDao.getChargeDeviceInfoFromAssetsRepo(chargedeviceNo);
                if (ObjectUtils.isNotNull((Object)cdi)) {
                    boolean r;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(" \u5145\u7535\u8bbe\u5907\u7f16\u53f7[chargedeviceNo] : " + chargedeviceNo);
                        this.logger.debug(" \u3000\u3000<<<<<< \u81ea\u5b9a\u4e49\u6d4b\u8bd5... ");
                    }
                    if (r = this.ebikeChargeService.publish2device(cdi.getDeviceId(), testRequest.getCustomContent(), testRequest.getTestType())) {
                        testResponse.setStatus(0);
                        testResponse.setMsg("\u4e0b\u53d1\u81ea\u5b9a\u4e49\u6d4b\u8bd5\u547d\u4ee4\u6210\u529f");
                    } else {
                        testResponse.setStatus(-1);
                        testResponse.setMsg("\u4e0b\u53d1\u81ea\u5b9a\u4e49\u6d4b\u8bd5\u547d\u4ee4\u5931\u8d25");
                    }
                } else {
                    testResponse.setStatus(-97);
                    testResponse.setMsg("\u65e0\u8be5\u5145\u7535\u8bbe\u5907");
                }
            } else {
                testResponse.setStatus(-98);
                testResponse.setMsg("\u8bf7\u6c42\u53c2\u6570\uff08\u5145\u7535\u8bbe\u5907\u7f16\u53f7\uff09\u975e\u6cd5");
            }
        } else {
            testResponse.setStatus(-99);
            testResponse.setMsg("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end custom test <<<<<<< ");
        }
        return testResponse;
    }
}

