/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.bizservices.ebikemgmt.syncevent.subscriber.impl;

import cn.cc.cisp.message.Event;
import cn.cc.cisp.message.IAppEventHandler;
import cn.cc.cisp.message.SyncEventType;
import cn.cc.cisp.message.channel.EventChannel;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeRequest;
import cn.yunrui.bizservices.ebikemgmt.entity.ChargeResponse;
import cn.yunrui.bizservices.ebikemgmt.service.ChargeService;
import cn.yunrui.bizservices.ebikemgmt.syncevent.subscriber.ChargeOrderPayResultSubscriber;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import com.ebikepay.openservices.entity.PayResultEnum;
import java.util.Date;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChargeOrderPayResultSubscriberImpl
implements ChargeOrderPayResultSubscriber {
    private static final String EVENT_TYPE = "TRADE_ORDER_PAY_RESULT_NOTIFY";
    private static final String[] BUSINESS_MODULE_EBIKE_CHARGES = new String[]{"bike_yezf", "i380v-bike", "i380v-bike-xcx", "ebike-charge"};
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="eventChannel")
    private EventChannel eventChannel;
    @Resource(name="chargeService")
    private ChargeService chargeService;

    @PostConstruct
    public void init() throws Exception {
        this.eventChannel.subscribe((IAppEventHandler)this, SyncEventType.valueOfKey((String)EVENT_TYPE));
    }

    @PreDestroy
    public void destroy() {
        this.eventChannel.unsubscribe((IAppEventHandler)this, SyncEventType.valueOfKey((String)EVENT_TYPE));
    }

    public void handleEvent(Event event) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleEvent >>>>>> ");
            this.logger.debug(" event : " + JsonConvertUtils.convertToString((Object)event));
        }
        if (SyncEventType.valueOfKey((String)EVENT_TYPE).equals(event.getEventType())) {
            String messageStr = (String)((Object)event.getClientObject());
            Map msg = (Map)JsonConvertUtils.convertFromString(Map.class, (String)messageStr);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" msg : " + JsonConvertUtils.convertToString((Object)msg));
            }
            if (msg != null) {
                String businessModule = (String)msg.get("businessModule");
                String businessId = (String)msg.get("businessId");
                String orderId = (String)msg.get("orderId");
                Integer payResult = (Integer)msg.get("payResult");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" businessModule   : " + businessModule);
                    this.logger.debug(" businessId       : " + businessId);
                    this.logger.debug(" orderId          : " + orderId);
                    this.logger.debug(" payResult        : " + payResult);
                }
                if (ArrayUtils.contains((Object[])BUSINESS_MODULE_EBIKE_CHARGES, (Object)businessModule)) {
                    if (PayResultEnum.PAY_SUCCESS.getResult().equals(payResult)) {
                        ChargeRequest chargeRequest;
                        this.chargeService.updateChargePrepayOrderLog(orderId, 0, new Date(), null);
                        if (StringUtils.isNotBlank((CharSequence)orderId) && (chargeRequest = this.chargeService.buildChargeRequestPaySuccessWithnoCharging(orderId)) != null) {
                            ChargeResponse response = this.chargeService.charge(chargeRequest);
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug(" ChargeRequest    : " + JsonConvertUtils.convertToString((Object)chargeRequest));
                                this.logger.debug(" ChargeResponse   : " + JsonConvertUtils.convertToString((Object)response));
                            }
                        }
                    } else {
                        this.chargeService.updateChargePrepayOrderLog(orderId, -1, null, payResult != null ? payResult.toString() : null);
                    }
                }
            }
        }
    }
}

