/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.bizservices.ebikemgmt.syncevent.subscriber.impl;

import cn.cc.cisp.message.Event;
import cn.cc.cisp.message.IAppEventHandler;
import cn.cc.cisp.message.SyncEventType;
import cn.cc.cisp.message.channel.EventChannel;
import cn.yunrui.bizservices.ebikemgmt.dao.ChargeDao;
import cn.yunrui.bizservices.ebikemgmt.syncevent.subscriber.ChargeOrderRefundResultSubscriber;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeRecordDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeRecord;
import com.ebikepay.openservices.entity.RefundResultEnum;
import java.util.Date;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChargeOrderRefundResultSubscriberImpl
implements ChargeOrderRefundResultSubscriber {
    private static final String EVENT_TYPE = "TRADE_ORDER_REFUND_RESULT_NOTIFY";
    private static final String[] BUSINESS_MODULE_EBIKE_CHARGES = new String[]{"i380v-bike", "ebike-charge"};
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="eventChannel")
    private EventChannel eventChannel;
    @Resource(name="chargeRecordDao")
    private ChargeRecordDao chargeRecordDao;
    @Resource(name="chargeDao")
    private ChargeDao chargeDao;

    @PostConstruct
    public void init() throws Exception {
        this.eventChannel.subscribe((IAppEventHandler)this, SyncEventType.valueOfKey((String)EVENT_TYPE));
    }

    @PreDestroy
    public void destroy() {
        this.eventChannel.unsubscribe((IAppEventHandler)this, SyncEventType.valueOfKey((String)EVENT_TYPE));
    }

    public void handleEvent(Event event) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleEvent >>>>>> ");
            this.logger.debug(" event : " + JsonConvertUtils.convertToString((Object)event));
        }
        if (SyncEventType.valueOfKey((String)EVENT_TYPE).equals(event.getEventType())) {
            String messageStr = (String)((Object)event.getClientObject());
            Map msg = (Map)JsonConvertUtils.convertFromString(Map.class, (String)messageStr);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" msg : " + JsonConvertUtils.convertToString((Object)msg));
            }
            if (msg != null) {
                String orderId = (String)msg.get("orderId");
                String orderType = (String)msg.get("orderType");
                String businessModule = (String)msg.get("businessModule");
                String businessId = (String)msg.get("businessId");
                String refundNo = (String)msg.get("refundNo");
                String refundType = (String)msg.get("refundType");
                String refundTime = (String)msg.get("refundTime");
                Integer refundResult = (Integer)msg.get("refundResult");
                String refundChannelNo = (String)msg.get("refundChannelNo");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" orderId          : " + orderId);
                    this.logger.debug(" orderType        : " + orderType);
                    this.logger.debug(" businessModule   : " + businessModule);
                    this.logger.debug(" businessId       : " + businessId);
                    this.logger.debug(" refundNo         : " + refundNo);
                    this.logger.debug(" refundType       : " + refundType);
                    this.logger.debug(" refundTime       : " + refundTime);
                    this.logger.debug(" refundResult     : " + refundResult);
                    this.logger.debug(" refundChannelNo  : " + refundChannelNo);
                }
                if (ArrayUtils.contains((Object[])BUSINESS_MODULE_EBIKE_CHARGES, (Object)businessModule)) {
                    ChargeRecord chargeRecord = this.chargeRecordDao.getHistroyChargeRecordByReturnTradeOrderId(orderId, refundNo);
                    if (chargeRecord != null) {
                        if (StringUtils.equals((CharSequence)"W", (CharSequence)chargeRecord.getReturnFlag())) {
                            if (RefundResultEnum.REFUND_SUCCESS.getResult().equals(refundResult)) {
                                chargeRecord.setReturnFlag("Y");
                                chargeRecord.setReturnSuccessTime(new Date());
                                this.chargeRecordDao.finshReturnChargeRecord(chargeRecord);
                            } else if (RefundResultEnum.REFUND_FAILURE.getResult().equals(refundResult)) {
                                chargeRecord.setReturnFlag("F");
                                this.chargeRecordDao.finshReturnChargeRecord(chargeRecord);
                            }
                        }
                    } else {
                        int res;
                        chargeRecord = this.chargeRecordDao.getHistroyChargeRecordByCsrefundTradeOrderId(orderId, refundNo);
                        if (chargeRecord != null) {
                            if (StringUtils.equals((CharSequence)"T", (CharSequence)chargeRecord.getCsrefundResult())) {
                                if (RefundResultEnum.REFUND_SUCCESS.getResult().equals(refundResult)) {
                                    chargeRecord.setCsrefundResult("S");
                                    this.chargeRecordDao.finshReturnChargeRecord(chargeRecord);
                                } else if (RefundResultEnum.REFUND_FAILURE.getResult().equals(refundResult)) {
                                    chargeRecord.setCsrefundResult("F");
                                    this.chargeRecordDao.finshReturnChargeRecord(chargeRecord);
                                }
                            }
                        } else if (RefundResultEnum.REFUND_SUCCESS.getResult().equals(refundResult)) {
                            int res2 = this.chargeDao.updateChargeRequestLogByReturnResult(orderId, refundNo, "Y", new Date());
                            if (res2 > 0 && this.logger.isInfoEnabled()) {
                                this.logger.info(" orderId   : " + orderId);
                                this.logger.info(" refundNo  : " + refundNo);
                                this.logger.info(" \u5904\u7406\u5145\u7535\u8bf7\u6c42\u5931\u8d25\u8ba2\u5355\uff0c\u9000\u6b3e\u6210\u529f\uff01");
                            }
                        } else if (RefundResultEnum.REFUND_FAILURE.getResult().equals(refundResult) && (res = this.chargeDao.updateChargeRequestLogByReturnResult(orderId, refundNo, "F", null)) > 0 && this.logger.isInfoEnabled()) {
                            this.logger.info(" orderId   : " + orderId);
                            this.logger.info(" refundNo  : " + refundNo);
                            this.logger.info(" \u5904\u7406\u5145\u7535\u8bf7\u6c42\u5931\u8d25\u8ba2\u5355\uff0c\u9000\u8d39\u5931\u8d25\uff01");
                        }
                    }
                }
            }
        }
    }
}

