/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.bizservices.ebikemgmt.utils;

import cn.yunrui.bizservices.ebikemgmt.entity.BillingSchemeInfo;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillingUtil {
    private static final Double MAX_CHARGE_EC = 9000.0;
    private static final Double MAX_CHARGE_TIME = 900.0;
    private static final Double MAX_CHARGE_TIME_2024 = 1000.0;
    private static final Double MAX_CHARGE_EC_FOR_FREE = 2000.0;
    private static final Double MAX_CHARGE_TIME_FOR_FREE = 600.0;
    private static final Logger logger = LoggerFactory.getLogger(BillingUtil.class);

    public static void main(String[] args) {
        Double chargeMoney = 1.0;
        Double price = 0.558;
        Double fee1 = 0.4;
        Double fee2 = 0.1;
        Double firstChargeAmount = chargeMoney / (price + fee1 + fee2);
        System.out.println("=================" + new BigDecimal(firstChargeAmount).setScale(2, RoundingMode.HALF_UP));
    }

    public static Map<String, Object> getChargeRecordMap(BillingSchemeInfo billingSchemeInfo, Double chargeMoney) {
        if (logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getChargeRecordMap >>>>>>> ");
            logger.debug(" billingSchemeInfo    : " + (billingSchemeInfo != null ? billingSchemeInfo.toString() : null));
            logger.debug(" chargeMoney          : " + chargeMoney);
        }
        if (billingSchemeInfo == null) {
            return null;
        }
        chargeMoney = chargeMoney != null ? chargeMoney : 0.0;
        Double coinMoney = 0.0;
        HashMap<String, Object> chargeRecordMap = new HashMap<String, Object>();
        chargeRecordMap.put("chargeMoney", chargeMoney);
        chargeRecordMap.put("coinMoney", coinMoney);
        chargeRecordMap.put("schemeId", billingSchemeInfo.getSchemeId());
        chargeRecordMap.put("schemeType", billingSchemeInfo.getSchemeType());
        Double unitPrice = billingSchemeInfo.getUnitPrice1();
        chargeRecordMap.put("unitPrice1", unitPrice);
        chargeRecordMap.put("unitPrice2", billingSchemeInfo.getUnitPrice2());
        chargeRecordMap.put("unitPrice3", billingSchemeInfo.getUnitPrice3());
        chargeRecordMap.put("unitPrice4", billingSchemeInfo.getUnitPrice4());
        chargeRecordMap.put("unitPrice5", billingSchemeInfo.getUnitPrice5());
        chargeRecordMap.put("stepCount", billingSchemeInfo.getStepCount());
        chargeRecordMap.put("stepPower1", billingSchemeInfo.getStepPower1());
        chargeRecordMap.put("stepPower2", billingSchemeInfo.getStepPower2());
        chargeRecordMap.put("stepPower3", billingSchemeInfo.getStepPower3());
        chargeRecordMap.put("stepPower4", billingSchemeInfo.getStepPower4());
        chargeRecordMap.put("minCharge", billingSchemeInfo.getMinCharge());
        chargeRecordMap.put("isReturn", billingSchemeInfo.getIsReturn());
        chargeRecordMap.put("closingPeriod", billingSchemeInfo.getClosingPeriod());
        chargeRecordMap.put("schemeDetails", billingSchemeInfo.getSchemeDetails());
        chargeRecordMap.put("chargeOpenFlag", 1);
        Integer firstUnitPriceFlag = 1;
        Double firstChargeAmount = 0.0;
        Double usageAmount = 0.0;
        Double surplusAmount = 0.0;
        Double usageElecCons = 0.0;
        if (StringUtils.equals((CharSequence)"01", (CharSequence)billingSchemeInfo.getSchemeType())) {
            firstUnitPriceFlag = 1;
            if (billingSchemeInfo.getUnitPrice1() != null && billingSchemeInfo.getUnitPrice1().compareTo(0.0) > 0) {
                firstChargeAmount = chargeMoney * billingSchemeInfo.getUnitPrice1() * 60.0;
                BigDecimal bd = new BigDecimal(firstChargeAmount);
                bd = bd.setScale(4, 4);
                firstChargeAmount = bd.doubleValue();
            } else if (billingSchemeInfo.getUnitPrice1() != null && billingSchemeInfo.getUnitPrice1().compareTo(0.0) == 0) {
                firstChargeAmount = billingSchemeInfo.getMaxChargeTime() != null && billingSchemeInfo.getMaxChargeTime() > 0 ? (double)billingSchemeInfo.getMaxChargeTime().intValue() * 1.0 : MAX_CHARGE_TIME_FOR_FREE;
            }
            surplusAmount = firstChargeAmount - usageAmount;
        } else if (StringUtils.equals((CharSequence)"02", (CharSequence)billingSchemeInfo.getSchemeType())) {
            firstUnitPriceFlag = 1;
            Double chargeServiceFee = billingSchemeInfo.getChargeServiceFee();
            Double elecLossFee = billingSchemeInfo.getElecLossFee();
            if (billingSchemeInfo.getUnitPrice1() != null && billingSchemeInfo.getUnitPrice1().compareTo(0.0) > 0) {
                firstChargeAmount = chargeMoney / (billingSchemeInfo.getUnitPrice1() + chargeServiceFee + elecLossFee);
                BigDecimal bd = new BigDecimal(firstChargeAmount);
                bd = bd.setScale(2, 4);
                firstChargeAmount = bd.doubleValue();
            } else if (billingSchemeInfo.getUnitPrice1() != null && billingSchemeInfo.getUnitPrice1().compareTo(0.0) == 0) {
                firstChargeAmount = MAX_CHARGE_EC_FOR_FREE / 1000.0;
            }
            surplusAmount = firstChargeAmount - usageAmount;
        } else if (StringUtils.equals((CharSequence)"03", (CharSequence)billingSchemeInfo.getSchemeType())) {
            firstUnitPriceFlag = 1;
            firstChargeAmount = billingSchemeInfo.getMaxChargeTime() != null && billingSchemeInfo.getMaxChargeTime() > 0 ? (double)billingSchemeInfo.getMaxChargeTime().intValue() * 1.0 : MAX_CHARGE_TIME_FOR_FREE;
            surplusAmount = firstChargeAmount - usageAmount;
            if (logger.isDebugEnabled()) {
                logger.debug(" firstUnitPriceFlag   : " + firstUnitPriceFlag);
                logger.debug(" firstChargeAmount    : " + firstChargeAmount);
                logger.debug(" surplusAmount        : " + surplusAmount);
            }
        } else if (StringUtils.equals((CharSequence)"05", (CharSequence)billingSchemeInfo.getSchemeType())) {
            Double elecCost = billingSchemeInfo.getElecCost();
            chargeRecordMap.put("unitPrice1", elecCost);
            chargeRecordMap.put("unitPrice2", billingSchemeInfo.getUnitPrice1());
            chargeRecordMap.put("unitPrice3", billingSchemeInfo.getUnitPrice2());
            chargeRecordMap.put("unitPrice4", billingSchemeInfo.getUnitPrice3());
            chargeRecordMap.put("unitPrice5", billingSchemeInfo.getUnitPrice4());
            firstUnitPriceFlag = 1;
            JSONObject billingSchemeDetails = JSONObject.fromObject((Object)billingSchemeInfo.getSchemeDetails());
            if (ObjectUtils.isNotEmpty((Object)billingSchemeInfo.getStepPower1()) && ObjectUtils.isNotEmpty((Object)billingSchemeInfo.getUnitPrice1())) {
                double elecCostAdd = billingSchemeInfo.getUnitPrice1() / ((double)billingSchemeInfo.getStepPower1().intValue() * 0.001);
                elecCostAdd = new BigDecimal(elecCostAdd).setScale(2, 4).doubleValue();
                elecCost = elecCost + elecCostAdd;
                billingSchemeDetails.put((Object)"charge_service_fee", (Object)elecCostAdd);
            }
            firstChargeAmount = chargeMoney / elecCost;
            BigDecimal bd = new BigDecimal(firstChargeAmount);
            bd = bd.setScale(2, 4);
            firstChargeAmount = bd.doubleValue();
            surplusAmount = firstChargeAmount - usageAmount;
            chargeRecordMap.put("schemeDetails", String.valueOf(billingSchemeDetails));
        }
        chargeRecordMap.put("firstUnitPriceFlag", firstUnitPriceFlag);
        chargeRecordMap.put("firstChargeAmount", firstChargeAmount);
        chargeRecordMap.put("currUnitPriceFlag", firstUnitPriceFlag);
        chargeRecordMap.put("chargeAmount", firstChargeAmount);
        chargeRecordMap.put("usageAmount", usageAmount);
        chargeRecordMap.put("surplusAmount", surplusAmount);
        chargeRecordMap.put("usageElecCons", usageElecCons);
        if (StringUtils.equals((CharSequence)"02", (CharSequence)billingSchemeInfo.getSchemeType()) || StringUtils.equals((CharSequence)"05", (CharSequence)billingSchemeInfo.getSchemeType())) {
            chargeRecordMap.put("remainElecCons", firstChargeAmount);
            chargeRecordMap.put("remainTime", MAX_CHARGE_TIME_2024);
        } else {
            chargeRecordMap.put("remainElecCons", MAX_CHARGE_EC / 1000.0);
            if (firstChargeAmount > 999.0) {
                firstChargeAmount = 999.0;
            }
            chargeRecordMap.put("remainTime", firstChargeAmount);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" chargeRecordMap      : " + JsonConvertUtils.convertToString(chargeRecordMap));
        }
        return chargeRecordMap;
    }
}

