package cn.yunrui.mqttclient.ebikesrv.common.utils;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.util.Date;

/**
 *
 */
public class DateUtils extends org.apache.commons.lang3.time.DateUtils {

    private final static Logger logger = LoggerFactory.getLogger(DateUtils.class);

    public final static String[] PATTERNS_DATE = new String[] {"yyyy-MM-dd", "yyyy/MM/dd", "yyyyMMdd"};
    public final static String[] PATTERNS_MONTH = new String[] {"yyyy-MM", "yyyy/MM", "yyyyMM"};
    public final static String[] PATTERNS_YEAR = new String[] {"yyyy"};
    public final static String PATTERN_DATE = "yyyyMMdd";
    public final static String PATTERN_MONTH = "yyyyMM";
    public final static String PATTERN_YEAR = "yyyy";

    public static boolean isToday(final String date) {
        try {
            return isSameDay(DateUtils.parseDate(date, PATTERNS_DATE), new Date());
        }
        catch(ParseException _pe) {
            logger.error(_pe.getMessage(), _pe.fillInStackTrace());
            return false;
        }
    }

    public static Date getYesterday() {
        return addDays(new Date(), -1);
    }

    public static String convertToString(Date date, String pattern) {
        return new DateTime(date).toString(pattern);
    }

    public static Date convertFromString(String str, String pattern) {
        Date date = null;
        try {
            date = DateTime.parse(str, DateTimeFormat.forPattern(pattern)).toDate();
        }
        catch(Exception _e) {
            date = null;
        }
        return date;
    }

    public static Date convertFromString(String str, String[] patterns) {
        if(patterns != null) {
            for(String pattern : patterns) {
                Date date = convertFromString(str, pattern);
                if(date != null) {
                    return date;
                }
            }
        }
        return null;
    }

    public static Date addYears(Date date, int years) {
        return new DateTime(date).plusYears(years).toDate();
    }

    public static Date addMonths(Date date, int months) {
        return new DateTime(date).plusMonths(months).toDate();
    }

    public static Date addWeeks(Date date, int weeks) {
        return new DateTime(date).plusWeeks(weeks).toDate();
    }

    public static Date addDays(Date date, int days) {
        return new DateTime(date).plusDays(days).toDate();
    }

    public static Date addHours(Date date, int hours) {
        return new DateTime(date).plusHours(hours).toDate();
    }

    public static Date addMinutes(Date date, int minutes) {
        return new DateTime(date).plusMinutes(minutes).toDate();
    }

    public static Date addSeconds(Date date, int seconds) {
        return new DateTime(date).plusSeconds(seconds).toDate();
    }

    public static Date addMillis(Date date, int millis) {
        return new DateTime(date).plusMillis(millis).toDate();
    }

    public static boolean isSameYear(Date d1, Date d2) {
        return d1 != null && d2 != null && convertToString(d1, "yyyy").equals(convertToString(d2, "yyyy"));
    }

    public static boolean isSameMonth(Date d1, Date d2) {
        return d1 != null && d2 != null && convertToString(d1, "yyyyMM").equals(convertToString(d2, "yyyyMM"));
    }

    public static boolean isSameDate(Date d1, Date d2) {
        return d1 != null && d2 != null && convertToString(d1, "yyyyMMdd").equals(convertToString(d2, "yyyyMMdd"));
    }

}
