package cn.yunrui.mqttclient.ebikesrv.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 */
public class IntegerUtils {

    private final static Logger logger = LoggerFactory.getLogger(IntegerUtils.class);

    public static Integer defaultIfNull(Integer value, Integer defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static Integer defaultIfNegValue(Integer value, Integer defaultValue, Integer nullDefaultValue) {
        return value != null ? (value.compareTo(0) >= 0 ? value : defaultValue) : nullDefaultValue;
    }

    public static Integer parseIntIgnoreIllegal(String s) {
        int i = 0;
        try {
            i = Integer.parseInt(s);
        }
        catch(NumberFormatException _nfe) {
            logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
        }
        return i;
    }

}
