package cn.yunrui.mqttclient.ebikesrv.handletask;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.FitconnDebuggingCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

/**
 * 装接调试超时处理任务
 */
public class FitconnDebuggingTimeoutHandleTask {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private final static int INTERVAL_WAIT = 30;                                                            // 单位：秒

    private Thread fitconnDebuggingTimeoutHandleThread;

    @Resource(name = "fitconnDebuggingCache")
    private FitconnDebuggingCache fitconnDebuggingCache;

    /**
     * 初始化
     */
    @PostConstruct
    public void init() {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start init FitconnDebuggingTimeoutHandleTask >>>>>> ");
        }
        fitconnDebuggingTimeoutHandleThread = new FitconnDebuggingTimeoutHandleThread();
        fitconnDebuggingTimeoutHandleThread.setDaemon(true);
        fitconnDebuggingTimeoutHandleThread.start();
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end init FitconnDebuggingTimeoutHandleTask <<<<<<< ");
        }
    }

    /**
     * 销毁
     */
    @PreDestroy
    public void destroy() {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start destroy FitconnDebuggingTimeoutHandleTask >>>>>> ");
        }
        if(fitconnDebuggingTimeoutHandleThread != null) {
            try {
                fitconnDebuggingTimeoutHandleThread.join();
            }
            catch(InterruptedException _ie) {
                logger.error(_ie.getMessage(), _ie.fillInStackTrace());
            }
        }
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end destroy FitconnDebuggingTimeoutHandleTask <<<<<<< ");
        }
    }

    /**
     * 开始充电等待超时扫描线程
     */
    private class FitconnDebuggingTimeoutHandleThread extends Thread {

        @Override
        public void run() {
            while(true) {
                try {
                    fitconnDebuggingCache.finishTimeoutFitconnDebuggingLog();
                    TimeUnit.SECONDS.sleep(INTERVAL_WAIT);
                }
                catch(InterruptedException _ie) {
                    logger.error(_ie.getMessage(), _ie.fillInStackTrace());
                    break;
                }
            }
        }

    }

}
