package cn.yunrui.mqttclient.ebikesrv.mqttclient.cache;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.FitconnDebuggingDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.FitconnDebugging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * 装接调试缓存（正在调试）
 */
public class FitconnDebuggingCache {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private Map<String, FitconnDebugging> fitconnDebuggingMap = new HashMap<>();        // <deviceId>_<plugId>  , FitconnDebugging

    @Resource(name = "fitconnDebuggingDao")
    private FitconnDebuggingDao fitconnDebuggingDao;

    /**
     * 初始化
     */
    @PostConstruct
    public void init() {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start init FitconnDebuggingCache >>>>>> ");
        }

        fitconnDebuggingMap.clear();

        // TODO 加载正在调试装接调试列表
        /*List<ChargeRecord> chargeRecordList = chargeRecordDao.getBeChargingRecordList();
        if(CollectionUtils.isNotEmpty(chargeRecordList)) {
            for(ChargeRecord chargeRecord : chargeRecordList) {
                if(logger.isDebugEnabled()) {
                    if(logger.isDebugEnabled()) {
                        logger.debug(" put [ " + chargeRecord.getDeviceId() + "_" + chargeRecord.getPlugId() + " ] to cache : " + chargeRecord.toString());
                    }
                }
                chargeRecordMap.put(chargeRecord.getDeviceId() + "_" + chargeRecord.getPlugId(), chargeRecord);
            }
        }*/

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end init FitconnDebuggingCache <<<<<<< ");
        }
    }

    /**
     * 销毁
     */
    @PreDestroy
    public void destroy() {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start destroy FitconnDebuggingCache >>>>>> ");
        }

        fitconnDebuggingMap.clear();

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end destroy FitconnDebuggingCache <<<<<<< ");
        }
    }

    /**
     * 更新装接调试日志记录
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param plugId
     *              插座通讯标识（MQTT规约中定义的plugId）
     * @param valueMap
     *              更新装接调试日志记录值集合
     */
    public void updateFitconnDebuggingLog(String deviceId, String plugId, Map<String, Object> valueMap) {
        fitconnDebuggingDao.updateFitconnDebuggingLog(deviceId, plugId, valueMap);
    }

    /**
     * 结束装接调试日志记录
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param plugId
     *              插座通讯标识（MQTT规约中定义的plugId）
     * @param valueMap
     *              结束装接调试日志记录值集合
     */
    public void finishFitconnDebuggingLog(String deviceId, String plugId, Map<String, Object> valueMap) {
        fitconnDebuggingDao.finishFitconnDebuggingLog(deviceId, plugId, valueMap);
    }

    /**
     * 结束超时装接调试日志记录
     */
    public void finishTimeoutFitconnDebuggingLog() {
        fitconnDebuggingDao.finishTimeoutFitconnDebuggingLog();
    }

    /**
     * 检查是否装接调试中
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param plugId
     *              插座通讯标识（MQTT规约中定义的plugId）
     * @return true : 正在装接调试中；false : 不在装接调试中
     */
    public boolean checkIsDebugging(String deviceId, String plugId) {
        return fitconnDebuggingDao.checkIsDebugging(deviceId, plugId);
    }

}
