package cn.yunrui.mqttclient.ebikesrv.mqttclient.cache;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.OpsWorkOrderDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.OpsWorkOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 运维告警工单缓存（当前运维告警工单）
 */
public class OpsWorkOrderCache {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource(name = "opsWorkOrderDao")
    private OpsWorkOrderDao opsWorkOrderDao;

    /**
     * 初始化
     */
    @PostConstruct
    public void init() {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start init OpsWorkOrderCache >>>>>> ");
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end init ChargeRecordCache <<<<<<< ");
        }
    }

    /**
     * 销毁
     */
    @PreDestroy
    public void destroy() {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start destroy ChargeRecordCache >>>>>> ");
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end destroy ChargeRecordCache <<<<<<< ");
        }
    }

    public void createOpsWorkOrder(OpsWorkOrder opsWorkOrder) {
        opsWorkOrderDao.createOpsWorkOrder(opsWorkOrder);
    }

    public void recoveryOpsWorkOrder(OpsWorkOrder opsWorkOrder) {
        opsWorkOrderDao.recoveryOpsWorkOrder(opsWorkOrder);
    }

    public void archiveOpsWorkOrder(OpsWorkOrder opsWorkOrder, Map<String, Object> archiveMap) {
        opsWorkOrderDao.archiveOpsWorkOrder(opsWorkOrder, archiveMap);
    }

    public List<OpsWorkOrder> getOpsWorkOrderList(String deviceId, String plugId, String opsworkorderType, String isRecovery) {
        return opsWorkOrderDao.getOpsWorkOrderList(deviceId, plugId, opsworkorderType, isRecovery);
    }

}
