package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-15
 *
 */
public interface ChargeCardDao {

    /**
     * 通过充电卡号获取充电卡状态
     * @param cardId
     *          充电卡号
     * @return  充电卡状态
     */
    String getStatusByCardId(String cardId);

    /**
     * 通过充电卡号获取充电卡类型
     * @param cardId
     *          充电卡号
     * @return  充电卡类型
     */
    Integer getCardTypeByCardId(String cardId);

    /**
     * 通过充电卡号获取运营商编号
     * @param cardId
     *          充电卡号
     * @return  运营商编号
     */
    String getOrgNoByCustCardId(String cardId);

    /**
     * 通过充电卡号获取充电用户标识
     * @param cardId
     *          充电卡号
     * @return  充电用户标识
     */
    String getChargeUserIdByCardId(String cardId);

}
