package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.*;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 *
 */
public interface ChargeDeviceDao {

    /**
     * 获取超时充电设备工况信息
     * @return 超时充电设备工况信息
     */
    List<ChargeDeviceOps> getTimeoutChargeDeviceOpsList();

    /**
     * 锁定超时充电设备工况信息
     * @param cdoList
     *              超时充电设备属性列表
     */
    void lockTimeoutChargeDeviceOpsList(List<ChargeDeviceOps> cdoList);

    /**
     * 获取所有充电设备属性列表
     * @return 所有充电设备属性列表
     */
    List<ChargeDeviceProps> getAllChargeDevicePropsList();

    /**
     * 获取新更新设备通讯标识列表
     * @param lastLoadTime
     *              上次加载时间
     * @return 取新更新设备通讯标识列表
     */
    List<String> getNewUpdatedDeviceIds(Date lastLoadTime);

    /**
     * 获取充电设备属性列表
     * @param paramsList
     *              查询条件Map
     * @param ordersList
     *              排序
     * @return 充电设备属性列表
     */
    List<ChargeDeviceProps> getChargeDevicePropsList(Map<String, Object> paramsList, List<String> ordersList);

    /**
     * 通过设备通讯标识获取充电设备属性
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @return 充电设备属性
     */
    ChargeDeviceProps getChargeDeviceProps(String deviceId);

    /**
     * 通过充电设备编号获取充电设备属性
     * @param orgNo
     *              单位编号
     * @param chargedeviceNo
     *              充电设备编号
     * @return 充电设备属性
     */
    ChargeDeviceProps getChargeDevicePropsByChargedeviceNo(String orgNo, String chargedeviceNo);

    /**
     * 通过设备通讯标识获取充电插座属性列表
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @return 充电插座属性列表
     */
    List<ChargePlugProps> getChargePlugPropsList(String deviceId);

    /**
     * 通过设备通讯标识和插座通讯标识获取充电插座属性
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param plugId
     *              插座通讯标识（MQTT规约中定义的plugId）
     * @return 充电插座属性
     */
    ChargePlugProps getChargePlugProps(String deviceId, String plugId);

    /**
     * 通过充电设备编号和插座序号获取充电插座属性
     * @param orgNo
     *              单位编号
     * @param chargedeviceNo
     *              充电设备编号
     * @param plugSn
     *              插座序号
     * @return 充电插座属性
     */
    ChargePlugProps getChargePlugPropsByChargedeviceNo(String orgNo, String chargedeviceNo, Integer plugSn);

    /**
     * 更新运行状态（包括充电设备及充电插座）
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param status
     *              设备运行状态
     * @param plugStatus
     *              插座运行状态
     */
    void updateOpStatus(String deviceId, String status, String[] plugStatus);

    /**
     * 更新插座运行状态
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param plugId
     *              插座通讯标识（MQTT规约中定义的plugId）
     * @param status
     *              插座运行状态
     */
    void updatePlugStatus(String deviceId, String plugId, String status);

    /**
     * 更新设备资产状态
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param status
     *              设备资产状态：00 - 库存；02 - 已装（待运行）；03 - 运行；07 - 拆除；10 - 检测；
     */
    void updateDeviceAssertStatus(String deviceId, String status);

    BillingInfo getBillingInfoByDeviceId(String deviceId, String chargeUserId, String cardId);

    int getCountByDeviceIdAndCardId(String deviceId, String cardId);

    Double getServiceRateByDeviceId(String deviceId);

    CostInfo getCostInfoByDeviceId(String deviceId);

}
