package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeRecord;

import java.util.List;
import java.util.Map;

/**
 *
 */
public interface ChargeRecordDao {

    /**
     * 检查是否充电中
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param plugId
     *              插座通讯标识（MQTT规约中定义的plugId）
     * @return true : 正在充电中；false : 不在充电中
     */
    boolean checkIsCharging(String deviceId, String plugId);

    /**
     * 获取结算标记
     * @param chargeRecordId
     *              充电记录标识
     * @param setHandlingFlag
     *              是否设置处理中标志
     * @return 结算标记
     */
    String getClosingFlag(String chargeRecordId, boolean setHandlingFlag);

    /**
     * 获取退费标记
     * @param chargeRecordId
     *              充电记录标识
     * @param setHandlingFlag
     *              是否设置处理中标志
     * @return 退费标记
     */
    String getReturnFlag(String chargeRecordId, boolean setHandlingFlag);

    /**
     * 获取充电记录
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param plugId
     *              插座通讯标识（MQTT规约中定义的plugId）
     * @return
     *              充电记录
     */
    Map<String, Object> getChargeRecordMap(String deviceId, String plugId);

    /**
     * 获取等待超时充电记录列表
     * @return 充电记录
     */
    List<ChargeRecord> getWaitingStartTimeoutChargeRecordList();

    /**
     * 获取结束超时充电记录列表
     * @return 充电记录列表
     */
    List<ChargeRecord> getWaitingStopTimeoutChargeRecordList();

    void lockWaitingTimeoutChargeRecordList(List<ChargeRecord> chargeRecordList);

    /**
     * 插入充电记录（投币）
     * @param chargeRecordMap
     *              充电记录
     * @return 大于0表示插入成功
     */
    int insertChargeRecordByCoinsin(Map<String, Object> chargeRecordMap, String chargeplugNo);

    /**
     * 插入充电记录（平台通用充电卡）
     * @param chargeRecordMap
     *              充电记录
     * @return 大于0表示插入成功
     */
    int insertChargeRecordByCard(Map<String, Object> chargeRecordMap, String chargeplugNo, String cardId);

    /**
     * 插入充电记录（运营商定制充电卡）
     * @param chargeRecordMap
     *              充电记录
     * @return 大于0表示插入成功
     */
    int insertChargeRecordByCustCard(Map<String, Object> chargeRecordMap, String chargeplugNo, String cardId);

    /**
     * 更新充电记录
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param plugId
     *              插座通讯标识（MQTT规约中定义的plugId）
     * @param valueMap
     *              更新充电记录值集合
     */
    void updateChargeRecord(String deviceId, String plugId, Map<String, Object> valueMap);

    /**
     * 结束充电
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param plugId
     *              插座通讯标识（MQTT规约中定义的plugId）
     * @param valueMap
     *              结束充电记录值集合
     */
    void finishChargeRecord(String deviceId, String plugId, Map<String, Object> valueMap);

    /**
     * 获取未结算充电记录列表
     * @return 未结算充电记录列表
     */
    List<ChargeRecord> getNotClosingChargeRecordList();

    /**
     * 锁定未结算充电记录列表
     * @param chargeRecordList 未结算充电记录列表
     */
    void lockNotClosingChargeRecordList(List<ChargeRecord> chargeRecordList);

    /**
     * 完成结算充电记录
     * @param chargeRecord 充电记录
     */
    void finshClosingChargeRecord(ChargeRecord chargeRecord);

    /**
     * 获取未退费充电记录列表
     * @return 未退费充电记录列表
     */
    List<ChargeRecord> getNotReturnChargeRecordList();

    /**
     * 锁定未退费充电记录列表
     * @param chargeRecordList 未退费充电记录列表
     */
    void lockNotReturnChargeRecordList(List<ChargeRecord> chargeRecordList);

    /**
     * 完成退费充电记录
     * @param chargeRecord 充电记录
     */
    void finshReturnChargeRecord(ChargeRecord chargeRecord);

    String getCsrefundResult(String chargeRecordId, boolean setHandlingResult);

    String getCscReturnHandleResult(ChargeRecord chargeRecord);

    List<ChargeRecord> getWaitingCsrefundChargeRecordList();

    void lockWaitingCsrefundChargeRecordList(List<ChargeRecord> chargeRecordList);

    void finshCsrefundChargeRecord(ChargeRecord chargeRecord);

    List<ChargeRecord> getBeReopeningChargeRecordList();

    void lockBeReopeningChargeRecordList(List<ChargeRecord> chargeRecordList);

    /**
     *
     * @param chargeRecordId
     *                  充电记录标识
     * @return 充电记录实体
     */
    ChargeRecord getBeChargingRecord(String chargeRecordId);

    /**
     *
     * @param chargeRecordId
     *                  充电记录标识
     * @return 充电记录实体
     */
    ChargeRecord getHistroyChargeRecord(String chargeRecordId);

    /**
     *
     * @param chargeTradeOrderId
     *                  充电交易订单标识
     * @return 充电记录实体
     */
    ChargeRecord getHistroyChargeRecordByTradeOrderId(String chargeTradeOrderId);

    /**
     *
     * @param chargeTradeOrderId
     *                  充电交易订单标识
     * @param returnTradeOrderId
     *                  退费退款单号
     * @return 充电记录实体
     */
    ChargeRecord getHistroyChargeRecordByReturnTradeOrderId(String chargeTradeOrderId, String returnTradeOrderId);

    /**
     *
     * @param chargeTradeOrderId
     *                  充电交易订单标识
     * @param csrefundTradeOrderId
     *                  退款申请服务费退款单号
     * @return 充电记录实体
     */
    ChargeRecord getHistroyChargeRecordByCsrefundTradeOrderId(String chargeTradeOrderId, String csrefundTradeOrderId);

    /**
     *
     * @return 充电记录实体列表
     */
    List<ChargeRecord> getBeChargingRecordList();

    /**
     *
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param plugId
     *              插座通讯标识（MQTT规约中定义的plugId）
     * @return 充电记录实体
     */
    ChargeRecord getBeChargingRecordByDeviceIdAndPlugId(String deviceId, String plugId);

}
