package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao;

import java.util.Map;

/**
 *
 */
public interface FitconnDebuggingDao {

    /**
     * 检查是否装接调试中
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param plugId
     *              插座通讯标识（MQTT规约中定义的plugId）
     * @return true : 正在装接调试中；false : 不在装接调试中
     */
    boolean checkIsDebugging(String deviceId, String plugId);

    /**
     * 更新装接调试日志记录
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param plugId
     *              插座通讯标识（MQTT规约中定义的plugId）
     * @param valueMap
     *              更新装接调试日志记录值集合
     */
    void updateFitconnDebuggingLog(String deviceId, String plugId, Map<String, Object> valueMap);

    /**
     * 结束装接调试日志记录
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param plugId
     *              插座通讯标识（MQTT规约中定义的plugId）
     * @param valueMap
     *              结束装接调试日志记录值集合
     */
    void finishFitconnDebuggingLog(String deviceId, String plugId, Map<String, Object> valueMap);

    /**
     * 结束超时装接调试日志记录
     */
    void finishTimeoutFitconnDebuggingLog();

}
