package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MqttMsgLog;
import org.eclipse.paho.client.mqttv3.MqttMessage;

/**
 *
 */
public interface MqttMsgLogDao {

    /**
     * 插入MQTT消息日志
     * @param mqttMsgLog
     *              MQTT消息日志
     */
    void insertMqttMsgLog(MqttMsgLog mqttMsgLog);

    /**
     * 插入MQTT消息日志
     * @param topic
     *              MQTT消息主题
     * @param mqttMessage
     *              MQTT消息
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param type
     *              类型：start - 开始充电命令；stop - 结束充电命令；status - 设备各插座的状态的查询；param - 设备参数查询请求；cardBalance - 查询卡片余额请求；cardCharge - 卡充电请求；attachParam - 设备附加参数请求；
     * @param direction
     *              方向：up - 设备到服务器；down - 服务器到设备；
     * @param action
     *              动作：request - 请求；response - 回应；
     */
    void insertMqttMsgLog(String topic, MqttMessage mqttMessage, String deviceId, String type, String direction, String action);

    /**
     * 插入检测MQTT消息日志
     * @param mqttMsgLog
     *              MQTT消息日志
     */
    void insertTestingMqttMsgLog(MqttMsgLog mqttMsgLog);

    /**
     * 插入检测MQTT消息日志
     * @param topic
     *              MQTT消息主题
     * @param mqttMessage
     *              MQTT消息
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @param type
     *              类型：start - 开始充电命令；stop - 结束充电命令；status - 设备各插座的状态的查询；param - 设备参数查询请求；cardBalance - 查询卡片余额请求；cardCharge - 卡充电请求；attachParam - 设备附加参数请求；
     * @param direction
     *              方向：up - 设备到服务器；down - 服务器到设备；
     * @param action
     *              动作：request - 请求；response - 回应；
     */
    void insertTestingMqttMsgLog(String topic, MqttMessage mqttMessage, String deviceId, String type, String direction, String action);


}
