package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.TestingChargeDevice;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.TestingChargePlug;

import java.util.List;

/**
 *
 */
public interface TestingDao {

    /**
     * 通过设备通讯标识获取检测充电设备
     * @param deviceId
     *              设备通讯标识（MQTT规约中定义的deviceId）
     * @return 检测充电设备
     */
    TestingChargeDevice getTestingChargeDeviceByDeviceId(String deviceId);

    /**
     * 通过充电设备编号获取检测充电设备
     * @param chargedeviceNo
     *              充电设备编号（二维码编号）
     * @return 检测充电设备
     */
    TestingChargeDevice getTestingChargeDeviceByChargedeviceNo(String chargedeviceNo);

    /**
     * 插入检测充电设备
     * @param testingChargeDevice
     *              检测充电设备
     */
    void insertTestingChargeDevice(TestingChargeDevice testingChargeDevice);

    /**
     * 更新检测充电设备
     * @param testingChargeDevice
     *              检测充电设备
     */
    void updateTestingChargeDevice(TestingChargeDevice testingChargeDevice);

    /**
     * 通过设备通讯标识获取检测充电插座列表
     * @param deviceId
     *              设备通讯标识
     * @return 检测充电插座列表
     */
    List<TestingChargePlug> getTestingChargePlugListByDeviceId(String deviceId);

    /**
     * 通过充电设备编号获取检测充电插座列表
     * @param chargedeviceNo
     *              充电设备编号（二维码编号）
     * @return 检测充电插座列表
     */
    List<TestingChargePlug> getTestingChargePlugListByChargedeviceNo(String chargedeviceNo);

    /**
     * 通过设备通讯标识和插座序号获取检测充电插座
     * @param deviceId
     *              设备通讯标识
     * @param plugSn
     *              插座序号
     * @return 检测充电插座
     */
    TestingChargePlug getTestingChargePlugByDeviceIdAndPlugSn(String deviceId, Integer plugSn);

    /**
     * 通过充电设备编号和插座序号获取检测充电插座
     * @param chargedeviceNo
     *              充电设备编号（二维码编号）
     * @param plugSn
     *              插座序号
     * @return 检测充电插座
     */
    TestingChargePlug getTestingChargePlugByChargedeviceNoAndPlugSn(String chargedeviceNo, Integer plugSn);

    /**
     * 更新检测充电插座
     * @param testingChargePlug
     *              检测充电插座
     */
    void updateTestingChargePlug(TestingChargePlug testingChargePlug);

}
