package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.impl;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeCardDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-15
 *
 */
public class ChargeCardDaoImpl implements ChargeCardDao {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final JdbcTemplate ebikeJdbcTemplate;

    public ChargeCardDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public String getStatusByCardId(String cardId) {
        String sql = "SELECT `status` FROM ebike.card_info WHERE card_id = ? ";
        String status;
        try {
            status = ebikeJdbcTemplate.queryForObject(sql, new Object[] {cardId}, String.class);
        }
        catch(EmptyResultDataAccessException erdae) {
            status = null;
        }
        return status;
    }

    @Override
    public Integer getCardTypeByCardId(String cardId) {
        String sql = "SELECT `card_type` FROM ebike.card_info WHERE card_id = ? ";
        Integer cardType;
        try {
            cardType = ebikeJdbcTemplate.queryForObject(sql, new Object[] {cardId}, Integer.class);
        }
        catch(EmptyResultDataAccessException erdae) {
            cardType = null;
        }
        return cardType;
    }

    @Override
    public String getOrgNoByCustCardId(String cardId) {
        String sql = "SELECT `org_no` FROM ebike.card_info WHERE card_id = ? ";
        String orgNo;
        try {
            orgNo = ebikeJdbcTemplate.queryForObject(sql, new Object[] {cardId}, String.class);
        }
        catch(EmptyResultDataAccessException erdae) {
            orgNo = null;
        }
        return orgNo;
    }

    @Override
    public String getChargeUserIdByCardId(String cardId) {
        String sql = "SELECT cu.chargeUserId FROM ebike.card_info ci, ebike.ebike_chargeuser cu WHERE cu.chargeUserNo = ci.charge_user_no AND ci.card_id = ? LIMIT 1 ";
        String charcgeUserId;
        try {
            charcgeUserId = ebikeJdbcTemplate.queryForObject(sql, new Object[] {cardId}, String.class);
        }
        catch(EmptyResultDataAccessException erdae) {
            charcgeUserId = null;
        }
        return charcgeUserId;
    }

}
