package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeLoadDao;
import cn.yunrui.mqttclient.ebikesrv.tablestore.TableStoreTemplate;
import com.alicloud.openservices.tablestore.model.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

public class ChargeLoadDaoImpl implements ChargeLoadDao {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final JdbcTemplate ebikeJdbcTemplate;
    private final TableStoreTemplate ebikeTableStoreTemplate;

    public ChargeLoadDaoImpl(JdbcTemplate ebikeJdbcTemplate, TableStoreTemplate ebikeTableStoreTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
        this.ebikeTableStoreTemplate = ebikeTableStoreTemplate;
    }

    @Override
    public void saveChargedeviceLoadMap(Map<String, Object> chargedeviceLoadMap) {
//        if(logger.isInfoEnabled()) {
//            logger.info(" >>>>>>> saveChargedeviceLoadMap >>>>>>> ");
//            logger.info(" chargedeviceLoadMap  : " + JsonConvertUtils.convertToString(chargedeviceLoadMap));
//        }
        long timestamp = new Date().getTime();
        // 构造主键
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("CHGDEVICENO", PrimaryKeyValue.fromString((String) chargedeviceLoadMap.get("CHGDEVICENO")));    // 分片键
        primaryKeyBuilder.addPrimaryKeyColumn("LOADTIME", PrimaryKeyValue.fromString((String) chargedeviceLoadMap.get("LOADTIME")));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowPutChange rowPutChange = new RowPutChange("LOAD_CHG_DEVICE", primaryKey);
        //加入一些属性列
        rowPutChange.addColumn(new Column("DEVICEID", ColumnValue.fromString((String) chargedeviceLoadMap.get("DEVICEID")), timestamp));
        rowPutChange.addColumn(new Column("PLUG_COUNT", ColumnValue.fromLong((Integer) chargedeviceLoadMap.get("PLUG_COUNT")), timestamp));
        rowPutChange.addColumn(new Column("SUM_LOADVALUE", ColumnValue.fromDouble((Double) chargedeviceLoadMap.get("SUM_LOADVALUE")), timestamp));
        Integer plugCount = (Integer) chargedeviceLoadMap.get("PLUG_COUNT");
        if(plugCount != null && plugCount > 0) {
            for(int i = 1; i <= plugCount && i < 100; i++) {
                rowPutChange.addColumn(new Column("P" + String.format("%02d", i) + "_LOADVALUE", ColumnValue.fromDouble((Double) chargedeviceLoadMap.get("P" + String.format("%02d", i) + "_LOADVALUE")), timestamp));
            }
        }
        PutRowRequest putRowRequest = new PutRowRequest(rowPutChange);
        ebikeTableStoreTemplate.putRowSync(putRowRequest);

        BigDecimal curPower = new BigDecimal(chargedeviceLoadMap.get("SUM_LOADVALUE") != null ? chargedeviceLoadMap.get("SUM_LOADVALUE").toString() : "0.0");
        Date curPowerTime = new Date();
        Long chargedeviceId = (Long) chargedeviceLoadMap.get("CHGDEVICEID");
//        if(logger.isInfoEnabled()) {
//            logger.info("curPower           : " + curPower);
//            logger.info("curPowerTime       : " + curPowerTime);
//            logger.info("chargedeviceId     : " + chargedeviceId);
//        }
        String sql = "UPDATE ebike.ebike_chargedevice_ops SET curPower = ?, curPowerTime = ? WHERE chargedeviceId = ? ";
        ebikeJdbcTemplate.update(sql, curPower, curPowerTime, chargedeviceId);
    }

    @Override
    public void saveChargeplugLoadMap(Map<String, Object> chargeplugLoadMap) {
//        if(logger.isInfoEnabled()) {
//            logger.info(" >>>>>>> saveChargeplugLoadMap >>>>>>> ");
//            logger.info(" chargeplugLoadMap    : " + JsonConvertUtils.convertToString(chargeplugLoadMap));
//        }
        long timestamp = new Date().getTime();
        // 构造主键
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("CHGPLUGNO", PrimaryKeyValue.fromString((String) chargeplugLoadMap.get("CHGPLUGNO")));        // 分片键
        primaryKeyBuilder.addPrimaryKeyColumn("LOADTIME", PrimaryKeyValue.fromString((String) chargeplugLoadMap.get("LOADTIME")));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowPutChange rowPutChange = new RowPutChange("LOAD_CHG_PLUG", primaryKey);
        //加入一些属性列
        rowPutChange.addColumn(new Column("LOADVALUE", ColumnValue.fromDouble((Double) chargeplugLoadMap.get("LOADVALUE")), timestamp));
        PutRowRequest putRowRequest = new PutRowRequest(rowPutChange);
        ebikeTableStoreTemplate.putRowSync(putRowRequest);

        BigDecimal curPower = new BigDecimal(chargeplugLoadMap.get("LOADVALUE") != null ? chargeplugLoadMap.get("LOADVALUE").toString() : "0.0");
        Date curPowerTime = new Date();
        String chargeplugNo = (String) chargeplugLoadMap.get("CHGPLUGNO");
//        if(logger.isInfoEnabled()) {
//            logger.info("curPower           : " + curPower);
//            logger.info("curPowerTime       : " + curPowerTime);
//            logger.info("chargeplugNo       : " + chargeplugNo);
//        }
        String sql = "UPDATE ebike.ebike_chargeplug_ops ops INNER JOIN cisp_dev.dev_ebikechargeplug ecp ON ecp.id = ops.chargeplugId SET ops.curPower = ?, ops.curPowerTime = ? WHERE ecp.chargeplugNo = ? ";
        ebikeJdbcTemplate.update(sql, curPower, curPowerTime, chargeplugNo);
    }

    @Override
    public void saveChargeorderLoadMap(Map<String, Object> chargeorderLoadMap) {
//        if(logger.isInfoEnabled()) {
//            logger.info(" >>>>>>> saveChargeorderLoadMap >>>>>>> ");
//            logger.info(" chargeorderLoadMap   : " + JsonConvertUtils.convertToString(chargeorderLoadMap));
//        }
        long timestamp = new Date().getTime();
        // 构造主键
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("CHGORDERNO", PrimaryKeyValue.fromString((String) chargeorderLoadMap.get("CHGORDERNO")));     // 分片键
        primaryKeyBuilder.addPrimaryKeyColumn("LOADTIME", PrimaryKeyValue.fromString((String) chargeorderLoadMap.get("LOADTIME")));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowPutChange rowPutChange = new RowPutChange("LOAD_CHG_ORDER", primaryKey);
        //加入一些属性列
        rowPutChange.addColumn(new Column("LOADVALUE", ColumnValue.fromDouble((Double) chargeorderLoadMap.get("LOADVALUE")), timestamp));
        PutRowRequest putRowRequest = new PutRowRequest(rowPutChange);
        ebikeTableStoreTemplate.putRowSync(putRowRequest);
    }

}
