package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.*;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.ChargeRecordDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import java.sql.*;
import java.util.*;
import java.util.Date;

/**
 *
 */
public class ChargeRecordDaoImpl implements ChargeRecordDao {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final RowMapper<ChargeRecord> crRowMapper = (rs, rowNum) -> {
        ChargeRecord cr = new ChargeRecord();
        cr.setChargeRecordId(rs.getString("chargeRecordId"));
        cr.setChargeUserId(rs.getString("chargeUserId"));
        cr.setChargeUserNo(rs.getString("chargeUserNo"));
        cr.setChargeUserType(rs.getString("chargeUserType"));
        cr.setMerchantNo(rs.getString("merchantNo"));
        cr.setDeviceId(rs.getString("deviceId"));
        cr.setPlugId(rs.getString("plugId"));
        cr.setOrgNo(rs.getString("subburo"));
        cr.setChargestationId(rs.getLong("chargestationId"));
        cr.setChargestationName(rs.getString("chargestationName"));
        cr.setChargestationAddr(rs.getString("chargestationAddr"));
        cr.setChargedeviceNo(rs.getString("chargedeviceNo"));
        cr.setPlugSn(rs.getInt("plugSn"));
        cr.setChargeTime(rs.getTimestamp("chargeTime"));
        cr.setChargeMoney(rs.getDouble("chargeMoney"));
        cr.setCoinMoney(rs.getDouble("coinMoney"));
        cr.setChargeTradeOrderId(rs.getString("chargeTradeOrderId"));
        cr.setEnterUserType(rs.getString("enterUserType"));
        cr.setEnterUserId(rs.getString("enterUserId"));
        cr.setServiceRate(rs.getDouble("serviceRate"));
        cr.setSchemeId(rs.getString("schemeId"));
        cr.setSchemeType(rs.getString("schemeType"));
        cr.setUnitPrice1(rs.getDouble("unitPrice1"));
        cr.setUnitPrice2(rs.getDouble("unitPrice2"));
        cr.setUnitPrice3(rs.getDouble("unitPrice3"));
        cr.setUnitPrice4(rs.getDouble("unitPrice4"));
        cr.setUnitPrice5(rs.getDouble("unitPrice5"));
        cr.setStepCount(rs.getInt("stepCount"));
        cr.setStepPower1(rs.getInt("stepPower1"));
        cr.setStepPower2(rs.getInt("stepPower2"));
        cr.setStepPower3(rs.getInt("stepPower3"));
        cr.setStepPower4(rs.getInt("stepPower4"));
        cr.setMinCharge(rs.getDouble("minCharge"));
        cr.setIsReturn(rs.getString("isReturn"));
        cr.setClosingPeriod(rs.getInt("closingPeriod"));
        cr.setCostSchemeId(rs.getString("costSchemeId"));
        cr.setCostUnitPrice(rs.getDouble("costUnitPrice"));
        cr.setChargeOpenFlag(rs.getInt("chargeOpenFlag"));
        cr.setChargeOpenTime(rs.getTimestamp("chargeOpenTime"));
        cr.setFirstUnitPriceFlag(rs.getInt("firstUnitPriceFlag"));
        cr.setFirstChargeAmount(rs.getDouble("firstChargeAmount"));
        cr.setCurrUnitPriceFlag(rs.getInt("currUnitPriceFlag"));
        cr.setChargeAmount(rs.getDouble("chargeAmount"));
        cr.setUsageAmount(rs.getDouble("usageAmount"));
        cr.setSurplusAmount(rs.getDouble("surplusAmount"));
        cr.setUsageElecCons(rs.getDouble("usageElecCons"));
        cr.setRemainElecCons(rs.getDouble("remainElecCons"));
        cr.setRemainTime(rs.getDouble("remainTime"));
        cr.setMaxPower(rs.getDouble("maxPower"));
        cr.setMinPower(rs.getDouble("minPower"));
        cr.setAvgPower(rs.getDouble("avgPower"));
        cr.setCurrPower(isExistColumn(rs, "currPower") ? rs.getDouble("currPower") : null);
        cr.setUpdateTime(isExistColumn(rs, "updateTime") ? rs.getTimestamp("updateTime") : null);
        cr.setChargeFinishTime(isExistColumn(rs, "chargeFinishTime") ? rs.getTimestamp("chargeFinishTime") : null);
        cr.setFinishReason(isExistColumn(rs, "finishReason") ? rs.getString("finishReason") : null);
        cr.setFinishPower(isExistColumn(rs, "finishPower") ? rs.getDouble("finishPower") : null);
        cr.setClosingFlag(isExistColumn(rs, "closingFlag") ? rs.getString("closingFlag") : null);
        cr.setClosingMoney(isExistColumn(rs, "closingMoney") ? rs.getDouble("closingMoney") : null);
        cr.setClosingTime(isExistColumn(rs, "closingTime") ? rs.getTimestamp("closingTime") : null);
        cr.setReturnFlag(isExistColumn(rs, "returnFlag") ? rs.getString("returnFlag") : null);
        cr.setReturnMoney(isExistColumn(rs, "returnMoney") ? rs.getDouble("returnMoney") : null);
        cr.setReturnTime(isExistColumn(rs, "returnTime") ? rs.getTimestamp("returnTime") : null);
        cr.setReturnDesc(isExistColumn(rs, "returnDesc") ? rs.getString("returnDesc") : null);
        cr.setReturnTradeOrderId(isExistColumn(rs, "returnTradeOrderId") ? rs.getString("returnTradeOrderId") : null);
        cr.setReturnSuccessTime(isExistColumn(rs, "returnSuccessTime") ? rs.getTimestamp("returnSuccessTime") : null);
        cr.setIncome(isExistColumn(rs, "income") ? rs.getDouble("income") : null);
        cr.setCost(isExistColumn(rs, "cost") ? rs.getDouble("cost") : null);
        cr.setProfit(isExistColumn(rs, "profit") ? rs.getDouble("profit") : null);
        cr.setServiceMoney(isExistColumn(rs, "serviceMoney") ? rs.getDouble("serviceMoney") : null);
        cr.setIncomeExService(isExistColumn(rs, "incomeExService") ? rs.getDouble("incomeExService") : null);
        cr.setProfitExService(isExistColumn(rs, "profitExService") ? rs.getDouble("profitExService") : null);
        cr.setServiceFlag(isExistColumn(rs, "serviceFlag") ? rs.getString("serviceFlag") : null);
        cr.setServiceTime(isExistColumn(rs, "serviceTime") ? rs.getTimestamp("serviceTime") : null);
        cr.setServiceDesc(isExistColumn(rs, "serviceDesc") ? rs.getString("serviceDesc") : null);
        cr.setServiceTradeOrderId(isExistColumn(rs, "serviceTradeOrderId") ? rs.getString("serviceTradeOrderId") : null);
        cr.setServiceSuccessTime(isExistColumn(rs, "serviceSuccessTime") ? rs.getTimestamp("serviceSuccessTime") : null);
        cr.setRemark(isExistColumn(rs, "remark") ? rs.getString("remark") : null);
        cr.setIsCsRefund(isExistColumn(rs, "isCsRefund") ? rs.getString("isCsRefund") : null);
        cr.setCsworkorderId(isExistColumn(rs, "csworkorderId") ? rs.getString("csworkorderId") : null);
        cr.setCsrefundResult(isExistColumn(rs, "csrefundResult") ? rs.getString("csrefundResult") : null);
        cr.setCsrefundMoney(isExistColumn(rs, "csrefundMoney") ? rs.getDouble("csrefundMoney") : null);
        cr.setCsrefundTime(isExistColumn(rs, "csrefundTime") ? rs.getTimestamp("csrefundTime") : null);
        cr.setCsrefundTradeOrderId(isExistColumn(rs, "csrefundTradeOrderId") ? rs.getString("csrefundTradeOrderId") : null);
        cr.setTotalReturnMoney(isExistColumn(rs, "totalReturnMoney") ? rs.getDouble("totalReturnMoney") : null);
        cr.setSchemeDetails(isExistColumn(rs, "schemeDetails") ? rs.getString("schemeDetails") : null);
        return cr;
    };

    private final RowMapper<Map<String, Object>> mapRowMapper = (rs, rowNum) -> {
        ResultSetMetaData rsmd = rs.getMetaData();
        Map<String, Object> map = new HashMap<>();
        for(int i = 1; i <= rsmd.getColumnCount(); i++) {
            if(rs.getObject(i) != null) {
                switch(rsmd.getColumnType(i)) {
                    case Types.TINYINT:
                        if(rsmd.getScale(i) == 0 && rsmd.getPrecision(i) == 1) {
                            map.put(rsmd.getColumnLabel(i).trim(), rs.getBoolean(i));
                        }
                        else {
                            map.put(rsmd.getColumnLabel(i).trim(), rs.getInt(i));
                        }
                        break;
                    case Types.SMALLINT:
                        map.put(rsmd.getColumnLabel(i).trim(), rs.getInt(i));
                        break;
                    case Types.INTEGER:
                        map.put(rsmd.getColumnLabel(i).trim(), rs.getInt(i));
                        break;
                    case Types.BIGINT:
                        map.put(rsmd.getColumnLabel(i).trim(), rs.getLong(i));
                        break;
                    case Types.FLOAT:
                        map.put(rsmd.getColumnLabel(i).trim(), rs.getFloat(i));
                        break;
                    case Types.REAL:
                        map.put(rsmd.getColumnLabel(i).trim(), rs.getFloat(i));
                        break;
                    case Types.DOUBLE:
                        map.put(rsmd.getColumnLabel(i).trim(), rs.getDouble(i));
                        break;
                    case Types.DECIMAL:
                        if(rsmd.getScale(i) == 0) {
                            map.put(rsmd.getColumnLabel(i).trim(), rs.getBigDecimal(i).longValue());
                        }
                        else {
                            map.put(rsmd.getColumnLabel(i).trim(), rs.getBigDecimal(i).doubleValue());
                        }
                        break;
                    case Types.NUMERIC:
                        if(rsmd.getScale(i) == 0) {
                            map.put(rsmd.getColumnLabel(i).trim(), rs.getBigDecimal(i).longValue());
                        }
                        else {
                            map.put(rsmd.getColumnLabel(i).trim(), rs.getBigDecimal(i).doubleValue());
                        }
                        break;
                    case Types.DATE:
                        map.put(rsmd.getColumnLabel(i).trim(), new Date(rs.getDate(i).getTime()));
                        break;
                    case Types.TIME:
                        map.put(rsmd.getColumnLabel(i).trim(), new Date(rs.getTime(i).getTime()));
                        break;
                    case Types.TIMESTAMP:
                        map.put(rsmd.getColumnLabel(i).trim(), new Date(rs.getTimestamp(i).getTime()));
                        break;
                    default:
                        map.put(rsmd.getColumnLabel(i).trim(), rs.getString(i));
                        break;
                }
            }
        }
        return map;
    };

    private boolean isExistColumn(ResultSet rs, String columnName) {
        try {
            if(rs.findColumn(columnName) > 0 ) {
                return true;
            }
        }
        catch(SQLException _sqle) {
            return false;
        }

        return false;
    }

    private StringBuilder builderChargeRecordPreSQL(String tableName) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT ecd.deviceId, ecp.plugId, pss.buro, pss.subburo, ecs.chargestationNo, ecs.chargestationName, ecs.chargestationAddr, ecd.chargedeviceNo, ecp.plugSn, cu.chargeUserNo, cu.chargeUserType, cu.merchantNo, ecr.* ");
        sqlBuilder.append("  FROM ebike.").append(StringUtils.defaultIfBlank(tableName, "ebike_chargerecord_his")).append(" ecr ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargeplug ecp ON ecp.`id` = ecr.chargeplugId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.`id` = ecr.chargedeviceId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_powersystemresource pss ON pss.`id` = ecd.`id` AND pss.className = 'EBikeChargeDevice' ");
        sqlBuilder.append("  LEFT JOIN (SELECT s.id AS chargestationId, s.stationNo AS chargestationNo, p.name AS chargestationName, s.stationAddr AS chargestationAddr FROM cisp_dev.dev_ebikechargestation s, cisp_dev.dev_powersystemresource p WHERE p.id = s.id AND p.className = 'EBikeChargeStation') ecs ON ecs.chargestationId = ecr.chargestationId ");
        sqlBuilder.append("  LEFT JOIN ebike.ebike_chargeuser cu ON cu.chargeUserId = ecr.chargeUserId ");
        return sqlBuilder;
    }

    private final JdbcTemplate ebikeJdbcTemplate;

    public ChargeRecordDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public boolean checkIsCharging(String deviceId, String plugId) {
        StringBuilder sqlBuilder = new StringBuilder();
        List<Object> params = new ArrayList<>();
        sqlBuilder.append("SELECT COUNT(ecr.chargeplugId) AS CNT ");
        sqlBuilder.append("  FROM ebike.ebike_chargerecord ecr ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargeplug ecp ON ecp.id = ecr.chargeplugId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId ");
        sqlBuilder.append(" WHERE ecd.deviceId = ? ");
        params.add(deviceId);
        sqlBuilder.append("   AND ecp.plugSn = ? ");
        try {
            params.add(Integer.parseInt(plugId));
        }
        catch(NumberFormatException _nfe) {
            logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
            params.add(0);
        }
        int cnt = ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), Integer.class);
        return cnt > 0;
    }

    @Override
    public String getClosingFlag(String chargeRecordId, boolean setHandlingFlag) {
        String sql = "SELECT IFNULL(closingFlag, 'N') AS closingFlag FROM ebike.ebike_chargerecord_his WHERE chargeRecordId = ? ";
        String closingFlag;
        try {
            closingFlag = ebikeJdbcTemplate.queryForObject(sql, new Object[] {chargeRecordId}, String.class);
            if(setHandlingFlag && StringUtils.equals("L", closingFlag)) {
                String sqlUpdate = "UPDATE ebike.ebike_chargerecord_his ecr SET ecr.closingFlag = 'H' WHERE ecr.closingFlag = 'L' AND ecr.chargeRecordId = ? ";
                ebikeJdbcTemplate.update(sqlUpdate, chargeRecordId);
            }
        }
        catch(EmptyResultDataAccessException _erdae) {
            closingFlag = null;
        }
        return closingFlag;
    }

    @Override
    public String getReturnFlag(String chargeRecordId, boolean setHandlingFlag) {
        String sql = "SELECT IFNULL(returnFlag, 'N') AS returnFlag FROM ebike.ebike_chargerecord_his WHERE chargeRecordId = ? ";
        String returnFlag;
        try {
            returnFlag = ebikeJdbcTemplate.queryForObject(sql, new Object[] {chargeRecordId}, String.class);
            if(setHandlingFlag && StringUtils.equals("L", returnFlag)) {
                String sqlUpdate = "UPDATE ebike.ebike_chargerecord_his ecr SET ecr.returnFlag = 'H' WHERE ecr.closingFlag = 'Y' AND ecr.returnFlag = 'L' AND ecr.chargeRecordId = ? ";
                ebikeJdbcTemplate.update(sqlUpdate, chargeRecordId);
            }
        }
        catch(EmptyResultDataAccessException _erdae) {
            returnFlag = null;
        }
        return returnFlag;
    }

    @Override
    public Map<String, Object> getChargeRecordMap(String deviceId, String plugId) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> getChargeRecordMap >>>>>> ");
            logger.debug(" deviceId : " + deviceId);
            logger.debug(" plugId   : " + plugId);
        }
        StringBuilder sqlBuilder = new StringBuilder();
        List<Object> params = new ArrayList<>();
        sqlBuilder.append("SELECT ecr.* ");
        sqlBuilder.append("  FROM ebike.ebike_chargerecord ecr ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargeplug ecp ON ecp.id = ecr.chargeplugId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId ");
        sqlBuilder.append(" WHERE ecd.deviceId = ? ");
        params.add(deviceId);
        sqlBuilder.append("   AND ecp.plugSn = ? ");
        try {
            params.add(Integer.parseInt(plugId));
        }
        catch(NumberFormatException _nfe) {
            logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
            params.add(0);
        }
        sqlBuilder.append(" LIMIT 1 ");
        Map<String, Object> chargeRecordMap;
        try {
            chargeRecordMap = ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), mapRowMapper);
        }
        catch(EmptyResultDataAccessException _erdae) {
            chargeRecordMap = null;
        }
        return chargeRecordMap;
    }

    @Override
    public List<ChargeRecord> getWaitingStartTimeoutChargeRecordList() {
        StringBuilder sqlBuilder = builderChargeRecordPreSQL("ebike_chargerecord");
        List<Object> params = new ArrayList<>();
        sqlBuilder.append(" WHERE ecr.chargeOpenFlag = ? ");
        params.add(1);                      // 为1表示充电等待中（等待主站回应）
        sqlBuilder.append("   AND ecr.updateTime >= ? ");
        params.add(DateUtils.addDays(new Date(), -60));
        sqlBuilder.append("   AND ecr.updateTime <= ? ");
        params.add(DateUtils.addMinutes(new Date(), -30));
        /*if(logger.isDebugEnabled()) {
            logger.debug("getWaitingStartTimeoutChargeRecordList");
            logger.debug("sqlBuilder : " + sqlBuilder.toString());
            logger.debug("params     : " + JsonConvertUtils.convertToString(params));
        }*/
        return ebikeJdbcTemplate.query(sqlBuilder.toString(), params.toArray(), crRowMapper);
    }

    @Override
    public List<ChargeRecord> getWaitingStopTimeoutChargeRecordList() {
        StringBuilder sqlBuilder = builderChargeRecordPreSQL("ebike_chargerecord");
        List<Object> params = new ArrayList<>();
        sqlBuilder.append(" WHERE ecr.chargeOpenFlag = ? ");
        params.add(0);                      // 为0表示充电开启成功
        sqlBuilder.append("   AND ecr.updateTime >= ? ");
        params.add(DateUtils.addDays(new Date(), -60));
        sqlBuilder.append("   AND ecr.updateTime <= ? ");
        params.add(DateUtils.addHours(new Date(), -6));
        /*if(logger.isDebugEnabled()) {
            logger.debug("getWaitingStopTimeoutChargeRecordList");
            logger.debug("sqlBuilder : " + sqlBuilder.toString());
            logger.debug("params     : " + JsonConvertUtils.convertToString(params));
        }*/
        return ebikeJdbcTemplate.query(sqlBuilder.toString(), params.toArray(), crRowMapper);
    }

    @Override
    public void lockWaitingTimeoutChargeRecordList(final List<ChargeRecord> chargeRecordList) {
        if(CollectionUtils.sizeIsNotEmptyIgnoreNull(chargeRecordList)) {
            String sql = "UPDATE ebike.ebike_chargerecord ecr SET ecr.updateTime = ? WHERE ecr.chargeRecordId = ? ";
            ebikeJdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter() {

                @Override
                public int getBatchSize() {
                    return chargeRecordList.size();
                }

                @Override
                public void setValues(PreparedStatement ps, int romNum) throws SQLException {
                    ChargeRecord chargeRecord = chargeRecordList.get(romNum);
                    ps.setTimestamp(1, new Timestamp(new Date().getTime()));
                    ps.setString(2, chargeRecord.getChargeRecordId());
                }

            });
        }
    }

    @Override
    public int insertChargeRecordByCoinsin(Map<String, Object> chargeRecordMap, String chargeplugNo) {
        if(!MapUtils.isEmpty(chargeRecordMap)) {
            String sql = "INSERT INTO ebike.ebike_chargerecord(chargeRecordId, chargeplugId, chargedeviceId, chargestationId, chargeUserId, chargeTime, chargePayMode, chargeMoney, coinMoney, chargeTradeOrderId, enterUserType, enterUserId, serviceRate, schemeId, schemeType, unitPrice1, unitPrice2, unitPrice3, unitPrice4, unitPrice5, stepCount, stepPower1, stepPower2, stepPower3, stepPower4, minCharge, isReturn, closingPeriod, costSchemeId, costUnitPrice, chargeOpenFlag, firstUnitPriceFlag, firstChargeAmount, currUnitPriceFlag, chargeAmount, usageAmount, surplusAmount, usageElecCons, remainElecCons, remainTime, updateTime) " +
                    "SELECT ?, ecp.id AS chargeplugId, ecd.id AS chargedeviceId, ecs.id AS chargestationId, ?, ?, 2 AS chargePayMode, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? " +
                    "  FROM cisp_dev.dev_ebikechargeplug ecp " +
                    " INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId " +
                    " INNER JOIN cisp_dev.dev_ebikechargestation ecs ON ecs.id = ecd.chargestationId " +
                    " WHERE ecp.chargeplugNo = ? ";
            List<Object> params = new ArrayList<>();
            params.add(chargeRecordMap.get("chargeRecordId"));
            params.add(chargeRecordMap.get("chargeUserId"));
            params.add(chargeRecordMap.get("chargeTime"));
            params.add(chargeRecordMap.get("chargeMoney"));
            params.add(chargeRecordMap.get("coinMoney"));
            params.add(chargeRecordMap.get("chargeTradeOrderId"));
            params.add(chargeRecordMap.get("enterUserType"));
            params.add(chargeRecordMap.get("enterUserId"));
            params.add(chargeRecordMap.get("serviceRate"));
            params.add(chargeRecordMap.get("schemeId"));
            params.add(chargeRecordMap.get("schemeType"));
            params.add(chargeRecordMap.get("unitPrice1"));
            params.add(chargeRecordMap.get("unitPrice2"));
            params.add(chargeRecordMap.get("unitPrice3"));
            params.add(chargeRecordMap.get("unitPrice4"));
            params.add(chargeRecordMap.get("unitPrice5"));
            params.add(chargeRecordMap.get("stepCount"));
            params.add(chargeRecordMap.get("stepPower1"));
            params.add(chargeRecordMap.get("stepPower2"));
            params.add(chargeRecordMap.get("stepPower3"));
            params.add(chargeRecordMap.get("stepPower4"));
            params.add(chargeRecordMap.get("minCharge"));
            params.add(chargeRecordMap.get("isReturn"));
            params.add(chargeRecordMap.get("closingPeriod"));
            params.add(chargeRecordMap.get("costSchemeId"));
            params.add(chargeRecordMap.get("costUnitPrice"));
            params.add(chargeRecordMap.get("chargeOpenFlag"));
            params.add(chargeRecordMap.get("firstUnitPriceFlag"));
            params.add(chargeRecordMap.get("firstChargeAmount"));
            params.add(chargeRecordMap.get("currUnitPriceFlag"));
            params.add(chargeRecordMap.get("chargeAmount"));
            params.add(chargeRecordMap.get("usageAmount"));
            params.add(chargeRecordMap.get("surplusAmount"));
            params.add(chargeRecordMap.get("usageElecCons"));
            params.add(chargeRecordMap.get("remainElecCons"));
            params.add(chargeRecordMap.get("remainTime"));
            params.add(new Date());                                     // updateTime
            params.add(chargeplugNo);
            return ebikeJdbcTemplate.update(sql, params.toArray());
        }
        return 0;
    }

    @Override
    public int insertChargeRecordByCard(Map<String, Object> chargeRecordMap, String chargeplugNo, String cardId) {
        if(!MapUtils.isEmpty(chargeRecordMap)) {
            String sql = "INSERT INTO ebike.ebike_chargerecord(chargeRecordId, chargeplugId, chargedeviceId, chargestationId, chargeUserId, chargeTime, chargePayMode, chargeMoney, coinMoney, card_id, chargeTradeOrderId, enterUserType, enterUserId, serviceRate, schemeId, schemeType, unitPrice1, unitPrice2, unitPrice3, unitPrice4, unitPrice5, stepCount, stepPower1, stepPower2, stepPower3, stepPower4, minCharge, isReturn, closingPeriod, costSchemeId, costUnitPrice, chargeOpenFlag, firstUnitPriceFlag, firstChargeAmount, currUnitPriceFlag, chargeAmount, usageAmount, surplusAmount, usageElecCons, remainElecCons, remainTime, updateTime) " +
                    "SELECT ?, ecp.id AS chargeplugId, ecd.id AS chargedeviceId, ecs.id AS chargestationId, ?, ?, 3 AS chargePayMode, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? " +
                    "  FROM cisp_dev.dev_ebikechargeplug ecp " +
                    " INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId " +
                    " INNER JOIN cisp_dev.dev_ebikechargestation ecs ON ecs.id = ecd.chargestationId " +
                    " WHERE ecp.chargeplugNo = ? ";
            List<Object> params = new ArrayList<>();
            params.add(chargeRecordMap.get("chargeRecordId"));
            params.add(chargeRecordMap.get("chargeUserId"));
            params.add(chargeRecordMap.get("chargeTime"));
            params.add(chargeRecordMap.get("chargeMoney"));
            params.add(chargeRecordMap.get("coinMoney"));
            params.add(cardId);
            params.add(chargeRecordMap.get("chargeTradeOrderId"));
            params.add(chargeRecordMap.get("enterUserType"));
            params.add(chargeRecordMap.get("enterUserId"));
            params.add(chargeRecordMap.get("serviceRate"));
            params.add(chargeRecordMap.get("schemeId"));
            params.add(chargeRecordMap.get("schemeType"));
            params.add(chargeRecordMap.get("unitPrice1"));
            params.add(chargeRecordMap.get("unitPrice2"));
            params.add(chargeRecordMap.get("unitPrice3"));
            params.add(chargeRecordMap.get("unitPrice4"));
            params.add(chargeRecordMap.get("unitPrice5"));
            params.add(chargeRecordMap.get("stepCount"));
            params.add(chargeRecordMap.get("stepPower1"));
            params.add(chargeRecordMap.get("stepPower2"));
            params.add(chargeRecordMap.get("stepPower3"));
            params.add(chargeRecordMap.get("stepPower4"));
            params.add(chargeRecordMap.get("minCharge"));
            params.add(chargeRecordMap.get("isReturn"));
            params.add(chargeRecordMap.get("closingPeriod"));
            params.add(chargeRecordMap.get("costSchemeId"));
            params.add(chargeRecordMap.get("costUnitPrice"));
            params.add(chargeRecordMap.get("chargeOpenFlag"));
            params.add(chargeRecordMap.get("firstUnitPriceFlag"));
            params.add(chargeRecordMap.get("firstChargeAmount"));
            params.add(chargeRecordMap.get("currUnitPriceFlag"));
            params.add(chargeRecordMap.get("chargeAmount"));
            params.add(chargeRecordMap.get("usageAmount"));
            params.add(chargeRecordMap.get("surplusAmount"));
            params.add(chargeRecordMap.get("usageElecCons"));
            params.add(chargeRecordMap.get("remainElecCons"));
            params.add(chargeRecordMap.get("remainTime"));
            params.add(new Date());                                     // updateTime
            params.add(chargeplugNo);
            return ebikeJdbcTemplate.update(sql, params.toArray());
        }
        return 0;
    }

    @Override
    public int insertChargeRecordByCustCard(Map<String, Object> chargeRecordMap, String chargeplugNo, String cardId) {
        if(!MapUtils.isEmpty(chargeRecordMap)) {
            String sql = "INSERT INTO ebike.ebike_chargerecord(chargeRecordId, chargeplugId, chargedeviceId, chargestationId, chargeUserId, chargeTime, chargePayMode, chargeMoney, coinMoney, card_id, chargeTradeOrderId, enterUserType, enterUserId, serviceRate, schemeId, schemeType, unitPrice1, unitPrice2, unitPrice3, unitPrice4, unitPrice5, stepCount, stepPower1, stepPower2, stepPower3, stepPower4, minCharge, isReturn, closingPeriod, costSchemeId, costUnitPrice, chargeOpenFlag, firstUnitPriceFlag, firstChargeAmount, currUnitPriceFlag, chargeAmount, usageAmount, surplusAmount, usageElecCons, remainElecCons, remainTime, updateTime) " +
                    "SELECT ?, ecp.id AS chargeplugId, ecd.id AS chargedeviceId, ecs.id AS chargestationId, ?, ?, 4 AS chargePayMode, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? " +
                    "  FROM cisp_dev.dev_ebikechargeplug ecp " +
                    " INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId " +
                    " INNER JOIN cisp_dev.dev_ebikechargestation ecs ON ecs.id = ecd.chargestationId " +
                    " WHERE ecp.chargeplugNo = ? ";
            List<Object> params = new ArrayList<>();
            params.add(chargeRecordMap.get("chargeRecordId"));
            params.add(chargeRecordMap.get("chargeUserId"));
            params.add(chargeRecordMap.get("chargeTime"));
            params.add(chargeRecordMap.get("chargeMoney"));
            params.add(chargeRecordMap.get("coinMoney"));
            params.add(cardId);
            params.add(chargeRecordMap.get("chargeTradeOrderId"));
            params.add(chargeRecordMap.get("enterUserType"));
            params.add(chargeRecordMap.get("enterUserId"));
            params.add(chargeRecordMap.get("serviceRate"));
            params.add(chargeRecordMap.get("schemeId"));
            params.add(chargeRecordMap.get("schemeType"));
            params.add(chargeRecordMap.get("unitPrice1"));
            params.add(chargeRecordMap.get("unitPrice2"));
            params.add(chargeRecordMap.get("unitPrice3"));
            params.add(chargeRecordMap.get("unitPrice4"));
            params.add(chargeRecordMap.get("unitPrice5"));
            params.add(chargeRecordMap.get("stepCount"));
            params.add(chargeRecordMap.get("stepPower1"));
            params.add(chargeRecordMap.get("stepPower2"));
            params.add(chargeRecordMap.get("stepPower3"));
            params.add(chargeRecordMap.get("stepPower4"));
            params.add(chargeRecordMap.get("minCharge"));
            params.add(chargeRecordMap.get("isReturn"));
            params.add(chargeRecordMap.get("closingPeriod"));
            params.add(chargeRecordMap.get("costSchemeId"));
            params.add(chargeRecordMap.get("costUnitPrice"));
            params.add(chargeRecordMap.get("chargeOpenFlag"));
            params.add(chargeRecordMap.get("firstUnitPriceFlag"));
            params.add(chargeRecordMap.get("firstChargeAmount"));
            params.add(chargeRecordMap.get("currUnitPriceFlag"));
            params.add(chargeRecordMap.get("chargeAmount"));
            params.add(chargeRecordMap.get("usageAmount"));
            params.add(chargeRecordMap.get("surplusAmount"));
            params.add(chargeRecordMap.get("usageElecCons"));
            params.add(chargeRecordMap.get("remainElecCons"));
            params.add(chargeRecordMap.get("remainTime"));
            params.add(new Date());                                     // updateTime
            params.add(chargeplugNo);
            return ebikeJdbcTemplate.update(sql, params.toArray());
        }
        return 0;
    }

    @Override
    public void updateChargeRecord(String deviceId, String plugId, Map<String, Object> valueMap) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> updateChargeRecord >>>>>> ");
            logger.debug(" deviceId : " + deviceId);
            logger.debug(" plugId   : " + plugId);
            logger.debug(" valueMap : " + JsonConvertUtils.convertToString(valueMap));
        }
        if(MapUtils.isNotEmpty(valueMap)) {
            StringBuilder sqlBuilderUpdate = new StringBuilder();
            List<Object> paramsUpdate = new ArrayList<>();
            sqlBuilderUpdate.append("UPDATE ebike.ebike_chargerecord ecr ");
            sqlBuilderUpdate.append(" INNER JOIN cisp_dev.dev_ebikechargeplug ecp ON ecp.id = ecr.chargeplugId ");
            sqlBuilderUpdate.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId ");
            sqlBuilderUpdate.append("   SET ecr.updateTime = ? ");
            paramsUpdate.add(new Date());
            if(valueMap.get("chargeOpenFlag") != null) {
                sqlBuilderUpdate.append("     , ecr.chargeOpenFlag = ? ");
                paramsUpdate.add(valueMap.get("chargeOpenFlag"));
            }
            if(valueMap.get("chargeOpenTime") != null) {
                sqlBuilderUpdate.append("     , ecr.chargeOpenTime = ? ");
                paramsUpdate.add(valueMap.get("chargeOpenTime"));
            }
            if(valueMap.get("reopeningFlag") != null) {
                sqlBuilderUpdate.append("     , ecr.reopeningFlag = ? ");
                paramsUpdate.add(valueMap.get("reopeningFlag"));
            }
            if(valueMap.get("reopens") != null) {
                sqlBuilderUpdate.append("     , ecr.reopens = ? ");
                paramsUpdate.add(valueMap.get("reopens"));
            }
            if(valueMap.get("currUnitPriceFlag") != null) {
                sqlBuilderUpdate.append("     , ecr.currUnitPriceFlag = ? ");
                paramsUpdate.add(valueMap.get("currUnitPriceFlag"));
            }
            if(valueMap.get("chargeAmount") != null) {
                sqlBuilderUpdate.append("     , ecr.chargeAmount = ? ");
                paramsUpdate.add(valueMap.get("chargeAmount"));
            }
            if(valueMap.get("usageAmount") != null) {
                sqlBuilderUpdate.append("     , ecr.usageAmount = ? ");
                paramsUpdate.add(valueMap.get("usageAmount"));
            }
            if(valueMap.get("surplusAmount") != null) {
                sqlBuilderUpdate.append("     , ecr.surplusAmount = ? ");
                paramsUpdate.add(valueMap.get("surplusAmount"));
            }
            if(valueMap.get("usageElecCons") != null) {
                sqlBuilderUpdate.append("     , ecr.usageElecCons = ? ");
                paramsUpdate.add(valueMap.get("usageElecCons"));
            }
            if(valueMap.get("remainElecCons") != null) {
                sqlBuilderUpdate.append("     , ecr.remainElecCons = ? ");
                paramsUpdate.add(valueMap.get("remainElecCons"));
            }
            if(valueMap.get("remainTime") != null) {
                sqlBuilderUpdate.append("     , ecr.remainTime = ? ");
                paramsUpdate.add(valueMap.get("remainTime"));
            }
            if(valueMap.get("curPower") != null) {
                sqlBuilderUpdate.append("     , ecr.curPower = ? ");
                paramsUpdate.add(valueMap.get("curPower"));
            }
            if(valueMap.get("maxPower") != null) {
                sqlBuilderUpdate.append("     , ecr.maxPower = ? ");
                paramsUpdate.add(valueMap.get("maxPower"));
            }
            if(valueMap.get("maxPowerTime") != null) {
                sqlBuilderUpdate.append("     , ecr.maxPowerTime = ? ");
                paramsUpdate.add(valueMap.get("maxPowerTime"));
            }
            if(valueMap.get("minPower") != null) {
                sqlBuilderUpdate.append("     , ecr.minPower = ? ");
                paramsUpdate.add(valueMap.get("minPower"));
            }
            if(valueMap.get("minPowerTime") != null) {
                sqlBuilderUpdate.append("     , ecr.minPowerTime = ? ");
                paramsUpdate.add(valueMap.get("minPowerTime"));
            }
            if(valueMap.get("avgPower") != null) {
                sqlBuilderUpdate.append("     , ecr.avgPower = ? ");
                paramsUpdate.add(valueMap.get("avgPower"));
            }
            if(valueMap.get("statPowerCount") != null) {
                sqlBuilderUpdate.append("     , ecr.statPowerCount = ? ");
                paramsUpdate.add(valueMap.get("statPowerCount"));
            }
            if(valueMap.get("schemeDetails") != null) {
                sqlBuilderUpdate.append("     , ecr.schemeDetails = ? ");
                paramsUpdate.add(valueMap.get("schemeDetails"));
            }
            sqlBuilderUpdate.append(" WHERE ecd.deviceId = ? ");
            paramsUpdate.add(deviceId);
            sqlBuilderUpdate.append("   AND ecp.plugSn = ? ");
            try {
                paramsUpdate.add(Integer.parseInt(plugId));
            }
            catch(NumberFormatException _nfe) {
                logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
                paramsUpdate.add(0);
            }
            /*if(logger.isDebugEnabled()) {
                logger.debug("sqlBuilderUpdate : " + sqlBuilderUpdate.toString());
                logger.debug("paramsUpdate     : " + JsonConvertUtils.convertToString(paramsUpdate));
            }*/
            ebikeJdbcTemplate.update(sqlBuilderUpdate.toString(), paramsUpdate.toArray());
        }
    }

    @Override
    public void finishChargeRecord(String deviceId, String plugId, Map<String, Object> valueMap) {
        /*if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> finishChargeRecord >>>>>> ");
            logger.debug(" deviceId : " + deviceId);
            logger.debug(" plugId   : " + plugId);
            logger.debug(" valueMap : " + JsonConvertUtils.convertToString(valueMap));
        }*/
        String finishReason = null;
        Double finishPower = null;
        if(MapUtils.isNotEmpty(valueMap)) {
            finishReason = (String) valueMap.get("finishReason");
            finishPower = (Double) valueMap.get("finishPower");
        }
        StringBuilder sqlBuilderInsert = new StringBuilder();
        List<Object> paramsInsert = new ArrayList<>();
        sqlBuilderInsert.append("INSERT INTO ebike.ebike_chargerecord_his(chargeRecordId, chargeplugId, chargedeviceId, chargestationId, chargeUserId, chargeTime, chargePayMode, chargeMoney, coinMoney, card_id, chargeTradeOrderId, enterUserType, enterUserId, sharingReceivers, sharingMoneyFreezeCycle, serviceRate, schemeId, schemeType, unitPrice1, unitPrice2, unitPrice3, unitPrice4, unitPrice5, stepCount, stepPower1, stepPower2, stepPower3, stepPower4, minCharge, isReturn, closingPeriod, costSchemeId, costUnitPrice, chargeOpenFlag, chargeOpenTime, reopeningFlag, reopens, firstUnitPriceFlag, firstChargeAmount, currUnitPriceFlag, chargeAmount, usageAmount, surplusAmount, usageElecCons, remainElecCons, remainTime, maxPower, maxPowerTime, minPower, minPowerTime, avgPower, statPowerCount, finishReason, finishPower, chargeFinishTime,schemeDetails) ");
        sqlBuilderInsert.append("SELECT ecr.chargeRecordId, ecr.chargeplugId, ecr.chargedeviceId, ecr.chargestationId, ecr.chargeUserId, ecr.chargeTime, ecr.chargePayMode, ecr.chargeMoney, ecr.coinMoney, ecr.card_id, ecr.chargeTradeOrderId, ecr.enterUserType, ecr.enterUserId, ecr.sharingReceivers, ecr.sharingMoneyFreezeCycle, ecr.serviceRate, ecr.schemeId, ecr.schemeType, ecr.unitPrice1, ecr.unitPrice2, ecr.unitPrice3, ecr.unitPrice4, ecr.unitPrice5, ecr.stepCount, ecr.stepPower1, ecr.stepPower2, ecr.stepPower3, ecr.stepPower4, ecr.minCharge, ecr.isReturn, closingPeriod, ecr.costSchemeId, ecr.costUnitPrice, ecr.chargeOpenFlag, ecr.chargeOpenTime, ecr.reopeningFlag, ecr.reopens, ecr.firstUnitPriceFlag, ecr.firstChargeAmount, ecr.currUnitPriceFlag, ecr.chargeAmount, ecr.usageAmount, ecr.surplusAmount, ecr.usageElecCons, ecr.remainElecCons, ecr.remainTime, ecr.maxPower, ecr.maxPowerTime, ecr.minPower, ecr.minPowerTime, ecr.avgPower, ecr.statPowerCount, ?, ?, ?,schemeDetails  ");
        paramsInsert.add(finishReason);
        paramsInsert.add(finishPower);
        paramsInsert.add(new Date());
        sqlBuilderInsert.append("  FROM ebike.ebike_chargerecord ecr ");
        sqlBuilderInsert.append(" INNER JOIN cisp_dev.dev_ebikechargeplug ecp ON ecp.id = ecr.chargeplugId ");
        sqlBuilderInsert.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId ");
        sqlBuilderInsert.append(" WHERE ecd.deviceId = ? ");
        paramsInsert.add(deviceId);
        sqlBuilderInsert.append("   AND ecp.plugSn = ? ");
        try {
            paramsInsert.add(Integer.parseInt(plugId));
        }
        catch(NumberFormatException _nfe) {
            logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
            paramsInsert.add(0);
        }
        /*if(logger.isDebugEnabled()) {
            logger.debug("sqlBuilderInsert : " + sqlBuilderInsert.toString());
            logger.debug("paramsInsert     : " + JsonConvertUtils.convertToString(paramsInsert));
        }*/
        int resultInsert = ebikeJdbcTemplate.update(sqlBuilderInsert.toString(), paramsInsert.toArray());

        if(resultInsert > 0) {
            StringBuilder sqlBuilderDelete = new StringBuilder();
            List<Object> paramsDelete = new ArrayList<>();
            sqlBuilderDelete.append("DELETE ecr.* ");
            sqlBuilderDelete.append("  FROM ebike.ebike_chargerecord ecr ");
            sqlBuilderDelete.append(" INNER JOIN cisp_dev.dev_ebikechargeplug ecp ON ecp.id = ecr.chargeplugId ");
            sqlBuilderDelete.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId ");
            sqlBuilderDelete.append(" WHERE ecd.deviceId = ? ");
            paramsDelete.add(deviceId);
            sqlBuilderDelete.append("   AND ecp.plugSn = ? ");
            try {
                paramsDelete.add(Integer.parseInt(plugId));
            }
            catch(NumberFormatException _nfe) {
                logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
                paramsDelete.add(0);
            }
            /*if(logger.isDebugEnabled()) {
                logger.debug("sqlBuilderDelete : " + sqlBuilderDelete.toString());
                logger.debug("paramsDelete     : " + JsonConvertUtils.convertToString(paramsDelete));
            }*/
            ebikeJdbcTemplate.update(sqlBuilderDelete.toString(), paramsDelete.toArray());
        }
    }

    @Override
    public List<ChargeRecord> getNotClosingChargeRecordList() {
        StringBuilder sqlBuilder = builderChargeRecordPreSQL("ebike_chargerecord_his");
        List<Object> params = new ArrayList<>();
        sqlBuilder.append(" WHERE ecr.closingFlag = ? ");
        params.add("N");                        // N 未结算
        sqlBuilder.append("   AND ecr.chargeFinishTime >= ? ");
        params.add(DateUtils.addDays(new Date(), -7));
        //params.add(DateUtils.addHours(new Date(), -1));
        /*if(logger.isDebugEnabled()) {
            logger.debug("getNotClosingChargeRecordList");
            logger.debug("sqlBuilder : " + sqlBuilder.toString());
            logger.debug("params     : " + JsonConvertUtils.convertToString(params));
        }*/
        return ebikeJdbcTemplate.query(sqlBuilder.toString(), params.toArray(), crRowMapper);
    }

    @Override
    public void lockNotClosingChargeRecordList(final List<ChargeRecord> chargeRecordList) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>>>>> start lockNotClosingChargeRecordList >>>>>>>>>> ");
            logger.debug(" chargeRecordList : " + JsonConvertUtils.convertToString(chargeRecordList));
        }
        if(CollectionUtils.sizeIsNotEmptyIgnoreNull(chargeRecordList)) {
            String sql = "UPDATE ebike.ebike_chargerecord_his ecr SET ecr.closingFlag = 'L' WHERE ecr.closingFlag = 'N' AND ecr.chargeRecordId = ? ";
            ebikeJdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter() {

                @Override
                public int getBatchSize() {
                    return chargeRecordList.size();
                }

                @Override
                public void setValues(PreparedStatement ps, int romNum) throws SQLException {
                    ChargeRecord chargeRecord = chargeRecordList.get(romNum);
                    ps.setString(1, chargeRecord.getChargeRecordId());
                }

            });
        }
    }

    @Override
    public void finshClosingChargeRecord(ChargeRecord chargeRecord) {
        if(ObjectUtils.isNotNull(chargeRecord) && StringUtils.isNotBlank(chargeRecord.getChargeRecordId())) {
            String sql = "UPDATE ebike.ebike_chargerecord_his ecr SET ecr.closingFlag = ?, ecr.closingMoney = ?, ecr.closingTime = ? WHERE ecr.chargeRecordId = ? ";
            ebikeJdbcTemplate.update(sql, chargeRecord.getClosingFlag(), chargeRecord.getClosingMoney(), chargeRecord.getClosingTime(), chargeRecord.getChargeRecordId());
        }
    }

    @Override
    public List<ChargeRecord> getNotReturnChargeRecordList() {
        StringBuilder sqlBuilder = builderChargeRecordPreSQL("ebike_chargerecord_his");
        List<Object> params = new ArrayList<>();
        sqlBuilder.append(" WHERE ecr.closingFlag = ? ");
        params.add("Y");                        // Y 已结算
        sqlBuilder.append("   AND ecr.returnFlag = ? ");
        params.add("N");                        // N 未退费
        sqlBuilder.append("   AND ecr.chargeFinishTime >= ? ");
        params.add(DateUtils.addDays(new Date(), -7));
        //params.add(DateUtils.addHours(new Date(), -1));
        /*if(logger.isDebugEnabled()) {
            logger.debug("getNotReturnChargeRecordList");
            logger.debug("sqlBuilder : " + sqlBuilder.toString());
            logger.debug("params     : " + JsonConvertUtils.convertToString(params));
        }*/
        return ebikeJdbcTemplate.query(sqlBuilder.toString(), params.toArray(), crRowMapper);
    }

    @Override
    public void lockNotReturnChargeRecordList(final List<ChargeRecord> chargeRecordList) {
        if(CollectionUtils.sizeIsNotEmptyIgnoreNull(chargeRecordList)) {
            String sql = "UPDATE ebike.ebike_chargerecord_his ecr SET ecr.returnFlag = 'L' WHERE ecr.closingFlag = 'Y' AND ecr.returnFlag = 'N' AND ecr.chargeRecordId = ? ";
            ebikeJdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter() {

                @Override
                public int getBatchSize() {
                    return chargeRecordList.size();
                }

                @Override
                public void setValues(PreparedStatement ps, int romNum) throws SQLException {
                    ChargeRecord chargeRecord = chargeRecordList.get(romNum);
                    ps.setString(1, chargeRecord.getChargeRecordId());
                }

            });
        }
    }

    @Override
    public void finshReturnChargeRecord(ChargeRecord chargeRecord) {
        if(ObjectUtils.isNotNull(chargeRecord) && StringUtils.isNotBlank(chargeRecord.getChargeRecordId())) {
            String sql = "UPDATE ebike.ebike_chargerecord_his ecr SET ecr.returnFlag = ?, ecr.returnMoney = ?, ecr.totalReturnMoney = ?, ecr.returnTime = ?, ecr.returnDesc = ?, ecr.returnTradeOrderId = ?, ecr.returnSuccessTime = ?, ecr.income = ?, ecr.cost = ?, ecr.profit = ?, ecr.serviceMoney = ?, ecr.incomeExService = ?, ecr.profitExService = ?, ecr.serviceFlag = ?, ecr.serviceTime = ?, ecr.serviceDesc = ?, ecr.serviceTradeOrderId = ?, ecr.serviceSuccessTime = ?, ecr.remark = ? WHERE ecr.chargeRecordId = ? ";
            ebikeJdbcTemplate.update(sql, chargeRecord.getReturnFlag(), chargeRecord.getReturnMoney(), chargeRecord.getTotalReturnMoney(), chargeRecord.getReturnTime(), chargeRecord.getReturnDesc(), chargeRecord.getReturnTradeOrderId(), chargeRecord.getReturnSuccessTime(), chargeRecord.getIncome(), chargeRecord.getCost(), chargeRecord.getProfit(), chargeRecord.getServiceMoney(), chargeRecord.getIncomeExService(), chargeRecord.getProfitExService(), chargeRecord.getServiceFlag(), chargeRecord.getServiceTime(), chargeRecord.getServiceDesc(), chargeRecord.getServiceTradeOrderId(), chargeRecord.getServiceSuccessTime(), chargeRecord.getRemark(), chargeRecord.getChargeRecordId());
        }
    }

    @Override
    public List<ChargeRecord> getBeReopeningChargeRecordList() {
        StringBuilder sqlBuilder = builderChargeRecordPreSQL("ebike_chargerecord");
        List<Object> params = new ArrayList<>();
        sqlBuilder.append(" WHERE ecr.chargeOpenFlag = ? ");
        params.add(1);                      // 为1表示充电等待中（等待主站回应）
        sqlBuilder.append("   AND ecr.chargePayMode = ? ");
        params.add("1");                    // 1 – 扫码支付（微信/支付宝）；
        sqlBuilder.append("   AND ecr.reopeningFlag = ? ");
        params.add("N");                    // N 未重新开启
        sqlBuilder.append("   AND ecr.chargeTime >= ? ");
        params.add(DateUtils.addSeconds(new Date(), -60));
        sqlBuilder.append("   AND ecr.chargeTime <= ? ");
        params.add(DateUtils.addSeconds(new Date(), -6));
        /*if(logger.isDebugEnabled()) {
            logger.debug("getWaitingStartTimeoutChargeRecordList");
            logger.debug("sqlBuilder : " + sqlBuilder.toString());
            logger.debug("params     : " + JsonConvertUtils.convertToString(params));
        }*/
        return ebikeJdbcTemplate.query(sqlBuilder.toString(), params.toArray(), crRowMapper);
    }

    @Override
    public void lockBeReopeningChargeRecordList(List<ChargeRecord> chargeRecordList) {
        if(CollectionUtils.sizeIsNotEmptyIgnoreNull(chargeRecordList)) {
            String sql = "UPDATE ebike.ebike_chargerecord ecr SET ecr.reopeningFlag = 'L' WHERE ecr.chargeRecordId = ? ";
            ebikeJdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter() {

                @Override
                public int getBatchSize() {
                    return chargeRecordList.size();
                }

                @Override
                public void setValues(PreparedStatement ps, int romNum) throws SQLException {
                    ChargeRecord chargeRecord = chargeRecordList.get(romNum);
                    ps.setString(1, chargeRecord.getChargeRecordId());
                }

            });
        }
    }

    @Override
    public ChargeRecord getBeChargingRecord(String chargeRecordId) {
        StringBuilder sqlBuilder = builderChargeRecordPreSQL("ebike_chargerecord");
        List<Object> params = new ArrayList<>();
        sqlBuilder.append(" WHERE ecr.chargeRecordId = ? ");
        params.add(chargeRecordId);
        ChargeRecord chargeRecord;
        try {
            chargeRecord = ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), crRowMapper);
        }
        catch(EmptyResultDataAccessException _erdae) {
            chargeRecord = new ChargeRecord();
        }
        return chargeRecord;
    }

    @Override
    public List<ChargeRecord> getBeChargingRecordList() {
        // TODO
        return new ArrayList<>();
    }

    @Override
    public ChargeRecord getBeChargingRecordByDeviceIdAndPlugId(String deviceId, String plugId) {
        // TODO
        return null;
    }

    @Override
    public ChargeRecord getHistroyChargeRecord(String chargeRecordId) {
        StringBuilder sqlBuilder = builderChargeRecordPreSQL("ebike_chargerecord_his");
        List<Object> params = new ArrayList<>();
        sqlBuilder.append(" WHERE ecr.chargeRecordId = ? ");
        params.add(chargeRecordId);
        ChargeRecord chargeRecord;
        try {
            chargeRecord = ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), crRowMapper);
        }
        catch(EmptyResultDataAccessException _erdae) {
            chargeRecord = new ChargeRecord();
        }
        return chargeRecord;
    }

    @Override
    public ChargeRecord getHistroyChargeRecordByTradeOrderId(String chargeTradeOrderId) {
        StringBuilder sqlBuilder = builderChargeRecordPreSQL("ebike_chargerecord_his");
        List<Object> params = new ArrayList<>();
        sqlBuilder.append(" WHERE ecr.chargeTradeOrderId = ? ");
        params.add(chargeTradeOrderId);
        sqlBuilder.append(" LIMIT 1 ");
        ChargeRecord chargeRecord;
        try {
            chargeRecord = ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), crRowMapper);
        }
        catch(EmptyResultDataAccessException _erdae) {
            chargeRecord = new ChargeRecord();
        }
        return chargeRecord;
    }

    @Override
    public ChargeRecord getHistroyChargeRecordByReturnTradeOrderId(String chargeTradeOrderId, String returnTradeOrderId) {
        StringBuilder sqlBuilder = builderChargeRecordPreSQL("ebike_chargerecord_his");
        List<Object> params = new ArrayList<>();
        sqlBuilder.append(" WHERE ecr.chargeTradeOrderId = ? AND ecr.returnTradeOrderId = ? ");
        params.add(chargeTradeOrderId);
        params.add(returnTradeOrderId);
        sqlBuilder.append(" LIMIT 1 ");
        ChargeRecord chargeRecord;
        try {
            chargeRecord = ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), crRowMapper);
        }
        catch(EmptyResultDataAccessException _erdae) {
            chargeRecord = new ChargeRecord();
        }
        return chargeRecord;
    }

    @Override
    public ChargeRecord getHistroyChargeRecordByCsrefundTradeOrderId(String chargeTradeOrderId, String csrefundTradeOrderId) {
        StringBuilder sqlBuilder = builderChargeRecordPreSQL("ebike_chargerecord_his");
        List<Object> params = new ArrayList<>();
        sqlBuilder.append(" WHERE ecr.chargeTradeOrderId = ? AND ecr.csrefundTradeOrderId = ? ");
        params.add(chargeTradeOrderId);
        params.add(csrefundTradeOrderId);
        sqlBuilder.append(" LIMIT 1 ");
        ChargeRecord chargeRecord;
        try {
            chargeRecord = ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), crRowMapper);
        }
        catch(EmptyResultDataAccessException _erdae) {
            chargeRecord = new ChargeRecord();
        }
        return chargeRecord;
    }

    @Override
    public String getCsrefundResult(String chargeRecordId, boolean setHandlingResult) {
        String sql = "SELECT IFNULL(csrefundResult, 'W') AS csrefundResult FROM ebike.ebike_chargerecord_his WHERE chargeRecordId = ? ";
        String csrefundResult;
        try {
            csrefundResult = ebikeJdbcTemplate.queryForObject(sql, new Object[] {chargeRecordId}, String.class);
            if(setHandlingResult && StringUtils.equals("L", csrefundResult)) {
                String sqlUpdate = "UPDATE ebike.ebike_chargerecord_his ecr SET ecr.csrefundResult = 'H' WHERE ecr.closingFlag = 'Y' AND ecr.returnFlag IN ('Y', 'D', 'F') AND ecr.csrefundResult = 'L' AND ecr.chargeRecordId = ? ";
                ebikeJdbcTemplate.update(sqlUpdate, chargeRecordId);
            }
        }
        catch(EmptyResultDataAccessException _erdae) {
            csrefundResult = null;
        }
        return csrefundResult;
    }

    @Override
    public String getCscReturnHandleResult(ChargeRecord chargeRecord) {
        String sql = "SELECT IFNULL(returnHandleResult, 'N') AS returnHandleResult FROM ebike.csc_workorder_his WHERE csworkorderId = ? ";
        String returnHandleResult;
        try {
            returnHandleResult = ebikeJdbcTemplate.queryForObject(sql, new Object[] {chargeRecord.getCsworkorderId()}, String.class);
        }
        catch(EmptyResultDataAccessException _erdae) {
            returnHandleResult = null;
        }
        return returnHandleResult;
    }

    @Override
    public List<ChargeRecord> getWaitingCsrefundChargeRecordList() {
        StringBuilder sqlBuilder = builderChargeRecordPreSQL("ebike_chargerecord_his");
        List<Object> params = new ArrayList<>();
        sqlBuilder.append(" WHERE ecr.closingFlag = ? ");
        params.add("Y");                        // Y 已结算
        sqlBuilder.append("   AND ecr.chargeFinishTime >= ? ");
        params.add(DateUtils.addMonths(new Date(), -6));
        sqlBuilder.append("   AND ecr.returnFlag IN (?, ?, ?) ");
        params.add("Y");                        // Y 已退费
        params.add("D");                        // D 无需退费
        params.add("F");                        // F 退费失败
        sqlBuilder.append("   AND ecr.isCsRefund = ? ");
        params.add("Y");                        // Y 已申请
        sqlBuilder.append("   AND ecr.csrefundResult = ? ");
        params.add("W");                        // W 等待处理
        sqlBuilder.append("   AND EXISTS (SELECT 1 FROM ebike.csc_workorder_his cw WHERE cw.csworkorderId = ecr.csworkorderId AND cw.needReturn = 'Y') ");
        /*if(logger.isDebugEnabled()) {
            logger.debug("getNotReturnChargeRecordList");
            logger.debug("sqlBuilder : " + sqlBuilder.toString());
            logger.debug("params     : " + JsonConvertUtils.convertToString(params));
        }*/
        return ebikeJdbcTemplate.query(sqlBuilder.toString(), params.toArray(), crRowMapper);
    }

    @Override
    public void lockWaitingCsrefundChargeRecordList(List<ChargeRecord> chargeRecordList) {
        if(CollectionUtils.sizeIsNotEmptyIgnoreNull(chargeRecordList)) {
            String sql = "UPDATE ebike.ebike_chargerecord_his ecr SET ecr.csrefundResult = 'L' WHERE ecr.closingFlag = 'Y' AND ecr.returnFlag IN ('Y', 'D', 'F') AND ecr.csrefundResult = 'W' AND ecr.chargeRecordId = ? ";
            ebikeJdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter() {

                @Override
                public int getBatchSize() {
                    return chargeRecordList.size();
                }

                @Override
                public void setValues(PreparedStatement ps, int romNum) throws SQLException {
                    ChargeRecord chargeRecord = chargeRecordList.get(romNum);
                    ps.setString(1, chargeRecord.getChargeRecordId());
                }

            });
        }
    }

    @Override
    public void finshCsrefundChargeRecord(ChargeRecord chargeRecord) {
        if(ObjectUtils.isNotNull(chargeRecord) && StringUtils.isNotBlank(chargeRecord.getChargeRecordId())) {
            String sql = "UPDATE ebike.ebike_chargerecord_his ecr SET ecr.csrefundResult = ?, ecr.csrefundMoney = ?, ecr.totalReturnMoney = ?, ecr.csrefundTime = ?, ecr.csrefundTradeOrderId = ? WHERE ecr.chargeRecordId = ? ";
            ebikeJdbcTemplate.update(sql, chargeRecord.getCsrefundResult(), chargeRecord.getCsrefundMoney(), chargeRecord.getTotalReturnMoney(), chargeRecord.getCsrefundTime(), chargeRecord.getCsrefundTradeOrderId(), chargeRecord.getChargeRecordId());
        }
    }
}
