package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.impl;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.FitconnDebuggingDao;
import cn.yunrui.mqttclient.ebikesrv.common.utils.DateUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class FitconnDebuggingDaoImpl implements FitconnDebuggingDao {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final JdbcTemplate ebikeJdbcTemplate;

    public FitconnDebuggingDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public boolean checkIsDebugging(String deviceId, String plugId) {
        StringBuilder sqlBuilder = new StringBuilder();
        List<Object> params = new ArrayList<>();
        sqlBuilder.append("SELECT COUNT(elf.logId) AS CNT ");
        sqlBuilder.append("  FROM ebike.ebike_log_fitconndebugging elf ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargeplug ecp ON ecp.chargeplugNo = elf.chargeplugNo ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId ");
        sqlBuilder.append(" WHERE (elf.debugOpenTime IS NULL OR elf.debugFinishTime IS NULL) ");
        sqlBuilder.append("   AND ecd.deviceId = ? ");
        params.add(deviceId);
        sqlBuilder.append("   AND ecp.plugSn = ? ");
        try {
            params.add(Integer.parseInt(plugId));
        }
        catch(NumberFormatException _nfe) {
            logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
            params.add(0);
        }
        int cnt = ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), params.toArray(), Integer.class);
        return cnt > 0;
    }

    @Override
    public void updateFitconnDebuggingLog(String deviceId, String plugId, Map<String, Object> valueMap) {
        if(MapUtils.isNotEmpty(valueMap)) {
            StringBuilder sqlBuilderUpdate = new StringBuilder();
            List<Object> paramsUpdate = new ArrayList<>();
            sqlBuilderUpdate.append("UPDATE ebike.ebike_log_fitconndebugging elf ");
            sqlBuilderUpdate.append(" INNER JOIN cisp_dev.dev_ebikechargeplug ecp ON ecp.chargeplugNo = elf.chargeplugNo ");
            sqlBuilderUpdate.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId ");
            sqlBuilderUpdate.append("   SET elf.debugTime = elf.debugTime ");
            if(valueMap.get("debugOpenTime") != null) {
                sqlBuilderUpdate.append("     , elf.debugOpenTime = ? ");
                paramsUpdate.add(valueMap.get("debugOpenTime"));
            }
            sqlBuilderUpdate.append(" WHERE (elf.debugOpenTime IS NULL) ");
            sqlBuilderUpdate.append("   AND ecd.deviceId = ? ");
            paramsUpdate.add(deviceId);
            sqlBuilderUpdate.append("   AND ecp.plugSn = ? ");
            try {
                paramsUpdate.add(Integer.parseInt(plugId));
            }
            catch(NumberFormatException _nfe) {
                logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
                paramsUpdate.add(0);
            }
            ebikeJdbcTemplate.update(sqlBuilderUpdate.toString(), paramsUpdate.toArray());
        }
    }

    @Override
    public void finishFitconnDebuggingLog(String deviceId, String plugId, Map<String, Object> valueMap) {
        if(MapUtils.isNotEmpty(valueMap)) {
            StringBuilder sqlBuilderUpdate = new StringBuilder();
            List<Object> paramsUpdate = new ArrayList<>();
            sqlBuilderUpdate.append("UPDATE ebike.ebike_log_fitconndebugging elf ");
            sqlBuilderUpdate.append(" INNER JOIN cisp_dev.dev_ebikechargeplug ecp ON ecp.chargeplugNo = elf.chargeplugNo ");
            sqlBuilderUpdate.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId ");
            sqlBuilderUpdate.append("  LEFT JOIN ebike.ebike_chargeplug_debuginfo di ON di.chargeplugId = ecp.id ");
            sqlBuilderUpdate.append("   SET elf.debugTime = elf.debugTime ");
            if(valueMap.get("debugOpenTime") != null) {
                sqlBuilderUpdate.append("     , elf.debugOpenTime = ? ");
                paramsUpdate.add(valueMap.get("debugOpenTime"));
            }
            if(valueMap.get("debugFinishTime") != null) {
                sqlBuilderUpdate.append("     , elf.debugFinishTime = ? ");
                paramsUpdate.add(valueMap.get("debugFinishTime"));
            }
            sqlBuilderUpdate.append("     , elf.debugResult = di.debugResult ");
            sqlBuilderUpdate.append("     , elf.debugRemark = di.debugRemark ");
            sqlBuilderUpdate.append(" WHERE (elf.debugOpenTime IS NULL OR elf.debugFinishTime IS NULL) ");
            sqlBuilderUpdate.append("   AND ecd.deviceId = ? ");
            paramsUpdate.add(deviceId);
            sqlBuilderUpdate.append("   AND ecp.plugSn = ? ");
            try {
                paramsUpdate.add(Integer.parseInt(plugId));
            }
            catch(NumberFormatException _nfe) {
                logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
                paramsUpdate.add(0);
            }
            ebikeJdbcTemplate.update(sqlBuilderUpdate.toString(), paramsUpdate.toArray());
        }
    }

    @Override
    public void finishTimeoutFitconnDebuggingLog() {
        String sqlUpdate = "UPDATE ebike.ebike_log_fitconndebugging elf " +
                " INNER JOIN cisp_dev.dev_ebikechargeplug ecp ON ecp.chargeplugNo = elf.chargeplugNo " +
                " INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId " +
                "  LEFT JOIN ebike.ebike_chargeplug_debuginfo di ON di.chargeplugId = ecp.id " +
                "   SET elf.debugOpenTime = IFNULL(elf.debugOpenTime, ?) " +
                "     , elf.debugFinishTime = IFNULL(elf.debugFinishTime, ?) " +
                "     , elf.debugResult = di.debugResult " +
                "     , elf.debugRemark = di.debugRemark " +
                " WHERE (elf.debugOpenTime IS NULL OR elf.debugFinishTime IS NULL) AND elf.debugTime < ? ";
        ebikeJdbcTemplate.update(sqlUpdate, new Date(), new Date(), DateUtils.addMinutes(new Date(), -12));
    }

}
