package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.impl;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MqttMsgLog;
import cn.yunrui.mqttclient.ebikesrv.tablestore.TableStoreTemplate;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 *
 */
public class MqttMsgLogDaoImpl implements MqttMsgLogDao {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final JdbcTemplate ebikeJdbcTemplate;
    private final TableStoreTemplate ebikeTableStoreTemplate;

    public MqttMsgLogDaoImpl(JdbcTemplate ebikeJdbcTemplate, TableStoreTemplate ebikeTableStoreTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
        this.ebikeTableStoreTemplate = ebikeTableStoreTemplate;
    }

    @Override
    public void insertMqttMsgLog(MqttMsgLog mqttMsgLog) {
        String sql = "INSERT INTO ebike.ebike_log_mqttmsg(deviceId, msgtime, payload, type, topic, qos, direction, action, mqttId, retained, duplicate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
        List<Object> params = new ArrayList<>();
        params.add(mqttMsgLog.getDeviceId());
        params.add(mqttMsgLog.getMsgtime());
        params.add(mqttMsgLog.getPayload());
        params.add(mqttMsgLog.getType());
        params.add(mqttMsgLog.getTopic());
        params.add(mqttMsgLog.getQos());
        params.add(mqttMsgLog.getDirection());
        params.add(mqttMsgLog.getAction());
        params.add(mqttMsgLog.getMqttId());
        params.add(mqttMsgLog.getRetained());
        params.add(mqttMsgLog.getDuplicate());
        ebikeJdbcTemplate.update(sql, params.toArray());
    }

    @Override
    public void insertMqttMsgLog(String topic, MqttMessage mqttMessage, String deviceId, String type, String direction, String action) {
        MqttMsgLog mqttMsgLog = new MqttMsgLog();
        mqttMsgLog.setDeviceId(deviceId);
        mqttMsgLog.setMsgtime(new Date());
        mqttMsgLog.setPayload(mqttMessage.getPayload());
        mqttMsgLog.setType(type);
        mqttMsgLog.setTopic(topic);
        mqttMsgLog.setQos(mqttMessage.getQos());
        mqttMsgLog.setDirection(direction);
        mqttMsgLog.setAction(action);
        mqttMsgLog.setMqttId(((long) mqttMessage.getId()));
        mqttMsgLog.setRetained(mqttMessage.isRetained());
        mqttMsgLog.setDuplicate(mqttMessage.isDuplicate());
        insertMqttMsgLog(mqttMsgLog);
    }

    @Override
    public void insertTestingMqttMsgLog(MqttMsgLog mqttMsgLog) {
        String sql = "INSERT INTO ebike.test_log_mqttmsg(deviceId, msgtime, payload, type, topic, qos, direction, action, mqttId, retained, duplicate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
        List<Object> params = new ArrayList<>();
        params.add(mqttMsgLog.getDeviceId());
        params.add(mqttMsgLog.getMsgtime());
        params.add(mqttMsgLog.getPayload());
        params.add(mqttMsgLog.getType());
        params.add(mqttMsgLog.getTopic());
        params.add(mqttMsgLog.getQos());
        params.add(mqttMsgLog.getDirection());
        params.add(mqttMsgLog.getAction());
        params.add(mqttMsgLog.getMqttId());
        params.add(mqttMsgLog.getRetained());
        params.add(mqttMsgLog.getDuplicate());
        ebikeJdbcTemplate.update(sql, params.toArray());
    }

    @Override
    public void insertTestingMqttMsgLog(String topic, MqttMessage mqttMessage, String deviceId, String type, String direction, String action) {
        MqttMsgLog mqttMsgLog = new MqttMsgLog();
        mqttMsgLog.setDeviceId(deviceId);
        mqttMsgLog.setMsgtime(new Date());
        mqttMsgLog.setPayload(mqttMessage.getPayload());
        mqttMsgLog.setType(type);
        mqttMsgLog.setTopic(topic);
        mqttMsgLog.setQos(mqttMessage.getQos());
        mqttMsgLog.setDirection(direction);
        mqttMsgLog.setAction(action);
        mqttMsgLog.setMqttId(((long) mqttMessage.getId()));
        mqttMsgLog.setRetained(mqttMessage.isRetained());
        mqttMsgLog.setDuplicate(mqttMessage.isDuplicate());
        insertTestingMqttMsgLog(mqttMsgLog);
    }

}
