package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.OpsWorkOrderDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.OpsWorkOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class OpsWorkOrderDaoImpl implements OpsWorkOrderDao {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final RowMapper<OpsWorkOrder> opswoRowMapper = (rs, rowNum) -> {
        OpsWorkOrder opsWorkOrder = new OpsWorkOrder();
        opsWorkOrder.setOpsworkorderId(rs.getString("opsworkorderId"));
        opsWorkOrder.setOpsworkorderType(rs.getString("opsworkorderType"));
        opsWorkOrder.setOpsworkorderStatus(rs.getString("opsworkorderStatus"));
        opsWorkOrder.setOpsObjectType(rs.getString("opsObjectType"));
        opsWorkOrder.setOpsObjectId(rs.getLong("opsObjectId"));
        opsWorkOrder.setCreateTime(rs.getTimestamp("createTime"));
        opsWorkOrder.setIsRecovery(rs.getString("isRecovery"));
        opsWorkOrder.setRecoveryTime(rs.getTimestamp("recoveryTime"));
        opsWorkOrder.setAssigner(rs.getString("assigner"));
        opsWorkOrder.setAssignTime(rs.getTimestamp("assignTime"));
        opsWorkOrder.setHandler(rs.getString("handler"));
        opsWorkOrder.setHandleTime(rs.getTimestamp("handleTime"));
        opsWorkOrder.setOpsworkorderDesc(rs.getString("opsworkorderDesc"));
        return opsWorkOrder;
    };

    private final JdbcTemplate ebikeJdbcTemplate;

    public OpsWorkOrderDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public void createOpsWorkOrder(OpsWorkOrder opsWorkOrder) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start createOpsWorkOrder >>>>>> ");
            logger.debug(" opsWorkOrder : " + JsonConvertUtils.convertToString(opsWorkOrder));
        }
        if(opsWorkOrder != null) {
            StringBuilder sqlBuilderInsert = new StringBuilder();
            List<Object> paramsInsert = new ArrayList<>();
            sqlBuilderInsert.append("INSERT INTO ebike.ops_workorder(opsworkorderId, opsworkorderType, opsworkorderStatus, opsObjectType, opsObjectId, createTime, isRecovery, opsworkorderDesc, chargedeviceNo, chargeplugNo, chargestationNo, chargestationName, chargestationAddr, orgNo, orgName, oppersonName, oppersonMobile) ");
            if(StringUtils.equals("EBikeChargeDevice", opsWorkOrder.getOpsObjectType())) {
                sqlBuilderInsert.append("SELECT ?, ?, ?, ?, ?, ?, ?, ?, ecd.chargedeviceNo, '' AS chargeplugNo, ecs.stationNo AS chargestationNo, psr.name AS chargestationName, ecs.stationAddr AS chargestationAddr, psr.subburo AS orgNo, org.org_name AS orgName, opp.oppersonName, opp.oppersonMobile ");
                sqlBuilderInsert.append("  FROM cisp_dev.dev_ebikechargedevice ecd ");
                sqlBuilderInsert.append("  LEFT JOIN cisp_dev.dev_ebikechargestation ecs ON ecs.id = ecd.chargestationId ");
                sqlBuilderInsert.append("  LEFT JOIN cisp_dev.dev_powersystemresource psr ON psr.id = ecs.id AND psr.className = 'EBikeChargeStation' ");
                sqlBuilderInsert.append("  LEFT JOIN cisp_sys.bp_org org ON org.org_no = psr.subburo ");
                sqlBuilderInsert.append("  LEFT JOIN ebike.ebike_cs_op_rela rela ON ecd.chargestationId = rela.chargestationId ");
                sqlBuilderInsert.append("  LEFT JOIN ebike.ebike_opperson opp ON opp.oppersonId = rela.oppersonId");
                sqlBuilderInsert.append(" WHERE ecd.id = ? ");
            }
            else if(StringUtils.equals("EBikeChargePlug", opsWorkOrder.getOpsObjectType())) {
                sqlBuilderInsert.append("SELECT ?, ?, ?, ?, ?, ?, ?, ?, ecd.chargedeviceNo, ecp.chargeplugNo, ecs.stationNo AS chargestationNo, psr.name AS chargestationName, ecs.stationAddr AS chargestationAddr, psr.subburo AS orgNo, org.org_name AS orgName, opp.oppersonName, opp.oppersonMobile ");
                sqlBuilderInsert.append("  FROM cisp_dev.dev_ebikechargeplug ecp ");
                sqlBuilderInsert.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId ");
                sqlBuilderInsert.append("  LEFT JOIN cisp_dev.dev_ebikechargestation ecs ON ecs.id = ecd.chargestationId ");
                sqlBuilderInsert.append("  LEFT JOIN cisp_dev.dev_powersystemresource psr ON psr.id = ecs.id AND psr.className = 'EBikeChargeStation' ");
                sqlBuilderInsert.append("  LEFT JOIN cisp_sys.bp_org org ON org.org_no = psr.subburo ");
                sqlBuilderInsert.append("  LEFT JOIN ebike.ebike_cs_op_rela rela ON ecd.chargestationId = rela.chargestationId ");
                sqlBuilderInsert.append("  LEFT JOIN ebike.ebike_opperson opp ON opp.oppersonId = rela.oppersonId");
                sqlBuilderInsert.append(" WHERE ecp.id = ? ");
            }
            paramsInsert.add(opsWorkOrder.getOpsworkorderId());
            paramsInsert.add(opsWorkOrder.getOpsworkorderType());
            paramsInsert.add(opsWorkOrder.getOpsworkorderStatus());
            paramsInsert.add(opsWorkOrder.getOpsObjectType());
            paramsInsert.add(opsWorkOrder.getOpsObjectId());
            paramsInsert.add(new Date());
            paramsInsert.add("N");
            paramsInsert.add(opsWorkOrder.getOpsworkorderDesc());
            paramsInsert.add(opsWorkOrder.getOpsObjectId());
            ebikeJdbcTemplate.update(sqlBuilderInsert.toString(), paramsInsert.toArray());
        }
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end createOpsWorkOrder <<<<<<< ");
        }
    }

    @Override
    public void recoveryOpsWorkOrder(OpsWorkOrder opsWorkOrder) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start recoveryOpsWorkOrder >>>>>> ");
            logger.debug(" opsWorkOrder : " + JsonConvertUtils.convertToString(opsWorkOrder));
        }
        if(opsWorkOrder != null && StringUtils.isNotBlank(opsWorkOrder.getOpsworkorderId())) {
            StringBuilder sqlBuilderUpdate = new StringBuilder();
            List<Object> paramsUpdate = new ArrayList<>();
            sqlBuilderUpdate.append("UPDATE ebike.ops_workorder ");
            sqlBuilderUpdate.append("   SET isRecovery = ? ");
            paramsUpdate.add("Y");
            sqlBuilderUpdate.append("     , recoveryTime = ? ");
            paramsUpdate.add(new Date());
            sqlBuilderUpdate.append("     , handler = ? ");
            paramsUpdate.add(opsWorkOrder.getHandler());
            sqlBuilderUpdate.append("     , handleTime = ? ");
            paramsUpdate.add(opsWorkOrder.getHandleTime());
            sqlBuilderUpdate.append("     , opsworkorderDesc = ? ");
            paramsUpdate.add(opsWorkOrder.getOpsworkorderDesc());
            sqlBuilderUpdate.append(" WHERE opsworkorderId = ? ");
            paramsUpdate.add(opsWorkOrder.getOpsworkorderId());
            sqlBuilderUpdate.append("   AND isRecovery = ? ");
            paramsUpdate.add("N");
            /*if(logger.isDebugEnabled()) {
                logger.debug("sqlBuilderUpdate : " + sqlBuilderUpdate.toString());
                logger.debug("paramsUpdate     : " + JsonConvertUtils.convertToString(paramsUpdate));
            }*/
            ebikeJdbcTemplate.update(sqlBuilderUpdate.toString(), paramsUpdate.toArray());
        }
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end recoveryOpsWorkOrder <<<<<<< ");
        }
    }

    @Override
    public void archiveOpsWorkOrder(OpsWorkOrder opsWorkOrder, Map<String, Object> archiveMap) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start archiveOpsWorkOrder >>>>>> ");
            logger.debug(" opsWorkOrder : " + JsonConvertUtils.convertToString(opsWorkOrder));
            logger.debug(" archiveMap   : " + JsonConvertUtils.convertToString(archiveMap));
        }
        if(opsWorkOrder != null && StringUtils.isNotBlank(opsWorkOrder.getOpsworkorderId())) {
            StringBuilder sqlBuilderInsert = new StringBuilder();
            List<Object> paramsInsert = new ArrayList<>();
            sqlBuilderInsert.append("INSERT INTO ebike.ops_workorder_his(opsworkorderId, opsworkorderType, opsworkorderStatus, opsObjectType, opsObjectId, createTime, isRecovery, recoveryTime, assigner, assignTime, handler, handleTime, archiver, archiveType, archiveTime, archiveDesc, archiveAttach, opsworkorderDesc, chargedeviceNo, chargeplugNo, chargestationNo, chargestationName, chargestationAddr, orgNo, orgName, oppersonName, oppersonMobile) ");
            sqlBuilderInsert.append("SELECT wo.opsworkorderId, wo.opsworkorderType, wo.opsworkorderStatus, wo.opsObjectType, wo.opsObjectId, wo.createTime, wo.isRecovery, wo.recoveryTime, wo.assigner, wo.assignTime, wo.handler, wo.handleTime, ?, ?, ?, ?, ?, wo.opsworkorderDesc, wo.chargedeviceNo, wo.chargeplugNo, wo.chargestationNo, wo.chargestationName, wo.chargestationAddr, wo.orgNo, wo.orgName, wo.oppersonName, wo.oppersonMobile ");
            paramsInsert.add(archiveMap != null && StringUtils.isNotBlank((String) archiveMap.get("archiver")) ? (String) archiveMap.get("archiver") : "unknown");
            paramsInsert.add(archiveMap != null && StringUtils.isNotBlank((String) archiveMap.get("archiveType")) ? (String) archiveMap.get("archiveType") : "10");
            paramsInsert.add(archiveMap != null && archiveMap.get("archiveTime") != null ? (Date) archiveMap.get("archiveTime") : new Date());
            paramsInsert.add(archiveMap != null && StringUtils.isNotBlank((String) archiveMap.get("archiveDesc")) ? (String) archiveMap.get("archiveDesc") : null);
            paramsInsert.add(archiveMap != null && StringUtils.isNotBlank((String) archiveMap.get("archiveAttach")) ? (String) archiveMap.get("archiveAttach") : null);
            sqlBuilderInsert.append("  FROM ebike.ops_workorder wo ");
            sqlBuilderInsert.append(" WHERE wo.opsworkorderId = ? ");
            paramsInsert.add(opsWorkOrder.getOpsworkorderId());
            /*if(logger.isDebugEnabled()) {
                logger.debug("sqlBuilderInsert : " + sqlBuilderInsert.toString());
                logger.debug("paramsInsert     : " + JsonConvertUtils.convertToString(paramsInsert));
            }*/
            int resultInsert = ebikeJdbcTemplate.update(sqlBuilderInsert.toString(), paramsInsert.toArray());
            if(resultInsert > 0) {
                String sqlDelete = "DELETE wo.* FROM ebike.ops_workorder wo WHERE wo.opsworkorderId = ? ";
                ebikeJdbcTemplate.update(sqlDelete, opsWorkOrder.getOpsworkorderId());
            }
        }
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end recoveryOpsWorkOrder <<<<<<< ");
        }
    }

    @Override
    public List<OpsWorkOrder> getOpsWorkOrderList(String deviceId, String plugId, String opsworkorderType, String isRecovery) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getOpsWorkOrderList >>>>>> ");
            logger.debug(" deviceId         : " + deviceId);
            logger.debug(" plugId           : " + plugId);
            logger.debug(" opsworkorderType : " + opsworkorderType);
            logger.debug(" isRecovery       : " + isRecovery);
        }
        StringBuilder sqlBuilder = new StringBuilder();
        List<Object> params = new ArrayList<>();
        sqlBuilder.append("SELECT wo.* FROM ebike.ops_workorder wo ");
        if(StringUtils.startsWith(opsworkorderType, "1")) {
            // 充电设备
            sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = wo.opsObjectId AND wo.opsObjectType = 'EBikeChargeDevice' ");
            sqlBuilder.append(" WHERE wo.isRecovery = ? AND wo.opsworkorderType = ? AND ecd.deviceId = ? ");
            params.add(isRecovery);
            params.add(opsworkorderType);
            params.add(deviceId);
        }
        else if(StringUtils.startsWith(opsworkorderType, "2")) {
            // 充电插座
            sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargeplug ecp ON ecp.id = wo.opsObjectId AND wo.opsObjectType = 'EBikeChargePlug' ");
            sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.id = ecp.chargedeviceId ");
            sqlBuilder.append(" WHERE wo.isRecovery = ? AND wo.opsworkorderType = ? AND ecd.deviceId = ? AND ecp.plugId = ? ");
            params.add(isRecovery);
            params.add(opsworkorderType);
            params.add(deviceId);
            params.add(plugId);
        }
        /*if(logger.isDebugEnabled()) {
            logger.debug("sqlBuilder : " + sqlBuilder.toString());
            logger.debug("params     : " + JsonConvertUtils.convertToString(params));
        }*/
        List<OpsWorkOrder> opsWorkOrderList = ebikeJdbcTemplate.query(sqlBuilder.toString(), params.toArray(), opswoRowMapper);
        if(logger.isDebugEnabled()) {
            logger.debug(" opsWorkOrderList : " + JsonConvertUtils.convertToString(opsWorkOrderList));
            logger.debug(" <<<<<<< end getOpsWorkOrderList <<<<<<< ");
        }
        return opsWorkOrderList;
    }

}
