package cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.impl;

import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.TestingDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.*;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TestingDaoImpl implements TestingDao {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final RowMapper<TestingChargeDevice> tcdRowMapper = (rs, rowNum) -> {
        TestingChargeDevice tcd = new TestingChargeDevice();
        tcd.setOrgNo(rs.getString("subburo"));
        tcd.setChargedeviceNo(rs.getString("chargedeviceNo"));
        tcd.setDeviceId(rs.getString("deviceId"));
        if(StringUtils.equals("mqtt.yjm2m", rs.getString("protocolType"))) {
            if(StringUtils.equals("201801", rs.getString("protocolVersion"))) {
                tcd.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.MQTT_YJM2M_201801);
            }
            else if(StringUtils.equals("201804", rs.getString("protocolVersion"))) {
                tcd.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.MQTT_YJM2M_201804);
            }
        }
        else if(StringUtils.equals("mqtt.ebike", rs.getString("protocolType"))) {
            if(StringUtils.equals("201804", rs.getString("protocolVersion"))) {
                tcd.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.MQTT_EBIKE_201804);
            }
            else if(StringUtils.equals("201805", rs.getString("protocolVersion"))) {
                tcd.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.MQTT_EBIKE_201805);
            }
        }
        if(tcd.getChargeDeviceProtocol() == null) {
            tcd.setChargeDeviceProtocol(ChargeDeviceProtocolEnum.UNKNOWN);
        }
        tcd.setPlugCount(rs.getInt("plugCount"));
        tcd.setFactory(rs.getString("factory"));
        tcd.setModelNo(rs.getString("modelNo"));
        tcd.setStatus(rs.getString("status"));
        tcd.setOpStatus(rs.getString("opStatus"));
        tcd.setBinder(rs.getString("binder"));
        if(rs.getTimestamp("bindTime") != null) {
            tcd.setBindTime(new Date(rs.getTimestamp("bindTime").getTime()));
        }
        tcd.setTestCount(rs.getInt("testCount"));
        tcd.setLatestTester(rs.getString("latestTester"));
        if(rs.getTimestamp("latestTestTime") != null) {
            tcd.setLatestTestTime(new Date(rs.getTimestamp("latestTestTime").getTime()));
        }
        tcd.setLatestTestResult(rs.getString("latestTestResult"));
        tcd.setLatestTestFailCause(rs.getString("latestTestFailCause"));
        if(rs.getTimestamp("importAssetTime") != null) {
            tcd.setImportAssetTime(new Date(rs.getTimestamp("importAssetTime").getTime()));
        }
        tcd.setImportAssetResult(rs.getString("importAssetResult"));
        tcd.setImportAssetFailCause(rs.getString("importAssetFailCause"));
        return tcd;
    };

    private final RowMapper<TestingChargePlug> tcpRowMapper = (rs, rowNum) -> {
        TestingChargePlug tcp = new TestingChargePlug();
        tcp.setOrgNo(rs.getString("subburo"));
        tcp.setChargedeviceNo(rs.getString("chargedeviceNo"));
        tcp.setPlugSn(rs.getInt("plugSn"));
        tcp.setTestStatus(rs.getString("testStatus"));
        tcp.setTestStatusDesc(rs.getString("testStatusDesc"));
        tcp.setTester(rs.getString("tester"));
        if(rs.getTimestamp("startTestTime") != null) {
            tcp.setStartTestTime(new Date(rs.getTimestamp("startTestTime").getTime()));
        }
        if(rs.getTimestamp("endTestTime") != null) {
            tcp.setEndTestTime(new Date(rs.getTimestamp("endTestTime").getTime()));
        }
        return tcp;
    };

    private final JdbcTemplate ebikeJdbcTemplate;

    public TestingDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public TestingChargeDevice getTestingChargeDeviceByDeviceId(String deviceId) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>>>>> getTestingChargeDeviceByDeviceId >>>>>>>>>> ");
            logger.debug(" deviceId : " + deviceId);
        }
        String sql = "SELECT tbd.* FROM ebike.test_binding_chargedevice tbd WHERE tbd.deviceId = ? LIMIT 1 ";
        TestingChargeDevice tcd = null;
        try {
            tcd = ebikeJdbcTemplate.queryForObject(sql, new Object[] {deviceId}, tcdRowMapper);
        }
        catch(EmptyResultDataAccessException _erdae) {
            tcd = null;
        }
        return tcd;
    }

    @Override
    public TestingChargeDevice getTestingChargeDeviceByChargedeviceNo(String chargedeviceNo) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>>>>> getTestingChargeDeviceByChargedeviceNo >>>>>>>>>> ");
            logger.debug(" chargedeviceNo : " + chargedeviceNo);
        }
        String sql = "SELECT tbd.* FROM ebike.test_binding_chargedevice tbd WHERE tbd.chargedeviceNo = ? LIMIT 1 ";
        TestingChargeDevice tcd = null;
        try {
            tcd = ebikeJdbcTemplate.queryForObject(sql, new Object[] {chargedeviceNo}, tcdRowMapper);
        }
        catch(EmptyResultDataAccessException _erdae) {
            tcd = null;
        }
        return tcd;
    }

    @Override
    public void insertTestingChargeDevice(TestingChargeDevice testingChargeDevice) {
        String sql = "INSERT INTO ebike.test_binding_chargedevice(buro, subburo, chargedeviceNo, deviceId, protocolType, protocolVersion, plugCount, factory, modelNo, status, opStatus, binder, bindTime, testCount, latestTestResult) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
        List<Object> params = new ArrayList<>();
        params.add(testingChargeDevice.getOrgNo());                                                         // buro
        params.add(testingChargeDevice.getOrgNo());                                                         // subburo
        params.add(testingChargeDevice.getChargedeviceNo());                                                // chargedeviceNo
        params.add(testingChargeDevice.getDeviceId());                                                      // deviceId
        params.add(testingChargeDevice.getChargeDeviceProtocol().getType());                                // protocolType
        params.add(testingChargeDevice.getChargeDeviceProtocol().getVersion());                             // protocolVersion
        params.add(testingChargeDevice.getPlugCount());                                                     // plugCount
        params.add(testingChargeDevice.getFactory());                                                       // factory
        params.add(testingChargeDevice.getModelNo());                                                       // modelNo
        params.add(testingChargeDevice.getStatus());                                                        // status
        params.add(testingChargeDevice.getOpStatus());                                                      // opStatus
        params.add(testingChargeDevice.getBinder());                                                        // binder
        params.add(testingChargeDevice.getBindTime());                                                      // bindTime
        params.add(testingChargeDevice.getTestCount());                                                     // testCount
        params.add(testingChargeDevice.getLatestTestResult());                                              // latestTestResult
        ebikeJdbcTemplate.update(sql, params.toArray());
    }

    @Override
    public void updateTestingChargeDevice(TestingChargeDevice testingChargeDevice) {
        String sql = "UPDATE ebike.test_binding_chargedevice SET status = ?, opStatus = ?, testCount = ?, latestTester = ?, latestTestTime = ?, latestTestResult = ?, latestTestFailCause = ?, importAssetTime = ?, importAssetResult = ?, importAssetFailCause = ? WHERE buro = ? AND subburo = ? AND chargedeviceNo = ? ";
        List<Object> params = new ArrayList<>();
        params.add(testingChargeDevice.getStatus());                                                        // status
        params.add(testingChargeDevice.getOpStatus());                                                      // opStatus
        params.add(testingChargeDevice.getTestCount());                                                     // testCount
        params.add(testingChargeDevice.getLatestTester());                                                  // latestTester
        params.add(testingChargeDevice.getLatestTestTime());                                                // latestTestTime
        params.add(testingChargeDevice.getLatestTestResult());                                              // latestTestResult
        params.add(testingChargeDevice.getLatestTestFailCause());                                           // latestTestFailCause
        params.add(testingChargeDevice.getImportAssetTime());                                               // importAssetTime
        params.add(testingChargeDevice.getImportAssetResult());                                             // importAssetResult
        params.add(testingChargeDevice.getImportAssetFailCause());                                          // importAssetFailCause
        params.add(testingChargeDevice.getOrgNo());                                                         // buro
        params.add(testingChargeDevice.getOrgNo());                                                         // subburo
        params.add(testingChargeDevice.getChargedeviceNo());                                                // chargedeviceNo
        ebikeJdbcTemplate.update(sql, params.toArray());
    }

    @Override
    public List<TestingChargePlug> getTestingChargePlugListByDeviceId(String deviceId) {
        String sql = "SELECT ttc.* FROM ebike.test_testing_chargeplug ttc INNER JOIN ebike.test_binding_chargedevice tbc ON tbc.buro = ttc.buro AND tbc.subburo = ttc.subburo AND tbc.chargedeviceNo = ttc.chargedeviceNo WHERE tbc.deviceId = ? ORDER BY ttc.plugSn";
        return ebikeJdbcTemplate.query(sql, new Object[] {deviceId}, tcpRowMapper);
    }

    @Override
    public List<TestingChargePlug> getTestingChargePlugListByChargedeviceNo(String chargedeviceNo) {
        String sql = "SELECT ttc.* FROM ebike.test_testing_chargeplug ttc WHERE ttc.chargedeviceNo = ? ORDER BY ttc.plugSn";
        return ebikeJdbcTemplate.query(sql, new Object[] {chargedeviceNo}, tcpRowMapper);
    }

    @Override
    public TestingChargePlug getTestingChargePlugByDeviceIdAndPlugSn(String deviceId, Integer plugSn) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>>>>> getTestingChargePlugByDeviceIdAndPlugSn >>>>>>>>>> ");
            logger.debug(" deviceId : " + deviceId);
            logger.debug(" plugSn   : " + plugSn);
        }
        String sql = "SELECT ttc.* FROM ebike.test_testing_chargeplug ttc INNER JOIN ebike.test_binding_chargedevice tbc ON tbc.buro = ttc.buro AND tbc.subburo = ttc.subburo AND tbc.chargedeviceNo = ttc.chargedeviceNo WHERE tbc.deviceId = ? AND ttc.plugSn = ? LIMIT 1 ";
        TestingChargePlug tcp = null;
        try {
            tcp = ebikeJdbcTemplate.queryForObject(sql, new Object[] {deviceId, plugSn}, tcpRowMapper);
        }
        catch(EmptyResultDataAccessException _erdae) {
            tcp = null;
        }
        return tcp;
    }

    @Override
    public TestingChargePlug getTestingChargePlugByChargedeviceNoAndPlugSn(String chargedeviceNo, Integer plugSn) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>>>>> getTestingChargePlugByDeviceIdAndPlugSn >>>>>>>>>> ");
            logger.debug(" chargedeviceNo   : " + chargedeviceNo);
            logger.debug(" plugSn           : " + plugSn);
        }
        String sql = "SELECT ttc.* FROM ebike.test_testing_chargeplug ttc WHERE ttc.chargedeviceNo = ? AND ttc.plugSn = ? LIMIT 1 ";
        TestingChargePlug tcp = null;
        try {
            tcp = ebikeJdbcTemplate.queryForObject(sql, new Object[] {chargedeviceNo, plugSn}, tcpRowMapper);
        }
        catch(EmptyResultDataAccessException _erdae) {
            tcp = null;
        }
        return tcp;
    }

    @Override
    public void updateTestingChargePlug(TestingChargePlug testingChargePlug) {
        String sql = "UPDATE ebike.test_testing_chargeplug SET testStatus = ?, testStatusDesc = ?, tester = ?, startTestTime = ?, endTestTime = ? WHERE buro = ? AND subburo = ? AND chargedeviceNo = ? AND plugSn = ? ";
        List<Object> params = new ArrayList<>();
        params.add(testingChargePlug.getTestStatus());                                                      // testStatus
        params.add(testingChargePlug.getTestStatusDesc());                                                  // testStatusDesc
        params.add(testingChargePlug.getTester());                                                          // tester
        params.add(testingChargePlug.getStartTestTime());                                                   // startTestTime
        params.add(testingChargePlug.getEndTestTime());                                                     // endTestTime
        params.add(testingChargePlug.getOrgNo());                                                           // buro
        params.add(testingChargePlug.getOrgNo());                                                           // subburo
        params.add(testingChargePlug.getChargedeviceNo());                                                  // chargedeviceNo
        params.add(testingChargePlug.getPlugSn());                                                          // plugSn
        ebikeJdbcTemplate.update(sql, params.toArray());
    }

}
